/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.thesaurus.models;

import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.thesaurus.ThesaurusDataProvider;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import org.chorem.vradi.ui.tree.VradiTreeTableNode;
import org.nuiton.i18n.I18n;

public class ThesaurusTreeTableModel
extends NavTreeTableModel.MyDefaultTreeTableModel {
    private static final Log log = LogFactory.getLog(ThesaurusTreeTableModel.class);
    protected ThesaurusDataProvider dataProvider;

    public ThesaurusTreeTableModel(ThesaurusDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Object getValueAt(Object value, int column) {
        Object result;
        VradiTreeTableNode node = (VradiTreeTableNode)((Object)value);
        RootThesaurus rootThesaurus = ThesaurusTreeTableHelper.getRootThesaurus(node);
        if (rootThesaurus != null) {
            result = this.getValueForRootThesaurus(rootThesaurus, column);
        } else {
            Thesaurus thesaurus = ThesaurusTreeTableHelper.getThesaurus(node);
            result = this.getValueForThesaurus(thesaurus, column);
        }
        return result;
    }

    public String[] getColumnsNames() {
        return new String[]{I18n._((String)"vradi.thesaurus.colomns.name", (Object[])new Object[0]), I18n._((String)"vradi.thesaurus.colomns.nbForm", (Object[])new Object[0]), I18n._((String)"vradi.thesaurus.colomns.tags", (Object[])new Object[0])};
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    protected Object getValueForRootThesaurus(RootThesaurus rootThesaurus, int column) {
        if (rootThesaurus == null) {
            return "not found";
        }
        if (column == 0) {
            return rootThesaurus;
        }
        return "";
    }

    protected Object getValueForThesaurus(Thesaurus thesaurus, int column) {
        if (thesaurus == null) {
            return "not found";
        }
        Object result = null;
        switch (column) {
            case 0: {
                result = thesaurus;
                break;
            }
            case 1: {
                result = String.valueOf(this.dataProvider.getNbFormsForThesaurus(thesaurus));
                break;
            }
            case 2: {
                result = ThesaurusDataHelper.getTagsAsString(thesaurus);
            }
        }
        return result;
    }
}

