/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.offer.widgets;

import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.FormLink;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.OfferEditHandler;
import org.chorem.vradi.ui.offer.OfferListHandler;
import org.chorem.vradi.ui.offer.OfferListUI;
import org.chorem.vradi.ui.offer.widgets.FormLinkCellRenderer;
import org.chorem.vradi.ui.widgets.MultipleSelectionHandler;
import org.chorem.vradi.ui.widgets.MultipleSelectionPane;
import org.nuiton.i18n.I18n;

public class ReplaceFormHandler
extends MultipleSelectionHandler<FormLink, Form, OfferEditHandler> {
    private static final Log log = LogFactory.getLog(ReplaceFormHandler.class);
    protected FormLinkCellRenderer linkCellRenderer;

    public ReplaceFormHandler(MultipleSelectionPane ui) {
        super(ui, OfferEditHandler.class);
        ui.setLbl(I18n._((String)"vradi.offerEdit.replaceForm", (Object[])new Object[0]));
        this.linkCellRenderer = new FormLinkCellRenderer(ui);
        ui.getList().setCellRenderer(this.linkCellRenderer);
    }

    @Override
    public void init() {
        List<String> replaceFormsLinkIds = null;
        String wikittyId = ((Form)this.getBean()).getWikittyId();
        try {
            replaceFormsLinkIds = VradiService.getVradiDataService().getReplaceFormsLinkIds(wikittyId);
        }
        catch (VradiException eee) {
            log.error((Object)("Cant get replace form for form id : " + wikittyId), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        this.fillList(replaceFormsLinkIds);
    }

    @Override
    public void add() {
        FormLink formLink = ((OfferEditHandler)this.getHandler()).addReplaceForm(this.ui, (Form)this.getBean());
        if (formLink != null) {
            this.addToList(formLink, formLink.getWikittyId());
            this.linkCellRenderer.addAdded(formLink);
        }
    }

    @Override
    public void remove() {
        List<String> formLinkIds = ((OfferEditHandler)this.getHandler()).removeLinkForm(this.getSelectedInList());
        this.removeFromList(formLinkIds);
    }

    @Override
    public void openSelected(String selected) {
        OfferListHandler listHandler = UIHelper.getHandler((JAXXContext)this.ui, OfferListHandler.class);
        if (selected != null) {
            FormLink formLink = (FormLink)VradiService.getWikittyProxy().restore(FormLink.class, selected);
            if (formLink == null) {
                formLink = (FormLink)this.getAddedData(selected);
            }
            OfferListUI offerListUI = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
            listHandler.addEditPane((JAXXContext)offerListUI, formLink.getToForm());
        }
    }
}

