/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.offer.widgets;

import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.FormLink;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.OfferEditHandler;
import org.chorem.vradi.ui.offer.OfferListHandler;
import org.chorem.vradi.ui.offer.OfferListUI;
import org.chorem.vradi.ui.offer.widgets.FormLinkCellRenderer;
import org.chorem.vradi.ui.widgets.MultipleSelectionHandler;
import org.chorem.vradi.ui.widgets.MultipleSelectionPane;
import org.nuiton.i18n.I18n;

public class RelatedFormHandler
extends MultipleSelectionHandler<FormLink, Form, OfferEditHandler> {
    private static final Log log = LogFactory.getLog(RelatedFormHandler.class);
    protected FormLinkCellRenderer linkCellRenderer;
    protected List<FormLink> toSave = new ArrayList<FormLink>();

    public RelatedFormHandler(MultipleSelectionPane ui) {
        super(ui, OfferEditHandler.class);
        ui.setLbl(I18n._((String)"vradi.offerEdit.relatedForm", (Object[])new Object[0]));
        this.linkCellRenderer = new FormLinkCellRenderer(ui);
        ui.getList().setCellRenderer(this.linkCellRenderer);
    }

    @Override
    public void init() {
        List<String> relatedFormsLinkIds = null;
        String wikittyId = ((Form)this.getBean()).getWikittyId();
        try {
            relatedFormsLinkIds = VradiService.getVradiDataService().getRelatedFormsLinkIds(wikittyId);
        }
        catch (VradiException eee) {
            log.error((Object)("Cant get related form for form id : " + wikittyId), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        this.fillList(relatedFormsLinkIds);
    }

    @Override
    public void add() {
        FormLink formLink = ((OfferEditHandler)this.getHandler()).addRelatedForm((JAXXContext)this.ui, (Form)this.getBean());
        if (formLink != null) {
            this.addToList(formLink, formLink.getWikittyId());
            this.linkCellRenderer.addAdded(formLink);
        }
    }

    @Override
    public void remove() {
        List<String> formLinkIds = ((OfferEditHandler)this.getHandler()).removeLinkForm(this.getSelectedInList());
        this.removeFromList(formLinkIds);
    }

    @Override
    public void openSelected(String selected) {
        OfferListHandler listHandler = UIHelper.getHandler((JAXXContext)this.ui, OfferListHandler.class);
        if (selected != null) {
            FormLink formLink = (FormLink)VradiService.getWikittyProxy().restore(FormLink.class, selected);
            if (formLink == null) {
                formLink = (FormLink)this.getAddedData(selected);
            }
            OfferListUI offerListUI = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
            listHandler.addEditPane((JAXXContext)offerListUI, formLink.getToForm());
        }
    }
}

