/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.offer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.InfogeneImpl;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;

public class OfferListColumnFactory
extends ColumnFactory {
    private static final Log log = LogFactory.getLog(OfferListColumnFactory.class);
    private static final String I18N_COLUMN_PREFIX = "vradi.offer.";
    private final List<TableColumnExt> columnExts = new ArrayList<TableColumnExt>();

    public OfferListColumnFactory() {
        this.initAvailableColumns();
    }

    public TableColumnExt createTableColumn(int modelIndex) {
        TableColumnExt columnExt = new TableColumnExt(this.columnExts.get(modelIndex));
        return columnExt;
    }

    public void packColumn(JXTable table, TableColumnExt columnExt, int margin, int max) {
        int preferredWidth = columnExt.getPreferredWidth();
        if (preferredWidth < 400) {
            super.packColumn(table, columnExt, margin, 400);
        }
    }

    protected void initAvailableColumns() {
        List<String> vradiListColumns = VradiHelper.getVradiListColumns();
        boolean empty = vradiListColumns.isEmpty();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String fieldName : InfogeneImpl.extensionInfogene.getFieldNames()) {
            fieldNames.add("Infogene." + fieldName);
        }
        fieldNames.add("Form.datePub");
        fieldNames.add("Form.datePeremption");
        fieldNames.add("Form.xmlStream");
        for (String fieldName : fieldNames) {
            boolean visible = vradiListColumns.contains(fieldName);
            visible = visible || empty;
            TableColumnExt columnExt = this.initAvailableColumn(fieldName, this.columnExts.size(), visible);
            this.columnExts.add(columnExt);
            if (!empty) continue;
            if (fieldName.equals("Infogene.id") || fieldName.equals("Infogene.description")) {
                columnExt.setVisible(false);
                continue;
            }
            VradiHelper.addVradiListColumns(fieldName);
        }
    }

    protected TableColumnExt initAvailableColumn(String fqField, int modelIndex, boolean visible) {
        TableColumnExt tableColumnExt = new TableColumnExt(modelIndex);
        tableColumnExt.setIdentifier((Object)fqField);
        tableColumnExt.putClientProperty((Object)"fqFieldName", (Object)fqField);
        tableColumnExt.setEditable(false);
        tableColumnExt.setSortable(true);
        tableColumnExt.setVisible(visible);
        tableColumnExt.setToolTipText(I18n._((String)(I18N_COLUMN_PREFIX + fqField), (Object[])new Object[0]));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("adding column: %s; position: %s; visible: %s", fqField, modelIndex, visible));
        }
        return tableColumnExt;
    }
}

