/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.login;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.VradiUser;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.services.VradiStorageService;
import org.chorem.vradi.ui.login.LoginUI;
import org.chorem.vradi.ui.login.RegisterUI;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class LoginHandler {
    private static final Log log = LogFactory.getLog(LoginHandler.class);
    private static final String EMPTY_PASSWORD = "null";

    public VradiStorageService getVradiStorageService() {
        return VradiService.getVradiStorageService();
    }

    public void logUser(LoginUI ui) {
        try {
            String login = ui.getLogin().getText().trim();
            String password = String.valueOf(ui.getPassword().getPassword()).trim();
            String md5Password = password.isEmpty() ? EMPTY_PASSWORD : StringUtil.encodeMD5((String)password);
            VradiUser user = this.getVradiStorageService().loginUser(login, md5Password);
            if (user != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Login failed for user " + login));
                }
                ui.setBean(user);
            } else {
                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.login.error.message", (Object[])new Object[0]), I18n._((String)"vradi.login.error", (Object[])new Object[0]), 0);
                ui.getLogin().grabFocus();
            }
        }
        catch (VradiException eee) {
            JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.login.error.message", (Object[])new Object[0]), I18n._((String)"vradi.login.error", (Object[])new Object[0]), 0);
        }
    }

    public void register(LoginUI ui) {
        RegisterUI regUI = new RegisterUI((JAXXContext)ui);
        regUI.setLocationRelativeTo(ui);
        regUI.setVisible(true);
    }

    public void register(RegisterUI ui) {
        try {
            String beanPassword = ui.getBean().getPassword();
            String repeatPassword = String.valueOf(ui.getRepeatPassword().getPassword());
            if (beanPassword != null && beanPassword.equals(repeatPassword)) {
                if (beanPassword.isEmpty()) {
                    ui.getBean().setPassword(EMPTY_PASSWORD);
                } else {
                    ui.getBean().setPassword(StringUtil.encodeMD5((String)beanPassword.trim()));
                }
                VradiUser result = ui.getBean();
                result = this.getVradiStorageService().createUser(result);
                if (result == null) {
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.user.error.message", (Object[])new Object[0]), I18n._((String)"vradi.register.user.error", (Object[])new Object[0]), 0);
                    ui.getLogin().grabFocus();
                    ui.getLogin().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                } else {
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.ok.message", (Object[])new Object[0]), I18n._((String)"vradi.register.ok", (Object[])new Object[0]), 1);
                    ui.dispose();
                }
            } else {
                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.password.error.message", (Object[])new Object[0]), I18n._((String)"vradi.register.password.error", (Object[])new Object[0]), 0);
                ui.getPassword().grabFocus();
                ui.getPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
                ui.getRepeatPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
            }
        }
        catch (VradiException eee) {
            JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.password.error.message", (Object[])new Object[0]), I18n._((String)"vradi.register.password.error", (Object[])new Object[0]), 0);
        }
    }
}

