/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConfigHelper;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.nuiton.util.ApplicationConfig;

public class ChangeLogHandler {
    private static Log log = LogFactory.getLog(ChangeLogHandler.class);
    public static final String CHANGELOG_FILE = "/changelog.txt";
    public static final String CHANGELOG_VERSION_SEPARATOR = "---- ";

    public String getLatestChangeLog() {
        String content = this.loadSource();
        String[] versionChangeLogs = content.split(CHANGELOG_VERSION_SEPARATOR);
        String lastVersion = "";
        if (versionChangeLogs.length > 0) {
            String[] lastVersionArray;
            lastVersion = versionChangeLogs[0];
            if (log.isDebugEnabled()) {
                log.debug((Object)lastVersion);
            }
            lastVersion = (lastVersionArray = (lastVersion = lastVersion.replace(CHANGELOG_VERSION_SEPARATOR.substring(1), "")).split("\\s")).length > 0 ? lastVersionArray[0].trim() : "";
        }
        log.debug((Object)lastVersion);
        return versionChangeLogs[0];
    }

    public String getChangeLog() {
        StringBuffer result = new StringBuffer();
        String content = this.loadSource();
        if (content != null) {
            String[] versionChangeLogs = content.split(CHANGELOG_VERSION_SEPARATOR);
            String lastVersion = (versionChangeLogs = this.removeFirstEmptyLines(versionChangeLogs))[0].replace(CHANGELOG_VERSION_SEPARATOR.substring(1), "").split("\\s")[0].trim();
            if (VradiHelper.isVersionNewer(lastVersion)) {
                result.append(versionChangeLogs[0]);
                for (int i = 1; i < versionChangeLogs.length; ++i) {
                    log.debug((Object)versionChangeLogs[i]);
                    String version = versionChangeLogs[i].split("\\s")[0].trim();
                    if (!VradiHelper.isVersionNewer(version)) break;
                    result.append(CHANGELOG_VERSION_SEPARATOR).append(versionChangeLogs[i]);
                }
            }
            ApplicationConfig config = VradiContext.get().getVradiConfig();
            VradiConfigHelper.setLastVersion(config, lastVersion);
            config.saveForUser(new String[0]);
        }
        return result.toString();
    }

    protected String[] removeFirstEmptyLines(String[] versionChangeLogs) {
        for (String versionChangeLog : Arrays.asList(versionChangeLogs)) {
            if (!StringUtils.isBlank((String)versionChangeLog)) continue;
            versionChangeLogs = Arrays.copyOfRange(versionChangeLogs, 1, versionChangeLogs.length);
        }
        return versionChangeLogs;
    }

    public String loadSource() {
        try {
            InputStream changelogFile = this.getClass().getResourceAsStream(CHANGELOG_FILE);
            String result = IOUtils.toString((InputStream)changelogFile);
            return result;
        }
        catch (IOException ex) {
            log.error((Object)"could not load file /changelog.txt", (Throwable)ex);
            return null;
        }
    }
}

