/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiAction;
import org.chorem.vradi.VradiConfig;
import org.chorem.vradi.VradiConfigHelper;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiNotifier;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.FormLink;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.entities.VradiUser;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.ChangeLogHandler;
import org.chorem.vradi.ui.ChangeLogUI;
import org.chorem.vradi.ui.VradiMainUI;
import org.chorem.vradi.ui.VradiMainUIHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.login.LoginHandler;
import org.chorem.vradi.ui.login.LoginUI;
import org.chorem.vradi.ui.renderers.NumberListCellRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.wikitty.entities.WikittyExtension;

public class VradiMain {
    private static Log log = LogFactory.getLog(VradiMain.class);

    public static void main(String[] args) {
        final long startingTime = System.nanoTime();
        log.info((Object)("Vradi start at " + new Date() + " args: " + Arrays.toString(args)));
        try {
            final VradiContext context = VradiMain.init(args);
            log.info((Object)I18n._((String)"vradi.init.context.done", (Object[])new Object[]{StringUtil.convertTime((long)startingTime, (long)System.nanoTime())}));
            SwingUtil.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)SwingUtil.newContextEntryDef(ApplicationConfig.class));
            SwingUtil.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)SwingUtil.newContextEntryDef(VradiAction.class));
            final ApplicationConfig config = (ApplicationConfig)context.getContextValue(ApplicationConfig.class);
            config.doAction(0);
            final LoginHandler handler = UIHelper.getHandler((JAXXContext)context, LoginHandler.class);
            final LoginUI loginUI = new LoginUI((JAXXContext)context);
            loginUI.addPropertyChangeListener("bean", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() != null) {
                        context.setContextValue(evt.getNewValue());
                        loginUI.removePropertyChangeListener(this);
                        loginUI.dispose();
                        try {
                            ChangeLogHandler changeLogHandler = UIHelper.getHandler((JAXXContext)context, ChangeLogHandler.class);
                            String changeLog = changeLogHandler.getChangeLog();
                            if (!changeLog.isEmpty()) {
                                ChangeLogUI clUI = new ChangeLogUI((JAXXContext)context);
                                clUI.getContent().setText(changeLog);
                                clUI.setLocationRelativeTo(null);
                                clUI.setVisible(true);
                            }
                        }
                        catch (Exception eee) {
                            log.error((Object)"Can't open change log ui : ", (Throwable)eee);
                            ErrorDialogUI.showError((Exception)eee);
                        }
                        VradiMainUIHandler uiHandler = UIHelper.getHandler((JAXXContext)context, VradiMainUIHandler.class);
                        VradiMainUI mainUI = uiHandler.initUI((JAXXContext)context, VradiConfigHelper.isFullScreen(config));
                        mainUI.setCursor(null);
                        mainUI.setLocationRelativeTo(null);
                        mainUI.setVisible(true);
                        log.info((Object)I18n._((String)"vradi.init.ui.done", (Object[])new Object[]{StringUtil.convertTime((long)startingTime, (long)System.nanoTime())}));
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String login = VradiConfigHelper.getLogin(config);
                    String password = VradiConfigHelper.getPassword(config);
                    VradiUser vradiUser = null;
                    if (StringUtils.isNotBlank((String)login) && StringUtils.isNotBlank((String)password)) {
                        try {
                            vradiUser = handler.getVradiStorageService().loginUser(login, password);
                        }
                        catch (VradiException e) {
                            log.error((Object)e.getMessage());
                        }
                    }
                    if (vradiUser != null) {
                        loginUI.setBean(vradiUser);
                    } else {
                        loginUI.setLocationRelativeTo(null);
                        loginUI.setVisible(true);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
            System.exit(1);
        }
    }

    public static VradiContext init(String ... args) throws Exception {
        System.setSecurityManager(null);
        long t0 = System.nanoTime();
        DefaultI18nInitializer initializer = new DefaultI18nInitializer("vradi-swing-i18n");
        I18n.init((I18nInitializer)initializer, null);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        VradiContext context = VradiContext.init();
        VradiMain.initLocalesAvailables(initializer);
        DecoratorProvider decoratorProvider = new DecoratorProvider(){

            protected void loadDecorators() {
                this.registerMultiJXPathDecorator(Client.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(User.class, "userOnly", "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Group.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Status.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(WikittyExtension.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(XmlStream.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Thesaurus.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(File.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Form.class, "${objet}$s", "", "");
                this.registerMultiJXPathDecorator(FormLink.class, "${name}$s", "", "");
                this.registerDecorator((Decorator)new Decorator<User>(User.class){
                    private static final long serialVersionUID = 1L;

                    public String toString(Object bean) {
                        User user = (User)bean;
                        Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                        String clientString = "";
                        if (client != null) {
                            clientString = client.getName() + " - ";
                        }
                        return clientString + user.getName();
                    }
                });
            }
        };
        context.setContextValue(decoratorProvider);
        context.setContextValue(new DecoratorProviderListCellRenderer(decoratorProvider));
        context.setContextValue(new NumberListCellRenderer());
        ApplicationConfig config = VradiConfig.getConfig(args);
        context.setContextValue(config);
        long t00 = System.nanoTime();
        Locale locale = VradiConfigHelper.getLocale(config);
        I18n.setDefaultLocale((Locale)locale);
        log.info((Object)("language : " + locale));
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
        log.info((Object)I18n._((String)"vradi.message.config.loaded", (Object[])new Object[]{VradiConfigHelper.getVersionAsString(config)}));
        try {
            SwingUtil.initNimbusLoookAndFeel();
            ToolTipManager.sharedInstance().setDismissDelay(3600000);
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            defaults.put("SplitPane.oneTouchButtonSize", (Object)10);
            defaults.put("Tree.drawHorizontalLines", Boolean.TRUE);
            defaults.put("Tree.drawVerticalLines", Boolean.TRUE);
            defaults.put("Tree.showRootHandles", Boolean.TRUE);
            defaults.put("Tree.leftChildIndent", (Object)12);
            defaults.put("Tree.rightChildIndent", (Object)12);
            defaults.put("Tree.scrollsOnExpand", Boolean.TRUE);
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"vradi.warning.nimbus.landf", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            log.warn((Object)I18n._((String)"vradi.warning.no.ui", (Object[])new Object[0]));
        }
        Converter converter = ConverterUtil.getConverter(Date.class);
        if (converter != null) {
            ConvertUtils.deregister(Date.class);
            DateConverter dateConverter = new DateConverter();
            dateConverter.setUseLocaleFormat(true);
            ConvertUtils.register((Converter)dateConverter, Date.class);
        }
        SwingUtil.loadUIConfig((String)("/" + config.getConfigFileName()), null);
        VradiService.initServiceProxies(config);
        context.setContextValue(new VradiNotifier());
        if (log.isDebugEnabled()) {
            log.debug((Object)("init done in " + StringUtil.convertTime((long)t0, (long)System.nanoTime())));
        }
        return context;
    }

    public static void initLocalesAvailables(DefaultI18nInitializer initializer) {
        ArrayList<Locale> localesAvailables = new ArrayList<Locale>();
        try {
            I18nBundle[] i18nBundles;
            for (I18nBundle bundle : i18nBundles = initializer.resolvBundles()) {
                Iterator i$ = bundle.iterator();
                while (i$.hasNext()) {
                    I18nBundleEntry aBundle;
                    I18nBundleEntry entry = aBundle = (I18nBundleEntry)i$.next();
                    Locale locale = entry.getLocale();
                    localesAvailables.add(locale);
                    log.info((Object)("Language found : " + locale.getLanguage()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"failled to resolve i18n bundles");
        }
        VradiContext.get().setLocalesAvailables(localesAvailables);
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("shutdown vradi");
        }

        @Override
        public void run() {
            try {
                super.run();
                VradiContext.get().close();
                log.info((Object)I18n._((String)"vradi.init.closed", (Object[])new Object[]{new Date()}));
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

