/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.bounce.text.ScrollableEditorPanel;
import org.webharvest.gui.BreakpointCollection;
import org.webharvest.gui.BreakpointInfo;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.XmlTextPane;
import org.webharvest.gui.component.WHScrollPane;

public class XmlEditorScrollPane
extends WHScrollPane {
    private LineNumberPanel lineNumberPanel;
    private XmlTextPane xmlTextPane = null;
    private boolean showLineNumbers;

    public XmlEditorScrollPane(XmlTextPane editor, boolean showLineNumbers) {
        super(new ScrollableEditorPanel(editor));
        this.xmlTextPane = editor;
        this.lineNumberPanel = new LineNumberPanel();
        this.showLineNumbers = showLineNumbers;
        this.setRowHeaderView(showLineNumbers ? this.lineNumberPanel : null);
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
        this.setRowHeaderView(showLineNumbers ? this.lineNumberPanel : null);
        this.repaintLineNumbers();
    }

    public void toggleShowLineNumbers() {
        this.setShowLineNumbers(!this.showLineNumbers);
    }

    public boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    private void repaintLineNumbers() {
        if (this.showLineNumbers) {
            this.lineNumberPanel.repaint();
        }
    }

    public void onDocChanged() {
        this.repaintLineNumbers();
    }

    private class LineNumberPanel
    extends JPanel {
        private final Color BORDER_COLOR = new Color(128, 128, 128);
        private final Color NUMBER_COLOR = new Color(128, 128, 128);
        private final Font font = XmlEditorScrollPane.access$000(XmlEditorScrollPane.this).getFont();

        private LineNumberPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int lineNumber;
                    int y = e.getPoint().y;
                    int lineHeight = LineNumberPanel.this.getFontMetrics(LineNumberPanel.this.font).getHeight();
                    BreakpointCollection breakpoints = XmlEditorScrollPane.this.xmlTextPane.getBreakpoints();
                    if (breakpoints.isThereBreakpoint(lineNumber = y / lineHeight)) {
                        breakpoints.removeBreakpoint(lineNumber);
                    } else {
                        breakpoints.addBreakpoint(new BreakpointInfo(lineNumber));
                    }
                    XmlEditorScrollPane.this.repaintLineNumbers();
                    XmlEditorScrollPane.this.xmlTextPane.repaint();
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            int editorHeight = XmlEditorScrollPane.this.xmlTextPane.getHeight();
            FontMetrics fm = this.getFontMetrics(this.font);
            int lineHeight = fm.getHeight();
            int maxHeight = this.calculateTextHeight();
            int numOfLines = lineHeight > 0 ? maxHeight / lineHeight : 0;
            String lastValue = String.valueOf(numOfLines);
            Rectangle2D rect = fm.getStringBounds(lastValue, this.getGraphics());
            int width = 22 + (int)rect.getWidth();
            return new Dimension(width, editorHeight);
        }

        @Override
        public void paint(Graphics g) {
            int y;
            int lineHeight;
            int width = this.getWidth();
            g.setColor(Color.white);
            g.fillRect(0, 0, width - 1, this.getHeight() - 1);
            g.setColor(this.NUMBER_COLOR);
            g.setFont(this.font);
            int x = 5;
            int maxHeight = this.calculateTextHeight();
            int lineNum = 1;
            for (y = lineHeight = this.getFontMetrics(this.font).getHeight(); y < maxHeight; y += lineHeight) {
                g.drawString("" + lineNum, x, y);
                ++lineNum;
            }
            BreakpointCollection breakpoints = XmlEditorScrollPane.this.xmlTextPane.getBreakpoints();
            for (int i = 0; i < breakpoints.size(); ++i) {
                BreakpointInfo breakpoint = (BreakpointInfo)breakpoints.get(i);
                y = (breakpoint.getLineNumber() + 1) * lineHeight;
                if (y >= maxHeight) continue;
                g.drawImage(ResourceManager.BREAKPOINT_IMAGE, width - 14, y - 10, this);
            }
            int right = width - 1;
            g.setColor(this.BORDER_COLOR);
            g.drawLine(right, 0, right, this.getHeight() - 1);
        }

        private int calculateTextHeight() {
            int maxHeight = 0;
            int lastOffset = XmlEditorScrollPane.this.xmlTextPane.getDocument().getEndPosition().getOffset();
            try {
                maxHeight = (int)XmlEditorScrollPane.this.xmlTextPane.modelToView(lastOffset).getMaxY();
            }
            catch (Exception e) {
                maxHeight = 0;
            }
            return maxHeight;
        }
    }
}

