/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.definition;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.webharvest.definition.ConstantDef;
import org.webharvest.definition.DefinitionResolver;
import org.webharvest.definition.FunctionDef;
import org.webharvest.definition.XmlNode;
import org.webharvest.runtime.scripting.BeanShellScriptEngine;
import org.webharvest.runtime.scripting.GroovyScriptEngine;
import org.webharvest.runtime.scripting.JavascriptScriptEngine;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.utils.Catalog;
import org.xml.sax.InputSource;

public class ScraperConfiguration {
    public static final String BEANSHELL_SCRIPT_ENGINE = "beanshell";
    public static final String JAVASCRIPT_SCRIPT_ENGINE = "javascript";
    public static final String GROOVY_SCRIPT_ENGINE = "groovy";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private Map functionDefs = new Catalog();
    private List operations = new ArrayList();
    private String charset = "UTF-8";
    private String defaultScriptEngine = "beanshell";
    private File sourceFile;
    private String url;

    public ScraperConfiguration(InputSource in) {
        this.createFromInputStream(in);
    }

    private void createFromInputStream(InputSource in) {
        XmlNode node = XmlNode.getInstance(in);
        String charsetString = node.getString("charset");
        this.charset = charsetString != null ? charsetString : DEFAULT_CHARSET;
        String scriptEngineDesc = node.getString("scriptlang");
        this.defaultScriptEngine = JAVASCRIPT_SCRIPT_ENGINE.equalsIgnoreCase(scriptEngineDesc) ? JAVASCRIPT_SCRIPT_ENGINE : (GROOVY_SCRIPT_ENGINE.equalsIgnoreCase(scriptEngineDesc) ? GROOVY_SCRIPT_ENGINE : BEANSHELL_SCRIPT_ENGINE);
        List elementList = node.getElementList();
        for (Object element : elementList) {
            if (element instanceof XmlNode) {
                XmlNode currElementNode = (XmlNode)element;
                this.operations.add(DefinitionResolver.createElementDefinition(currElementNode));
                continue;
            }
            this.operations.add(new ConstantDef(element.toString()));
        }
    }

    public ScraperConfiguration(File sourceFile) throws FileNotFoundException {
        this.sourceFile = sourceFile;
        this.createFromInputStream(new InputSource(new FileReader(sourceFile)));
    }

    public ScraperConfiguration(String sourceFilePath) throws FileNotFoundException {
        this(new File(sourceFilePath));
    }

    public ScraperConfiguration(URL sourceUrl) throws IOException {
        this.url = sourceUrl.toString();
        this.createFromInputStream(new InputSource(new InputStreamReader(sourceUrl.openStream())));
    }

    public List getOperations() {
        return this.operations;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getDefaultScriptEngine() {
        return this.defaultScriptEngine;
    }

    public FunctionDef getFunctionDef(String name) {
        return (FunctionDef)this.functionDefs.get(name);
    }

    public void addFunctionDef(FunctionDef funcDef) {
        this.functionDefs.put(funcDef.getName(), funcDef);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ScriptEngine createScriptEngine(Map context, String engineType) {
        if (JAVASCRIPT_SCRIPT_ENGINE.equalsIgnoreCase(engineType)) {
            return new JavascriptScriptEngine(context);
        }
        if (GROOVY_SCRIPT_ENGINE.equalsIgnoreCase(engineType)) {
            return new GroovyScriptEngine(context);
        }
        return new BeanShellScriptEngine(context);
    }

    public ScriptEngine createScriptEngine(Map context) {
        return this.createScriptEngine(context, this.defaultScriptEngine);
    }
}

