/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget.tooltip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.html.HTMLDocument;
import org.nuiton.i18n.I18n;
import org.nuiton.widget.tooltip.FocusableTip;
import org.nuiton.widget.tooltip.SizeGrip;
import org.nuiton.widget.tooltip.TipUtil;

public class TipWindow
extends JWindow
implements ActionListener {
    protected FocusableTip ft;
    protected Component component;
    protected String text;
    protected TipListener tipListener;
    protected HyperlinkListener userHyperlinkListener;
    protected static TipWindow visibleInstance;

    public TipWindow(Window owner, FocusableTip ft, String msg) {
        super(owner);
        this.ft = ft;
        this.tipListener = new TipListener();
        JEditorPane textArea = new JEditorPane("text/html", msg);
        TipUtil.tweakTipEditorPane(textArea);
        if (ft.getImageBase() != null) {
            ((HTMLDocument)textArea.getDocument()).setBase(ft.getImageBase());
        }
        textArea.addMouseListener(this.tipListener);
        textArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            }
        });
        this.init(ft, textArea);
    }

    public TipWindow(Window owner, FocusableTip ft, Component component) {
        super(owner);
        this.init(ft, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(FocusableTip ft, Component component) {
        this.ft = ft;
        this.tipListener = new TipListener();
        this.component = component;
        JPanel cp = new JPanel(new BorderLayout());
        cp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder()));
        cp.setBackground(TipUtil.getToolTipBackground());
        component.addMouseListener(this.tipListener);
        cp.add(component);
        this.setFocusableWindowState(false);
        this.setContentPane(cp);
        this.setBottomPanel();
        this.pack();
        KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            }
        };
        this.addKeyListener(ka);
        component.addKeyListener(ka);
        Class<TipWindow> clazz = TipWindow.class;
        synchronized (TipWindow.class) {
            if (visibleInstance != null) {
                visibleInstance.dispose();
            }
            visibleInstance = this;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getFocusableWindowState()) {
            this.setFocusableWindowState(true);
            this.setBottomPanel();
            this.component.removeMouseListener(this.tipListener);
            this.pack();
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            });
            this.ft.removeListeners();
            if (e == null) {
                this.requestFocus();
            }
        }
    }

    @Override
    public void dispose() {
        Container cp = this.getContentPane();
        for (int i = 0; i < cp.getComponentCount(); ++i) {
            cp.getComponent(i).removeMouseListener(this.tipListener);
        }
        this.ft.removeListeners();
        super.dispose();
    }

    public void fixSize(int width, int height) {
        Dimension d = this.component.getPreferredSize();
        d.height = width;
        d.width = height;
        this.component.setPreferredSize(d);
        this.component.setSize(d);
        this.pack();
    }

    public String getText() {
        return this.text;
    }

    protected void setBottomPanel() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JSeparator(), "North");
        boolean focusable = this.getFocusableWindowState();
        if (focusable) {
            SizeGrip sg = new SizeGrip();
            sg.applyComponentOrientation(sg.getComponentOrientation());
            panel.add((Component)sg, "After");
            MouseInputAdapter adapter = new MouseInputAdapter(){
                protected Point lastPoint;

                @Override
                public void mouseDragged(MouseEvent e) {
                    Point p = e.getPoint();
                    SwingUtilities.convertPointToScreen(p, panel);
                    if (this.lastPoint == null) {
                        this.lastPoint = p;
                    } else {
                        int dx = p.x - this.lastPoint.x;
                        int dy = p.y - this.lastPoint.y;
                        TipWindow.this.setLocation(TipWindow.this.getX() + dx, TipWindow.this.getY() + dy);
                        this.lastPoint = p;
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.lastPoint = e.getPoint();
                    SwingUtilities.convertPointToScreen(this.lastPoint, panel);
                }
            };
            panel.addMouseListener(adapter);
            panel.addMouseMotionListener(adapter);
        } else {
            panel.setOpaque(false);
            JLabel label = new JLabel(I18n._((String)"nuitonwidgets.tootilp.focushotkey", (Object[])new Object[0]));
            Color fg = UIManager.getColor("Label.disabledForeground");
            Font font = this.component.getFont();
            font = font.deriveFont(font.getSize2D() - 1.0f);
            label.setFont(font);
            if (fg == null) {
                fg = Color.GRAY;
            }
            label.setOpaque(true);
            Color bg = TipUtil.getToolTipBackground();
            label.setBackground(bg);
            label.setForeground(fg);
            label.setHorizontalAlignment(11);
            label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            panel.add(label);
            panel.addMouseListener(this.tipListener);
        }
        Container cp = this.getContentPane();
        if (cp.getComponentCount() == 2) {
            Component comp = cp.getComponent(0);
            cp.remove(0);
            JScrollPane sp = new JScrollPane(comp);
            sp.setViewportBorder(BorderFactory.createEmptyBorder());
            sp.setBackground(this.component.getBackground());
            sp.getViewport().setBackground(this.component.getBackground());
            cp.add(sp);
            cp.getComponent(0).removeMouseListener(this.tipListener);
            cp.remove(0);
        }
        cp.add((Component)panel, "South");
    }

    public void setHyperlinkListener(HyperlinkListener listener) {
        if (this.component instanceof JEditorPane) {
            JEditorPane textArea = (JEditorPane)this.component;
            if (this.userHyperlinkListener != null) {
                textArea.removeHyperlinkListener(this.userHyperlinkListener);
            }
            this.userHyperlinkListener = listener;
            if (this.userHyperlinkListener != null) {
                textArea.addHyperlinkListener(this.userHyperlinkListener);
            }
        }
    }

    protected class TipListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            TipWindow.this.actionPerformed(null);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component source = (Component)e.getSource();
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, source);
            if (!TipWindow.this.getBounds().contains(p)) {
                TipWindow.this.ft.possiblyDisposeOfTipWindow();
            }
        }
    }
}

