/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.Version;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.RegexFileFilter;
import org.apache.solr.core.Config;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.FastLRUCache;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.update.SolrIndexConfig;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrConfig
extends Config {
    public static final Logger log = LoggerFactory.getLogger(SolrConfig.class);
    public static final String DEFAULT_CONF_FILE = "solrconfig.xml";
    @Deprecated
    public static SolrConfig config = null;
    public static final Collection<Throwable> severeErrors = new HashSet<Throwable>();
    public final int booleanQueryMaxClauseCount;
    public final boolean filtOptEnabled;
    public final int filtOptCacheSize;
    public final float filtOptThreshold;
    public final CacheConfig filterCacheConfig;
    public final CacheConfig queryResultCacheConfig;
    public final CacheConfig documentCacheConfig;
    public final CacheConfig fieldValueCacheConfig;
    public final CacheConfig[] userCacheConfigs;
    public final boolean useFilterForSortedQuery;
    public final int queryResultWindowSize;
    public final int queryResultMaxDocsCached;
    public final boolean enableLazyFieldLoading;
    public final boolean reopenReaders;
    public final float hashSetInverseLoadFactor;
    public final int hashDocSetMaxSize;
    public final SolrIndexConfig defaultIndexConfig;
    public final SolrIndexConfig mainIndexConfig;
    protected UpdateHandlerInfo updateHandlerInfo;
    private Map<String, List<PluginInfo>> pluginStore = new LinkedHashMap<String, List<PluginInfo>>();
    public final int maxWarmingSearchers;
    public final boolean unlockOnStartup;
    public final boolean useColdSearcher;
    public final Version luceneMatchVersion;
    protected String dataDir;
    public final JmxConfiguration jmxConfig;
    private final HttpCachingConfig httpCachingConfig;
    @Deprecated
    private final NamedList pingQueryParams;

    public SolrConfig() throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, DEFAULT_CONF_FILE, null);
    }

    public SolrConfig(String name) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, null);
    }

    public SolrConfig(String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, is);
    }

    public SolrConfig(String instanceDir, String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        this(new SolrResourceLoader(instanceDir), name, is);
    }

    SolrConfig(SolrResourceLoader loader, String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        super(loader, name, is, "/config/");
        this.initLibs();
        this.defaultIndexConfig = new SolrIndexConfig(this, null, null);
        this.mainIndexConfig = new SolrIndexConfig(this, "mainIndex", this.defaultIndexConfig);
        this.reopenReaders = this.getBool("mainIndex/reopenReaders", true);
        this.booleanQueryMaxClauseCount = this.getInt("query/maxBooleanClauses", BooleanQuery.getMaxClauseCount());
        this.luceneMatchVersion = this.getLuceneVersion("luceneMatchVersion", Version.LUCENE_24);
        log.info("Using Lucene MatchVersion: " + this.luceneMatchVersion);
        this.filtOptEnabled = this.getBool("query/boolTofilterOptimizer/@enabled", false);
        this.filtOptCacheSize = this.getInt("query/boolTofilterOptimizer/@cacheSize", 32);
        this.filtOptThreshold = this.getFloat("query/boolTofilterOptimizer/@threshold", 0.05f);
        this.useFilterForSortedQuery = this.getBool("query/useFilterForSortedQuery", false);
        this.queryResultWindowSize = Math.max(1, this.getInt("query/queryResultWindowSize", 1));
        this.queryResultMaxDocsCached = this.getInt("query/queryResultMaxDocsCached", Integer.MAX_VALUE);
        this.enableLazyFieldLoading = this.getBool("query/enableLazyFieldLoading", false);
        this.filterCacheConfig = CacheConfig.getConfig(this, "query/filterCache");
        this.queryResultCacheConfig = CacheConfig.getConfig(this, "query/queryResultCache");
        this.documentCacheConfig = CacheConfig.getConfig(this, "query/documentCache");
        CacheConfig conf = CacheConfig.getConfig(this, "query/fieldValueCache");
        if (conf == null) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", "fieldValueCache");
            args.put("size", "10000");
            args.put("initialSize", "10");
            args.put("showItems", "-1");
            conf = new CacheConfig(FastLRUCache.class, args, null);
        }
        this.fieldValueCacheConfig = conf;
        this.unlockOnStartup = this.getBool("mainIndex/unlockOnStartup", false);
        this.useColdSearcher = this.getBool("query/useColdSearcher", false);
        this.dataDir = this.get("dataDir", null);
        if (this.dataDir != null && this.dataDir.length() == 0) {
            this.dataDir = null;
        }
        this.userCacheConfigs = CacheConfig.getMultipleConfigs(this, "query/cache");
        SolrIndexSearcher.initRegenerators(this);
        this.hashSetInverseLoadFactor = 1.0f / this.getFloat("//HashDocSet/@loadFactor", 0.75f);
        this.hashDocSetMaxSize = this.getInt("//HashDocSet/@maxSize", 3000);
        this.pingQueryParams = SolrConfig.readPingQueryParams(this);
        this.httpCachingConfig = new HttpCachingConfig(this);
        Node jmx = this.getNode("jmx", false);
        this.jmxConfig = jmx != null ? new JmxConfiguration(true, this.get("jmx/@agentId", null), this.get("jmx/@serviceUrl", null)) : new JmxConfiguration(false, null, null);
        this.maxWarmingSearchers = this.getInt("query/maxWarmingSearchers", Integer.MAX_VALUE);
        this.loadPluginInfo(SolrRequestHandler.class, "requestHandler", true, true);
        this.loadPluginInfo(QParserPlugin.class, "queryParser", true, true);
        this.loadPluginInfo(QueryResponseWriter.class, "queryResponseWriter", true, true);
        this.loadPluginInfo(ValueSourceParser.class, "valueSourceParser", true, true);
        this.loadPluginInfo(SearchComponent.class, "searchComponent", true, true);
        this.loadPluginInfo(QueryConverter.class, "queryConverter", true, true);
        this.loadPluginInfo(SolrEventListener.class, "//listener", false, true);
        this.loadPluginInfo(DirectoryFactory.class, "directoryFactory", false, true);
        this.loadPluginInfo(IndexDeletionPolicy.class, "mainIndex/deletionPolicy", false, true);
        this.loadPluginInfo(IndexReaderFactory.class, "indexReaderFactory", false, true);
        this.loadPluginInfo(UpdateRequestProcessorChain.class, "updateRequestProcessorChain", false, false);
        this.loadPluginInfo(SolrHighlighter.class, "highlighting", false, false);
        if (this.pluginStore.containsKey(SolrHighlighter.class.getName())) {
            log.warn("Deprecated syntax found. <highlighting/> should move to <searchComponent/>");
        }
        this.updateHandlerInfo = this.loadUpdatehandlerInfo();
        Config.log.info("Loaded SolrConfig: " + name);
        config = this;
    }

    protected UpdateHandlerInfo loadUpdatehandlerInfo() {
        return new UpdateHandlerInfo(this.get("updateHandler/@class", null), this.getInt("updateHandler/autoCommit/maxDocs", -1), this.getInt("updateHandler/autoCommit/maxTime", -1), this.getInt("updateHandler/commitIntervalLowerBound", -1));
    }

    private void loadPluginInfo(Class clazz, String tag, boolean requireName, boolean requireClass) {
        List<PluginInfo> result = this.readPluginInfos(tag, requireName, requireClass);
        if (!result.isEmpty()) {
            this.pluginStore.put(clazz.getName(), result);
        }
    }

    public List<PluginInfo> readPluginInfos(String tag, boolean requireName, boolean requireClass) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        NodeList nodes = (NodeList)this.evaluate(tag, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            PluginInfo pluginInfo = new PluginInfo(nodes.item(i), "[solrconfig.xml] " + tag, requireName, requireClass);
            if (!pluginInfo.isEnabled()) continue;
            result.add(pluginInfo);
        }
        return result;
    }

    public HttpCachingConfig getHttpCachingConfig() {
        return this.httpCachingConfig;
    }

    private static NamedList readPingQueryParams(SolrConfig config) {
        String urlSnippet = config.get("admin/pingQuery", "").trim();
        StringTokenizer qtokens = new StringTokenizer(urlSnippet, "&");
        NamedList params = new NamedList();
        while (qtokens.hasMoreTokens()) {
            String tok = qtokens.nextToken();
            String[] split = tok.split("=", 2);
            params.add(split[0], (Object)split[1]);
        }
        if (0 < params.size()) {
            log.warn("The <pingQuery> syntax is deprecated, please use PingRequestHandler instead");
        }
        return params;
    }

    @Deprecated
    public SolrQueryRequest getPingQueryRequest(SolrCore core) {
        if (this.pingQueryParams.size() == 0) {
            throw new IllegalStateException("<pingQuery> not configured (consider registering PingRequestHandler with the name '/admin/ping' instead)");
        }
        return new LocalSolrQueryRequest(core, this.pingQueryParams);
    }

    public UpdateHandlerInfo getUpdateHandlerInfo() {
        return this.updateHandlerInfo;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public List<PluginInfo> getPluginInfos(String type) {
        List<PluginInfo> result = this.pluginStore.get(type);
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public PluginInfo getPluginInfo(String type) {
        List<PluginInfo> result = this.pluginStore.get(type);
        return result == null || result.isEmpty() ? null : result.get(0);
    }

    private void initLibs() {
        NodeList nodes = (NodeList)this.evaluate("lib", XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        log.info("Adding specified lib dirs to ClassLoader");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String baseDir = DOMUtil.getAttr((Node)node, (String)"dir");
            String path = DOMUtil.getAttr((Node)node, (String)"path");
            if (null != baseDir) {
                String regex = DOMUtil.getAttr((Node)node, (String)"regex");
                RegexFileFilter filter = null == regex ? null : new RegexFileFilter(regex);
                this.getResourceLoader().addToClassLoader(baseDir, (FileFilter)filter);
                continue;
            }
            if (null != path) {
                this.getResourceLoader().addToClassLoader(path);
                continue;
            }
            throw new RuntimeException("lib: missing mandatory attributes: 'dir' or 'path'");
        }
    }

    public static class UpdateHandlerInfo {
        public final String className;
        public final int autoCommmitMaxDocs;
        public final int autoCommmitMaxTime;
        public final int commitIntervalLowerBound;

        public UpdateHandlerInfo(String className, int autoCommmitMaxDocs, int autoCommmitMaxTime, int commitIntervalLowerBound) {
            this.className = className;
            this.autoCommmitMaxDocs = autoCommmitMaxDocs;
            this.autoCommmitMaxTime = autoCommmitMaxTime;
            this.commitIntervalLowerBound = commitIntervalLowerBound;
        }
    }

    public static class HttpCachingConfig {
        private static final String CACHE_PRE = "requestDispatcher/httpCaching/";
        private static final Pattern MAX_AGE = Pattern.compile("\\bmax-age=(\\d+)");
        private final boolean never304;
        private final String etagSeed;
        private final String cacheControlHeader;
        private final Long maxAge;
        private final LastModFrom lastModFrom;

        private HttpCachingConfig(SolrConfig conf) {
            this.never304 = conf.getBool("requestDispatcher/httpCaching/@never304", false);
            this.etagSeed = conf.get("requestDispatcher/httpCaching/@etagSeed", "Solr");
            this.lastModFrom = LastModFrom.parse(conf.get("requestDispatcher/httpCaching/@lastModFrom", "openTime"));
            this.cacheControlHeader = conf.get("requestDispatcher/httpCaching/cacheControl", null);
            Long tmp = null;
            if (null != this.cacheControlHeader) {
                try {
                    Matcher ttlMatcher = MAX_AGE.matcher(this.cacheControlHeader);
                    String ttlStr = ttlMatcher.find() ? ttlMatcher.group(1) : null;
                    tmp = null != ttlStr && !"".equals(ttlStr) ? Long.valueOf(ttlStr) : null;
                }
                catch (Exception e) {
                    log.warn("Ignoring exception while attempting to extract max-age from cacheControl config: " + this.cacheControlHeader, (Throwable)e);
                }
            }
            this.maxAge = tmp;
        }

        public boolean isNever304() {
            return this.never304;
        }

        public String getEtagSeed() {
            return this.etagSeed;
        }

        public String getCacheControlHeader() {
            return this.cacheControlHeader;
        }

        public Long getMaxAge() {
            return this.maxAge;
        }

        public LastModFrom getLastModFrom() {
            return this.lastModFrom;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum LastModFrom {
            OPENTIME,
            DIRLASTMOD,
            BOGUS;


            public static LastModFrom parse(String s) {
                try {
                    return LastModFrom.valueOf(s.toUpperCase(Locale.ENGLISH));
                }
                catch (Exception e) {
                    log.warn("Unrecognized value for lastModFrom: " + s, (Throwable)e);
                    return BOGUS;
                }
            }
        }
    }

    public static class JmxConfiguration {
        public boolean enabled = false;
        public String agentId;
        public String serviceUrl;

        public JmxConfiguration(boolean enabled, String agentId, String serviceUrl) {
            this.enabled = enabled;
            this.agentId = agentId;
            this.serviceUrl = serviceUrl;
        }
    }
}

