/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicComparer
implements Comparator,
Serializable {
    private Comparator collator;
    private XPathContext conversionContext;

    public AtomicComparer(Comparator comparator, XPathContext xPathContext) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = xPathContext;
    }

    public AtomicComparer(Comparator comparator, Configuration configuration) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = configuration.getConversionContext();
    }

    public int compare(Object object, Object object2) {
        if (object instanceof AtomicValue && !((AtomicValue)object).hasBuiltInType()) {
            object = ((AtomicValue)object).getPrimitiveValue();
        }
        if (object2 instanceof AtomicValue && !((AtomicValue)object2).hasBuiltInType()) {
            object2 = ((AtomicValue)object2).getPrimitiveValue();
        }
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator, this.conversionContext);
        }
        if (object2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)object2).compareTo(object, this.collator, this.conversionContext);
        }
        if (object instanceof CalendarValue && object2 instanceof CalendarValue) {
            return ((CalendarValue)object).compareTo((CalendarValue)object2, this.conversionContext);
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof StringValue) {
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue());
        }
        throw new ClassCastException("Objects are not comparable (" + object.getClass() + ", " + object2.getClass() + ')');
    }

    public boolean comparesEqual(Object object, Object object2) {
        if (object instanceof AtomicValue && !((AtomicValue)object).hasBuiltInType()) {
            object = ((AtomicValue)object).getPrimitiveValue();
        }
        if (object2 instanceof AtomicValue && !((AtomicValue)object2).hasBuiltInType()) {
            object2 = ((AtomicValue)object2).getPrimitiveValue();
        }
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator, this.conversionContext) == 0;
        }
        if (object2 instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object2).compareTo(object, this.collator, this.conversionContext) == 0;
        }
        if (object instanceof StringValue) {
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue()) == 0;
        }
        if (object instanceof CalendarValue && object2 instanceof CalendarValue) {
            return ((CalendarValue)object).compareTo((CalendarValue)object2, this.conversionContext) == 0;
        }
        if (object instanceof String) {
            return this.collator.compare(object, object2) == 0;
        }
        return object.equals(object2);
    }

    public Object getComparisonKey(Object object) {
        if (object instanceof AtomicValue && !((AtomicValue)object).hasBuiltInType()) {
            object = ((AtomicValue)object).getPrimitiveValue();
        }
        if (object instanceof StringValue) {
            Platform platform = this.conversionContext.getConfiguration().getPlatform();
            if (platform.canReturnCollationKeys(this.collator)) {
                return platform.getCollationKey(this.collator, ((StringValue)object).getStringValue());
            }
            return ((StringValue)object).getStringValue();
        }
        return object;
    }
}

