/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.util.Comparator;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.regex.JRegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.JavaCollationFactory;
import net.sf.saxon.trans.XPathException;

public class JavaPlatform
implements Platform {
    private static JavaPlatform theInstance = new JavaPlatform();

    public static JavaPlatform getInstance() {
        return theInstance;
    }

    private JavaPlatform() {
    }

    public void initialize(Configuration configuration) {
    }

    public URI makeAbsolute(String string, String string2) throws URISyntaxException {
        URI uRI;
        string = JavaPlatform.escapeSpaces(string);
        string2 = JavaPlatform.escapeSpaces(string2);
        try {
            if (string2 == null) {
                String string3;
                uRI = new URI(string);
                if (!uRI.isAbsolute() && !(string3 = JavaPlatform.tryToExpand(string2)).equals(string2)) {
                    return this.makeAbsolute(string, string3);
                }
            } else {
                URI uRI2 = new URI(string2);
                uRI = string.length() == 0 ? uRI2 : uRI2.resolve(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new URISyntaxException(string, "Cannot resolve URI against base " + Err.wrap(string2));
        }
        return uRI;
    }

    public static String escapeSpaces(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(32);
        if (n < 0) {
            return string;
        }
        return (n == 0 ? "" : string.substring(0, n)) + "%20" + (n == string.length() - 1 ? "" : JavaPlatform.escapeSpaces(string.substring(n + 1)));
    }

    public static String tryToExpand(String string) {
        if (string == null) {
            string = "";
        }
        try {
            new URL(string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            String string2;
            try {
                string2 = System.getProperty("user.dir");
            }
            catch (Exception exception) {
                return string;
            }
            if (!string2.endsWith("/") && !string.startsWith("/")) {
                string2 = string2 + '/';
            }
            try {
                URL uRL = new File(string2).toURL();
                URL uRL2 = new URL(uRL, string);
                return uRL2.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
    }

    public String getPlatformVersion() {
        return "Java version " + System.getProperty("java.version");
    }

    public String getPlatformSuffix() {
        return "J";
    }

    public Source getParserSource(StreamSource streamSource, int n, boolean bl, int n2) {
        return streamSource;
    }

    public RegularExpression compileRegularExpression(CharSequence charSequence, boolean bl, CharSequence charSequence2) throws XPathException {
        return new JRegularExpression(charSequence, bl, charSequence2);
    }

    public Comparator makeCollation(Configuration configuration, Properties properties) throws XPathException {
        return JavaCollationFactory.makeCollation(configuration, properties);
    }

    public boolean canReturnCollationKeys(Comparator comparator) {
        return comparator instanceof Collator || comparator instanceof CodepointCollator;
    }

    public Object getCollationKey(Comparator comparator, String string) {
        if (comparator instanceof CodepointCollator) {
            return string;
        }
        return ((Collator)comparator).getCollationKey(string);
    }
}

