/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.css.DataBinding;

public class Pseudoclasses {
    public static final String NO_PSEUDOCLASS = "no pseudoclass";
    private static Map<Object, Map<String, List<PropertyValue>>> properties = new WeakHashMap<Object, Map<String, List<PropertyValue>>>();

    private static List<PropertyValue> getPropertyList(Object object, String property) {
        List<PropertyValue> propertyList;
        Map<String, List<PropertyValue>> propertyMap = properties.get(object);
        if (propertyMap == null) {
            propertyMap = new HashMap<String, List<PropertyValue>>();
            properties.put(object, propertyMap);
        }
        if ((propertyList = propertyMap.get(property)) == null) {
            propertyList = new ArrayList<PropertyValue>();
            propertyMap.put(property, propertyList);
        }
        return propertyList;
    }

    public static boolean isPropertyApplied(Object object, String property, int id) {
        for (PropertyValue aPropertyList : Pseudoclasses.getPropertyList(object, property)) {
            if (aPropertyList.getId() != id) continue;
            return true;
        }
        return false;
    }

    public static void propertyApplied(Object object, String property, Object value, int id) {
        List<PropertyValue> propertyList = Pseudoclasses.getPropertyList(object, property);
        propertyList.add(new PropertyValue(value, id));
        Collections.sort(propertyList);
    }

    public static void propertyRemoved(Object object, String property, Object value, int id) {
        List<PropertyValue> propertyList = Pseudoclasses.getPropertyList(object, property);
        propertyList.remove(new PropertyValue(value, id));
    }

    public static Object getCurrentValue(Object object, String property) {
        List<PropertyValue> propertyList = Pseudoclasses.getPropertyList(object, property);
        if (propertyList.size() > 0) {
            return propertyList.get(propertyList.size() - 1).getValue();
        }
        return NO_PSEUDOCLASS;
    }

    public static Object applyProperty(JAXXObject parent, Object object, String property, Object newValue, Object currentValue, int id) {
        if (!Pseudoclasses.isPropertyApplied(object, property, id)) {
            Object value = Pseudoclasses.getCurrentValue(object, property);
            if (value == NO_PSEUDOCLASS) {
                Pseudoclasses.propertyApplied(object, property, Pseudoclasses.wrap(currentValue), -1);
            }
            Pseudoclasses.propertyApplied(object, property, Pseudoclasses.wrap(newValue), id);
            value = Pseudoclasses.getCurrentValue(object, property);
            if (value instanceof DataBinding) {
                parent.applyDataBinding(((DataBinding)value).getId());
            }
            return value;
        }
        return currentValue;
    }

    public static Object removeProperty(JAXXObject parent, Object object, String property, Object oldValue, Object currentValue, int id) {
        if (Pseudoclasses.isPropertyApplied(object, property, id)) {
            Object value = Pseudoclasses.getCurrentValue(object, property);
            if (value == NO_PSEUDOCLASS) {
                throw new IllegalStateException("found NO_PSEUDOCLASS value for a property which does not have a default value");
            }
            if (value instanceof DataBinding) {
                parent.removeDataBinding(((DataBinding)value).getId());
            }
            Pseudoclasses.propertyRemoved(object, property, Pseudoclasses.wrap(oldValue), id);
            value = Pseudoclasses.getCurrentValue(object, property);
            return value;
        }
        return currentValue;
    }

    public static Object wrap(boolean value) {
        return value;
    }

    public static Object wrap(byte value) {
        return value;
    }

    public static Object wrap(short value) {
        return value;
    }

    public static Object wrap(int value) {
        return value;
    }

    public static Object wrap(long value) {
        return value;
    }

    public static Object wrap(float value) {
        return Float.valueOf(value);
    }

    public static Object wrap(double value) {
        return value;
    }

    public static Object wrap(char value) {
        return Character.valueOf(value);
    }

    public static Object wrap(Object value) {
        return value;
    }

    private static class PropertyValue
    implements Comparable<PropertyValue> {
        private Object value;
        private int id;

        public PropertyValue(Object value, int id) {
            this.value = value;
            this.id = id;
        }

        public Object getValue() {
            return this.value;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public int compareTo(PropertyValue o) {
            return this.getId() - o.getId();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PropertyValue)) {
                return false;
            }
            PropertyValue that = (PropertyValue)o;
            if (that.getId() != this.getId()) {
                return false;
            }
            if (that.getValue() == null) {
                return this.getValue() == null;
            }
            return that.getValue().equals(this.getValue());
        }

        public int hashCode() {
            return (this.value != null ? this.value.hashCode() : 0) ^ this.id;
        }

        public String toString() {
            return "PropertyValue[" + this.value + ", " + this.id + "]";
        }
    }
}

