/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.majorityjudgment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.impl.majorityjudgment.MajorityJudgmentChoiceResult;
import org.chorem.pollen.votecounting.impl.majorityjudgment.MajorityJudgmentConfig;
import org.chorem.pollen.votecounting.impl.majorityjudgment.MajorityJudgmentDetailResult;

public class MajorityJudgmentVoteCountingStrategy
extends AbstractVoteCountingStrategy<MajorityJudgmentConfig> {
    protected static Comparator<MajorityJudgmentChoiceResult> CHOICE_RESULT_COMPARATOR = Comparator.comparingInt(MajorityJudgmentChoiceResult::getMedian).thenComparing(MajorityJudgmentVoteCountingStrategy::compareChoiceResultSameMedian);

    public MajorityJudgmentVoteCountingStrategy() {
        super(MajorityJudgmentConfig.class);
    }

    @Override
    public VoteCountingResult voteCount(Set<Voter> voters) {
        MajorityJudgmentDetailResult detailResult = new MajorityJudgmentDetailResult();
        List<MajorityJudgmentChoiceResult> choiceResults = this.getAllChoiceIds(voters).stream().map(this::newChoiceResult).collect(Collectors.toList());
        detailResult.setChoiceResults(choiceResults);
        detailResult.setSumWeight(BigDecimal.ZERO);
        voters.forEach(voter -> this.addVoter(detailResult, (Voter)voter));
        detailResult.setHalfWeight(detailResult.getSumWeight().divide(BigDecimal.valueOf(2L), MathContext.DECIMAL32));
        choiceResults.forEach(this::computeMedian);
        choiceResults.sort(CHOICE_RESULT_COMPARATOR.reversed());
        List<ChoiceScore> scores = this.computeScore(choiceResults);
        return VoteCountingResult.newResult(scores, detailResult);
    }

    @Override
    public Set<VoteForChoice> toVoteForChoices(VoteCountingResult voteCountingResult) {
        HashSet voteForChoices = Sets.newHashSet();
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            double score = choiceScore.getScoreOrder();
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            voteForChoices.add(voteForChoice);
        }
        return voteForChoices;
    }

    protected MajorityJudgmentChoiceResult newChoiceResult(String choiceId) {
        MajorityJudgmentChoiceResult choiceResult = new MajorityJudgmentChoiceResult();
        choiceResult.setChoiceId(choiceId);
        List<BigDecimal> voteByGrad = ((MajorityJudgmentConfig)this.config).getGrades().stream().map(grad -> BigDecimal.ZERO).collect(Collectors.toList());
        choiceResult.setVoteByGrad(voteByGrad);
        return choiceResult;
    }

    protected void addVoter(MajorityJudgmentDetailResult detailResult, Voter voter) {
        BigDecimal weight = BigDecimal.valueOf(voter.getWeight());
        detailResult.setSumWeight(detailResult.getSumWeight().add(weight));
        voter.getVoteForChoices().forEach(voteForChoice -> this.addVoteForChoice(detailResult, weight, (VoteForChoice)voteForChoice));
    }

    protected void addVoteForChoice(MajorityJudgmentDetailResult detailResult, BigDecimal weight, VoteForChoice voteForChoice) {
        detailResult.getChoiceResults().stream().filter(choiceResult -> voteForChoice.getChoiceId().equals(choiceResult.getChoiceId())).findFirst().ifPresent(choiceResult -> this.addGrad((MajorityJudgmentChoiceResult)choiceResult, voteForChoice.getVoteValue(), weight));
    }

    protected void addGrad(MajorityJudgmentChoiceResult choiceResult, Double voteValue, BigDecimal weight) {
        int grade = voteValue == null ? 0 : voteValue.intValue();
        BigDecimal sum = choiceResult.getSumWeight();
        if (sum == null) {
            sum = new BigDecimal(0);
        }
        choiceResult.setSumWeight(sum.add(weight));
        choiceResult.setHalfWeight(choiceResult.getSumWeight().divide(BigDecimal.valueOf(2L), MathContext.DECIMAL32));
        List<BigDecimal> voteByGrad = choiceResult.getVoteByGrad();
        BigDecimal vote = voteByGrad.get(grade).add(weight);
        voteByGrad.set(grade, vote);
    }

    protected void computeMedian(MajorityJudgmentChoiceResult choiceResult) {
        BigDecimal temp = BigDecimal.ZERO;
        BigDecimal demiWeight = choiceResult.getHalfWeight();
        Integer median = null;
        int grad = 0;
        for (BigDecimal voteByGrad : choiceResult.getVoteByGrad()) {
            if ((temp = temp.add(voteByGrad)).compareTo(demiWeight) >= 0) {
                median = grad;
                break;
            }
            ++grad;
        }
        Preconditions.checkNotNull(median);
        choiceResult.setMedian(median);
    }

    protected List<ChoiceScore> computeScore(List<MajorityJudgmentChoiceResult> choiceResults) {
        ArrayList scores = Lists.newArrayListWithCapacity((int)choiceResults.size());
        int order = 0;
        for (MajorityJudgmentChoiceResult choiceResult : choiceResults) {
            ChoiceScore choiceScore = new ChoiceScore();
            choiceScore.setChoiceId(choiceResult.choiceId);
            choiceScore.setScoreValue(BigDecimal.valueOf(choiceResult.getMedian()));
            choiceScore.setScoreOrder(order);
            scores.add(choiceScore);
            ++order;
        }
        return scores;
    }

    protected static int compareChoiceResultSameMedian(MajorityJudgmentChoiceResult a, MajorityJudgmentChoiceResult b) {
        return MajorityJudgmentVoteCountingStrategy.compareChoiceResultSameMedian(a, b, 0);
    }

    protected static int compareChoiceResultSameMedian(MajorityJudgmentChoiceResult a, MajorityJudgmentChoiceResult b, int gradAroundMedian) {
        BigDecimal bUpper;
        BigDecimal aUpper;
        BigDecimal bUnder;
        BigDecimal aUnder;
        int median = a.getMedian();
        int indexUnder = median - gradAroundMedian;
        int indexUpper = median + gradAroundMedian + 1;
        int nbGrades = a.getVoteByGrad().size();
        if (indexUnder <= 0 && indexUpper >= nbGrades) {
            return 0;
        }
        if (indexUnder > 0) {
            aUnder = a.getVoteByGrad().subList(0, indexUnder).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            bUnder = b.getVoteByGrad().subList(0, indexUnder).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            aUnder = BigDecimal.ZERO;
            bUnder = BigDecimal.ZERO;
        }
        if (indexUpper < nbGrades) {
            aUpper = a.getVoteByGrad().subList(indexUpper, nbGrades).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            bUpper = b.getVoteByGrad().subList(indexUpper, nbGrades).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            aUpper = BigDecimal.ZERO;
            bUpper = BigDecimal.ZERO;
        }
        int aUnderAUpper = aUnder.compareTo(aUpper);
        int aUnderBUnder = aUnder.compareTo(bUnder);
        int aUnderBUpper = aUnder.compareTo(bUpper);
        int aUpperBUnder = aUpper.compareTo(bUnder);
        int aUpperBUpper = aUpper.compareTo(bUpper);
        int bUnderBUpper = bUnder.compareTo(bUpper);
        int result = aUnderBUnder < 0 && aUpperBUnder < 0 && bUnderBUpper > 0 || aUnderAUpper < 0 && aUpperBUnder > 0 && aUpperBUpper > 0 ? 1 : (aUnderAUpper > 0 && aUnderBUnder > 0 && aUnderBUpper > 0 || aUnderBUpper < 0 && aUpperBUpper < 0 && bUnderBUpper < 0 ? -1 : (aUnderAUpper == 0 && aUnderBUnder > 0 && aUnderBUpper > 0 && bUnderBUpper < 0 || aUnderBUnder == 0 && aUnderAUpper > 0 && aUnderBUpper > 0 && aUpperBUpper > 0 || aUpperBUnder == 0 && aUnderAUpper < 0 && aUpperBUpper > 0 || aUpperBUpper == 0 && aUnderAUpper < 0 && aUpperBUnder > 0 && aUnderBUnder < 0 || bUnderBUpper == 0 && aUnderBUnder < 0 && aUnderBUpper < 0 && aUnderAUpper > 0 ? 1 : (aUnderAUpper == 0 && aUnderBUnder > 0 && aUnderBUpper > 0 && bUnderBUpper > 0 || aUnderBUnder == 0 && aUnderAUpper > 0 && aUnderBUpper > 0 && aUpperBUpper < 0 || aUnderBUpper == 0 && aUnderAUpper > 0 && aUnderBUnder > 0 || aUpperBUpper == 0 && aUnderAUpper < 0 && aUpperBUnder > 0 && aUnderBUnder > 0 || bUnderBUpper == 0 && aUpperBUnder < 0 && aUnderBUpper < 0 && aUnderAUpper < 0 ? -1 : (aUnderAUpper == 0 && aUnderBUnder == 0 && aUnderBUpper > 0 || aUpperBUnder == 0 && aUpperBUpper == 0 && aUnderAUpper < 0 ? 1 : (aUnderAUpper == 0 && aUnderBUpper == 0 && aUnderBUnder > 0 || aUnderBUnder == 0 && aUnderBUpper == 0 && aUnderAUpper > 0 ? -1 : MajorityJudgmentVoteCountingStrategy.compareChoiceResultSameMedian(a, b, gradAroundMedian + 1))))));
        return result;
    }
}

