/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.votecounting.business.Choice;
import org.chorem.pollen.votecounting.business.Group;
import org.chorem.pollen.votecounting.business.Method;
import org.chorem.pollen.votecounting.business.Vote;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.utils.PercentageBehavior;
import org.chorem.pollen.votecounting.utils.Utils;

public class StandardMethod
implements Method {
    @Override
    public void executeCounting(List<Choice> choices, boolean byGroup) {
        this.calculateGroups(choices);
        if (byGroup) {
            this.calculateChoicesByGroup(choices);
        }
    }

    public void calculateGroups(List<Choice> choices) {
        for (Choice choice : choices) {
            double totalChoice = 0.0;
            for (Group group : choice.getGroups()) {
                this.getValueForGroup(group);
                totalChoice += group.getValue();
            }
            choice.setValue(totalChoice);
        }
    }

    public void getValueForGroup(Group group) {
        double total = 0.0;
        for (Vote vote : group.getVotes()) {
            total += vote.getValue() * vote.getWeight();
        }
        group.setValue(total);
    }

    public void calculateChoicesByGroup(List<Choice> choices) {
        Map<String, List<String>> mapGroupsChoosenChoices = this.getChoosenChoicesByGroup(choices);
        for (Choice choice : choices) {
            double totalChoice = 0.0;
            for (String idGroup : mapGroupsChoosenChoices.keySet()) {
                totalChoice += this.getValueForChoiceByGroup(choice, idGroup, mapGroupsChoosenChoices.get(idGroup));
            }
            choice.setValue(totalChoice);
        }
    }

    public Map<String, List<String>> getChoosenChoicesByGroup(List<Choice> choices) {
        HashMap<String, List<String>> mapGroupsChoosenChoices = new HashMap<String, List<String>>();
        if (choices != null && choices.size() > 0) {
            for (Group group : choices.get(0).getGroups()) {
                double maxValue = 0.0;
                ArrayList<String> choosenChoicesId = new ArrayList<String>();
                for (Choice choice : choices) {
                    Group curr = choice.getGroup(group.getIdGroup());
                    if (curr.getValue() > maxValue) {
                        maxValue = curr.getValue();
                        choosenChoicesId.clear();
                    }
                    if (curr.getValue() == 0.0 || maxValue != curr.getValue()) continue;
                    choosenChoicesId.add(choice.getIdChoice());
                }
                mapGroupsChoosenChoices.put(group.getIdGroup(), choosenChoicesId);
            }
        }
        return mapGroupsChoosenChoices;
    }

    public double getValueForChoiceByGroup(Choice choice, String idGroup, List<String> choicesId) {
        for (String idChoice : choicesId) {
            if (!choice.getIdChoice().equals(idChoice)) continue;
            return 1.0 * choice.getGroup(idGroup).getWeight();
        }
        return 0.0;
    }

    @Override
    public void executeStats(List<Choice> choices, boolean groupCounting, Choice choice, ChoiceDTO choiceDTO) {
        ArrayList<PercentageBehavior> list = new ArrayList<PercentageBehavior>(choices);
        choiceDTO.setPercentage(Utils.calculatePercentage(choice, list));
    }
}

