/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.opensymphony.xwork2.inject.Inject;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.views.util.UrlHelper;
import org.chorem.pollen.bean.PollResult;
import org.chorem.pollen.bean.PollResultList;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.services.impl.PollResultsService;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.poll.AbstractPollUriIdAction;
import org.chorem.pollen.ui.converters.DateConverter;
import org.nuiton.util.StringUtil;

public class ResultForPoll
extends AbstractPollUriIdAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ResultForPoll.class);
    private Boolean byGroup;
    private boolean creatorUser;
    private boolean feedFileExisting;
    private transient Multimap<String, String> choicesResults;
    private transient Multimap<String, String> subtitles;
    private Poll poll;
    private List<PollResult> results;
    private List<PollResult> topRanking;
    @Inject(required=true)
    private UrlHelper urlHelper;

    public PageSkin getSkin() {
        return PageSkin.RESULT;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public boolean isCreatorOrAdmin() {
        return this.creatorUser || this.isUserAdmin();
    }

    public boolean isFeedFileExisting() {
        return this.feedFileExisting;
    }

    public String getSummaryUrl() {
        PollUrl url = this.getPollUrlService().getPollSummaryUrl(this.poll);
        url.getPollUri().setAccountId(this.getAccountId());
        return url.getUrl();
    }

    public String getVoteUrl() {
        PollUrl url = this.getPollUrlService().getPollVoteUrl(this.poll);
        url.getPollUri().setAccountId(this.getAccountId());
        if (this.poll.getPollType() == PollType.FREE) {
            this.getSecurityService().removeAccountIdWhenConnected(url, this.getPollenUserAccount());
        }
        return url.getUrl();
    }

    public List<PollResult> getResults() {
        return this.results;
    }

    public Date getResultAsDate(PollResult result) {
        Date date = new Date(Long.valueOf(result.getName()));
        return date;
    }

    public Multimap<String, String> getChoicesResults() {
        return this.choicesResults;
    }

    public Multimap<String, String> getSubtitles() {
        return this.subtitles;
    }

    public String getVictoryMessage() {
        String victoryMessage = this.poll.getVoteCountingType() == VoteCountingType.NUMBER ? null : (CollectionUtils.isEmpty((Collection)this.topRanking) ? "" : (this.topRanking.size() == 1 ? this._("pollen.common.victory", new Object[0]) : this._("pollen.common.victories", new Object[0])));
        return victoryMessage;
    }

    public String getTrimValue(PollResult result) {
        String value = result.getValue();
        if (value.endsWith(".0")) {
            value = value.substring(0, value.indexOf(46));
        }
        return value;
    }

    public String execute() throws Exception {
        String pollId = this.getPollId();
        Preconditions.checkNotNull((Object)pollId);
        this.poll = this.getPollService().getExistingPollByPollId(pollId);
        this.feedFileExisting = this.getPollFeedService().isFeedExists(this.poll);
        if (this.byGroup == null) {
            this.byGroup = this.isGroupPoll();
        }
        this.creatorUser = this.getSecurityService().isPollCreator(this.poll, this.getAccountId(), this.getPollenUserAccount());
        if (this.poll.isRunning(this.serviceContext.getCurrentTime())) {
            this.addFlashWarning(this._("pollen.information.pollRunning", new Object[0]));
        }
        PollResultsService service = this.getPollResultsService();
        PollResultList resultListDTO = service.getResults(this.poll);
        this.results = resultListDTO.getPollResults();
        if (log.isDebugEnabled()) {
            for (PollResult res : this.results) {
                log.debug((Object)(res + ", (voteCounting=" + res.getVoteCountingType() + ", byGroup=" + res.isByGroup() + ")"));
            }
        }
        if (this.isNumberVoteCounting()) {
            this.choicesResults = LinkedHashMultimap.create();
            this.subtitles = ArrayListMultimap.create();
            this.results = service.createNumberVoteCountingResult(resultListDTO, this.choicesResults, this.subtitles);
        }
        this.topRanking = service.getTopRanking(this.results);
        if (log.isDebugEnabled()) {
            log.debug((Object)("topRanking = " + this.topRanking));
        }
        return "success";
    }

    public List<PollResult> getTopRanking() {
        return this.topRanking;
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextType() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateType() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImageType() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public boolean isNormalVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.NORMAL;
    }

    public boolean isPercentageVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.PERCENTAGE;
    }

    public boolean isCondorcetVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.CONDORCET;
    }

    public boolean isNumberVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.NUMBER;
    }

    public boolean isByGroup() {
        return this.byGroup;
    }

    public void setByGroup(boolean byGroup) {
        this.byGroup = byGroup;
    }

    public List<String> getChoices() {
        ArrayList choiceValues = Lists.newArrayList();
        for (PollResult result : this.results) {
            String name = result.getName();
            String value = result.getValue();
            if (this.isDateType()) {
                Date date = new Date(Long.parseLong(name));
                name = DateConverter.convertToString((Date)date);
            }
            choiceValues.add(name);
            choiceValues.add(value);
        }
        return choiceValues;
    }

    public String getNormalPollResultChartUrl(int width, int height) {
        URL applicationUrl = this.getApplicationUrl();
        StringBuilder url = new StringBuilder(applicationUrl.toString());
        url.append("/io/generateChart");
        HashMap params = Maps.newHashMap();
        params.put("width", width);
        params.put("height", height);
        params.put("title", "");
        params.put("values", this.getChoices());
        this.urlHelper.buildParametersString((Map)params, url, "&");
        String chartUrl = url.toString();
        return chartUrl;
    }

    public Set<String> getChoicesResultNames() {
        return this.choicesResults.keySet();
    }

    public String getChoicesResultCharUrl(int width, int height, String choiceName) {
        URL applicationUrl = this.getApplicationUrl();
        StringBuilder url = new StringBuilder(applicationUrl.toString());
        url.append("/io/generateChart");
        HashMap params = Maps.newHashMap();
        params.put("width", width);
        params.put("height", height);
        params.put("title", "");
        params.put("values", this.choicesResults.get((Object)choiceName));
        params.put("subtitles", this.subtitles.get((Object)choiceName));
        this.urlHelper.buildParametersString((Map)params, url, "&");
        String chartUrl = url.toString();
        return chartUrl;
    }

    public String getChoicesAsString() {
        List choices = this.getChoices();
        return StringUtil.join((Iterable)choices, (String)",", (boolean)true);
    }
}

