/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollEvent;
import org.chorem.pollen.persistence.entity.PollFeed;
import org.chorem.pollen.persistence.entity.PollFeedDao;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.nuiton.i18n.I18n;

public class FeedService
extends PollenServiceSupport {
    public static final String FEED_TYPE = "atom_1.0";
    public static final String DESCRIPTION_TYPE = "text/plain";

    public void onPollEdited(Poll poll) {
        this.addFeedEntry(poll, I18n.t((String)"pollen.service.feed.pollEdited.title", (Object[])new Object[0]));
    }

    public void onPollClosed(Poll poll) {
        this.addFeedEntry(poll, I18n.t((String)"pollen.service.feed.pollClosed.title", (Object[])new Object[0]));
    }

    public void onPollReopened(Poll poll) {
        this.addFeedEntry(poll, I18n.t((String)"pollen.service.feed.pollReopened.title", (Object[])new Object[0]));
    }

    public void onChoiceAdded(Question question, Choice choice) {
        this.addFeedEntry(question.getPoll(), I18n.t((String)"pollen.service.feed.choiceAdded.title", (Object[])new Object[0]));
    }

    public void onVoteAdded(Question question, Vote vote) {
        this.addVoteFeedEntry(question.getPoll(), vote, I18n.n((String)"pollen.service.feed.voteAdded.title", (Object[])new Object[0]));
    }

    public void onVoteEdited(Question question, Vote vote) {
        this.addVoteFeedEntry(question.getPoll(), vote, I18n.n((String)"pollen.service.feed.voteEdited.title", (Object[])new Object[0]));
    }

    public void onVoteDeleted(Question question, Vote vote) {
        this.addVoteFeedEntry(question.getPoll(), vote, I18n.n((String)"pollen.service.feed.voteDeleted.title", (Object[])new Object[0]));
    }

    public void onCommentAdded(Poll poll, Comment comment) {
        this.addFeedEntry(poll, I18n.t((String)"pollen.service.feed.commentAdded.title", (Object[])new Object[]{comment.getAuthor()}));
    }

    public void onCommentEdited(Poll poll, Comment comment) {
        this.addFeedEntry(poll, I18n.t((String)"pollen.service.feed.commentEdited.title", (Object[])new Object[]{comment.getAuthor()}));
    }

    public void onCommentDeleted(Poll poll, Comment comment) {
        this.addFeedEntry(poll, I18n.t((String)"pollen.service.feed.commentDeleted.title", (Object[])new Object[]{comment.getAuthor()}));
    }

    public void onCommentAdded(Question question, Comment comment) {
        this.addFeedEntry(question.getPoll(), I18n.t((String)"pollen.service.feed.commentAdded.title", (Object[])new Object[]{comment.getAuthor()}));
    }

    public void onCommentEdited(Question question, Comment comment) {
        this.addFeedEntry(question.getPoll(), I18n.t((String)"pollen.service.feed.commentEdited.title", (Object[])new Object[]{comment.getAuthor()}));
    }

    public void onCommentDeleted(Question question, Comment comment) {
        this.addFeedEntry(question.getPoll(), I18n.t((String)"pollen.service.feed.commentDeleted.title", (Object[])new Object[]{comment.getAuthor()}));
    }

    public String getFeedContentForPoll(String pollId) {
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        Optional pollFeed = this.getPollFeedDao().tryFindByPoll(poll);
        Optional lastPollEventDate = this.getPollEventDao().tryFindLastEventDateByPoll(poll);
        PollFeed upToDatePollFeed = pollFeed.isEmpty() || lastPollEventDate.isPresent() && ((Date)lastPollEventDate.get()).after(((PollFeed)pollFeed.get()).getTopiaCreateDate()) ? this.computePollFeed(poll) : (PollFeed)pollFeed.get();
        return upToDatePollFeed.getContent();
    }

    private SyndFeed createInitialPollFeed(Poll poll) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(FEED_TYPE);
        feed.setTitle(poll.getTitle());
        String voteUrl = this.getPollVoteUrl(poll);
        feed.setLink(voteUrl);
        feed.setDescription(poll.getDescription());
        return feed;
    }

    private static SyndEntry createOnPollCreatedFeedEntry(Poll poll, String voteUrl) {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle(I18n.t((String)"pollen.service.feed.pollCreated.title", (Object[])new Object[]{poll.getCreator().getName(), poll.getTitle()}));
        entry.setLink(voteUrl);
        entry.setPublishedDate(poll.getTopiaCreateDate());
        SyndContentImpl description = new SyndContentImpl();
        description.setType(DESCRIPTION_TYPE);
        description.setValue(I18n.t((String)"pollen.service.feed.pollCreated.description", (Object[])new Object[]{DateFormat.getDateTimeInstance(3, 3).format(poll.getTopiaCreateDate()), poll.getCreator().getName(), poll.getTitle()}));
        entry.setDescription((SyndContent)description);
        return entry;
    }

    private PollFeed computePollFeed(Poll poll) {
        try {
            SyndFeed feed = this.createFullPollFeed(poll);
            SyndFeedOutput output = new SyndFeedOutput();
            String feedContent = output.outputString(feed);
            PollFeedDao pollFeedDao = this.getPollFeedDao();
            Optional existing = pollFeedDao.tryFindByPoll(poll);
            existing.ifPresent(arg_0 -> ((PollFeedDao)pollFeedDao).delete(arg_0));
            PollFeed pollFeed = (PollFeed)pollFeedDao.newInstance();
            pollFeed.setPoll(poll);
            pollFeed.setContent(feedContent);
            pollFeedDao.create((PollenEntity)pollFeed);
            this.commit();
            return pollFeed;
        }
        catch (FeedException e) {
            throw new PollenTechnicalException("Error while creating the feed", e);
        }
    }

    private SyndFeed createFullPollFeed(Poll poll) {
        SyndFeed feed = this.createInitialPollFeed(poll);
        String pollVoteUrl = this.getPollVoteUrl(poll);
        LinkedList<SyndEntry> entries = new LinkedList<SyndEntry>();
        SyndEntry initialEntry = FeedService.createOnPollCreatedFeedEntry(poll, pollVoteUrl);
        entries.add(initialEntry);
        List events = this.getPollEventDao().findAllByPoll(poll);
        events.stream().sorted(Comparator.comparing(AbstractPollenEntity::getTopiaCreateDate)).map(pollEvent -> FeedService.createPollFeedEntry(pollEvent, pollVoteUrl)).forEach(entries::add);
        feed.setEntries(entries);
        return feed;
    }

    private static SyndEntry createPollFeedEntry(PollEvent pollEvent, String pollVoteUrl) {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle(pollEvent.getTitle());
        entry.setLink(pollVoteUrl);
        entry.setPublishedDate(pollEvent.getTopiaCreateDate());
        return entry;
    }

    private void addVoteFeedEntry(Poll poll, Vote vote, String messageKey) {
        String voterName = vote.isAnonymous() ? I18n.t((String)"pollen.service.feed.anonymous", (Object[])new Object[0]) : vote.getVoter().getName();
        this.addFeedEntry(poll, I18n.t((String)messageKey, (Object[])new Object[]{voterName}));
    }

    private void addFeedEntry(Poll poll, String title) {
        PollEvent pollEvent = (PollEvent)this.getPollEventDao().newInstance();
        pollEvent.setPoll(poll);
        pollEvent.setTitle(title);
        this.getPollEventDao().create((PollenEntity)pollEvent);
        this.commit();
    }
}

