/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.service.mail.ChoiceAddedEmail;
import org.chorem.pollen.services.service.mail.ChoiceDeletedEmail;
import org.chorem.pollen.services.service.mail.ChoiceEditedEmail;
import org.chorem.pollen.services.service.mail.ChoiceReportEmail;
import org.chorem.pollen.services.service.mail.ChoiceReportForAdminEmail;
import org.chorem.pollen.services.service.mail.CommentAddedEmail;
import org.chorem.pollen.services.service.mail.CommentDeletedEmail;
import org.chorem.pollen.services.service.mail.CommentEditedEmail;
import org.chorem.pollen.services.service.mail.CommentReportEmail;
import org.chorem.pollen.services.service.mail.CommentReportForAdminEmail;
import org.chorem.pollen.services.service.mail.ExceedingMaxVotersEmail;
import org.chorem.pollen.services.service.mail.FeedbackEmail;
import org.chorem.pollen.services.service.mail.LostPasswordEmail;
import org.chorem.pollen.services.service.mail.MailBoxService;
import org.chorem.pollen.services.service.mail.PollChoicePeriodEndedEmail;
import org.chorem.pollen.services.service.mail.PollChoicePeriodStartedEmail;
import org.chorem.pollen.services.service.mail.PollClosedEmail;
import org.chorem.pollen.services.service.mail.PollCreatedEmail;
import org.chorem.pollen.services.service.mail.PollEndReminderEmail;
import org.chorem.pollen.services.service.mail.PollInvitationEmail;
import org.chorem.pollen.services.service.mail.PollReportEmail;
import org.chorem.pollen.services.service.mail.PollReportForAdminEmail;
import org.chorem.pollen.services.service.mail.PollVotePeriodEndedEmail;
import org.chorem.pollen.services.service.mail.PollVotePeriodStartedEmail;
import org.chorem.pollen.services.service.mail.PollVoteReminderEmail;
import org.chorem.pollen.services.service.mail.PollenMail;
import org.chorem.pollen.services.service.mail.PollenMailReturnContext;
import org.chorem.pollen.services.service.mail.ResendValidationEmail;
import org.chorem.pollen.services.service.mail.RestrictedPollInvitationEmail;
import org.chorem.pollen.services.service.mail.UserAccountCreatedEmail;
import org.chorem.pollen.services.service.mail.UserAccountCreatedFromProviderEmail;
import org.chorem.pollen.services.service.mail.UserAccountDeletedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEditedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEmailAddressAddedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEmailValidatedEmail;
import org.chorem.pollen.services.service.mail.UserAccountPasswordChangedEmail;
import org.chorem.pollen.services.service.mail.VoteAddedEmail;
import org.chorem.pollen.services.service.mail.VoteDeletedEmail;
import org.chorem.pollen.services.service.mail.VoteEditedEmail;

public enum PollenMailType {
    cha(ChoiceAddedEmail.class),
    chd(ChoiceDeletedEmail.class),
    che(ChoiceEditedEmail.class),
    chr(ChoiceReportEmail.class),
    chrfa(ChoiceReportForAdminEmail.class),
    coa(CommentAddedEmail.class),
    cod(CommentDeletedEmail.class),
    coe(CommentEditedEmail.class),
    cor(CommentReportEmail.class),
    corfa(CommentReportForAdminEmail.class),
    emv(ExceedingMaxVotersEmail.class),
    fb(FeedbackEmail.class),
    lp(LostPasswordEmail.class),
    pcpe(PollChoicePeriodEndedEmail.class),
    pcps(PollChoicePeriodStartedEmail.class),
    pcl(PollClosedEmail.class),
    pcr(PollCreatedEmail.class, (service, context) -> service.undeliveredFlagPollenPrincipal(context.getPoll().getCreator(), context.getMessage())),
    per(PollEndReminderEmail.class),
    pi(PollInvitationEmail.class, (service, context) -> service.forwardToCreatorAction(context.getPoll(), context.getMessage())),
    pr(PollReportEmail.class),
    prfa(PollReportForAdminEmail.class),
    pvpe(PollVotePeriodEndedEmail.class),
    pvps(PollVotePeriodStartedEmail.class),
    pvr(PollVoteReminderEmail.class),
    rv(ResendValidationEmail.class),
    rpi(RestrictedPollInvitationEmail.class, (service, context) -> {
        service.forwardToCreatorAction(context.getPoll(), context.getMessage());
        service.undeliveredFlagPollenPrincipal(context.getPrincipal(), context.getMessage());
    }),
    uac(UserAccountCreatedEmail.class),
    uacfp(UserAccountCreatedFromProviderEmail.class),
    uad(UserAccountDeletedEmail.class),
    uae(UserAccountEditedEmail.class),
    uaeaa(UserAccountEmailAddressAddedEmail.class),
    uaev(UserAccountEmailValidatedEmail.class),
    uapc(UserAccountPasswordChangedEmail.class),
    va(VoteAddedEmail.class),
    vd(VoteDeletedEmail.class),
    ve(VoteEditedEmail.class);

    private final Class<? extends PollenMail> emailType;
    private final BiConsumer<MailBoxService, PollenMailReturnContext> action;

    private PollenMailType(Class<? extends PollenMail> emailType, BiConsumer<MailBoxService, PollenMailReturnContext> action) {
        this.emailType = emailType;
        this.action = action;
    }

    private PollenMailType(Class<? extends PollenMail> emailType) {
        this.emailType = emailType;
        this.action = (service, context) -> service.noAction();
    }

    public Class<? extends PollenMail> getEmailType() {
        return this.emailType;
    }

    public static PollenMailType valueOfMail(PollenMail pollenMail) {
        return Stream.of(PollenMailType.values()).filter(type -> type.getEmailType().isInstance(pollenMail)).findFirst().orElseThrow(() -> new PollenTechnicalException("unknown pollenEmailType of " + String.valueOf(pollenMail.getClass())));
    }

    public BiConsumer<MailBoxService, PollenMailReturnContext> getAction() {
        return this.action;
    }
}

