/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.entity.FavoriteList;
import org.chorem.pollen.persistence.entity.FavoriteListDao;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.persistence.entity.SessionToken;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class PollenUserDao
extends AbstractPollenDao<PollenUser> {
    @Override
    public Class<PollenUser> getEntityClass() {
        return PollenUser.class;
    }

    public void deleteFromParent(PollenUser entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        List list = this.daoSupplier.getFavoriteListDao().forPollenUserEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((FavoriteList)item).getPollenUser())) continue;
            ((FavoriteList)item).setPollenUser(null);
        }
        list = this.daoSupplier.getSessionTokenDao().forPollenUserEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((SessionToken)item).getPollenUser())) continue;
            ((SessionToken)item).setPollenUser(null);
        }
        list = this.daoSupplier.getPollenPrincipalDao().forPollenUserEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((PollenPrincipal)item).getPollenUser())) continue;
            ((PollenPrincipal)item).setPollenUser(null);
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<PollenUser> forAdministratorEquals(boolean v) {
        return this.forEquals("administrator", v);
    }

    public AddCriteriaOrRunQueryStep<PollenUser> forDefaultEmailAddressEquals(PollenUserEmailAddress v) {
        return this.forEquals("defaultEmailAddress", v);
    }

    public AddCriteriaOrRunQueryStep<PollenUser> forEmailAddressesContains(PollenUserEmailAddress v) {
        return this.forContains("emailAddresses", v);
    }

    public PaginationResult<PollenUser> findAll(PaginationParameter page, String search) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String hql = "SELECT user FROM " + PollenUser.class.getName() + " as user";
        if (StringUtils.isNotBlank((CharSequence)search)) {
            hql = hql + " WHERE " + this.getSearchClause("user", parameters, "name", search);
        }
        return this.findPage(hql, parameters, page);
    }

    @Override
    public void delete(PollenUser entity) {
        FavoriteListDao dao = this.daoSupplier.getFavoriteListDao();
        List list = dao.forPollenUserEquals(entity).findAll();
        dao.deleteAll(list);
        this.deleteFromParent(entity);
    }

    public PollenUser findUserWithCredentialOrNull(String providerId, String userId) {
        Objects.requireNonNull(providerId);
        Objects.requireNonNull(userId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String hql = "SELECT user FROM " + PollenUser.class.getName() + " as user INNER JOIN user.userCredential as credentials WHERE credentials.provider = :providerId AND credentials.userId = :userId";
        parameters.put("providerId", providerId);
        parameters.put("userId", userId);
        return (PollenUser)this.findUniqueOrNull(hql, parameters);
    }

    public PollenUser findUserWithEmailAddressOrNull(String emailAddress) {
        Objects.requireNonNull(emailAddress);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String hql = "SELECT user FROM " + PollenUser.class.getName() + " as user INNER JOIN user.emailAddresses as emailAddresses WHERE emailAddresses.emailAddress = :emailAddress";
        parameters.put("emailAddress", emailAddress);
        return (PollenUser)this.findUniqueOrNull(hql, parameters);
    }

    public AddCriteriaOrRunQueryStep<PollenUser> forAvatarEquals(PollenResource v) {
        return this.forEquals("avatar", v);
    }
}

