/*
 * #%L
 * Pollen :: Persistence
 * $Id: CommentDAOImpl.java 3691 2012-09-14 16:33:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.1/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/CommentDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

import java.util.List;

public class CommentDAOImpl<E extends Comment> extends CommentDAOAbstract<E> {

    public List<E> findComments(TopiaPagerBean pager,
                                String pollId) throws TopiaException {

        Preconditions.checkNotNull(pager);
        Preconditions.checkNotNull(pollId);

        String countHql = "SELECT COUNT(e) FROM CommentImpl e, PollImpl p WHERE" +
                          " p.pollId = :pollId AND e IN ELEMENTS(p.comment)";

        computeAndAddRecordsToPager(countHql, pager, "pollId", pollId);

        String hql = "SELECT e FROM CommentImpl e, PollImpl p WHERE " +
                     "p.pollId = :pollId AND e IN ELEMENTS(p.comment)";

        List<E> result = findAllByQueryAndPager(hql, pager, "pollId", pollId);
        return result;
    }

    public List<E> findAllComments(String pollId) throws TopiaException {

        Preconditions.checkNotNull(pollId);

        String hql = "SELECT e FROM CommentImpl e, PollImpl p WHERE " +
                     "p.pollId = :pollId AND e IN ELEMENTS(p.comment)";

        List<E> result = findAllByQuery(hql, "pollId", pollId);
        return result;
    }
}
