/*
 * #%L
 * Pollen :: Persistence
 * 
 * $Id: UserAccountDAOImpl.java 3180 2012-03-14 14:39:03Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/UserAccountDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

import java.util.List;

public class UserAccountDAOImpl<E extends UserAccount> extends UserAccountDAOAbstract<E> {

    public boolean isUserExist(UserAccount user) throws TopiaException {

        Preconditions.checkNotNull(user);

        // In case of email change, check if an other user has not already
        // the new email
        // FIXME-fdesbois-20100510 : replace by using id directly
        TopiaQuery query = createQuery().
                addWhere(UserAccount.PROPERTY_LOGIN,
                         TopiaQuery.Op.NEQ, user.getLogin());
        query.addEquals(UserAccount.PROPERTY_EMAIL,
                        StringUtils.lowerCase(user.getEmail()));

        // existing user found
        boolean result = existByQuery(query);
        return result;
    }

    public List<E> getUsers(TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(pager);

        long records = count();
        pager.setRecords((int) records);

        TopiaQuery query = createQuery("e");
        TopiaFilterPagerUtil.addPagerToQuery(query, pager);

        List<E> result = findAllByQuery(query);
        return result;
    }
} //UserAccountDAOImpl<E extends UserAccount>
