package org.chorem.lima.ui.vatchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.VatStatement;
import org.chorem.lima.entity.VatStatementImpl;
import static org.nuiton.i18n.I18n.t;

public class VatChartMovementForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_VAT_STATEMENT = "vatStatement";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCOUNTS_TEXT_FIELD_TEXT = "accountsTextField.text";
    public static final String BINDING_BOX_NAME_TEXT_FIELD_TEXT = "boxNameTextField.text";
    public static final String BINDING_LABEL_TEXT_FIELD_TEXT = "labelTextField.text";
    public static final String BINDING_MASTER_TEXT_FIELD_TEXT = "masterTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1WS28TSRDueGPnCQGyCY8FFHaRNkircQ5otVIiHgmyIHIAkQih9WXbM008pGd66K5JJkIgfgIX7nDngsSN02oPnDlwQfsXENrDXhHV7fHYY7fDCB9GVj2+r6qm6+t59YmUlSTnHtAkcWQcgh8wZ/3qvXu3mg+YC9eYcqUfgZCk/RspkVKDTHmZXQH5pVHX6dU0vbomgkiELOzJXq6TSQX7nKkWYwDkTD7DVaq6mbmXkyiWHdSsKBvqi/8+l555T1+WCEkirG4GW1n4Vla3k9E6KfkekGPItEurnIbbWIb0w22s95C2rXGq1E0asIfkCRmrk0pEJYIB+bl4ywbD5CcRkB/vUlhrUQkbYpcFmFETMgCyJOS247aEZIHD/YA6se/sUnB1pGNLiSKDWQEyjXGbQMG48G30I6HVh30NkkV1k8ep5xkzkKO6YUcPwVkVgjMadsPGzm/RJmdLQE7kxqv2cFiO8enIiSxhKqAKmKzTJuM4YA2dpNHrxqjjjmXhM+3wLZZAzWcc38l8LiVz5NMmuYbK8I7nvYeNN5d6Kh9xiLquwFbUMIijnYCDUKabItFnZBjIkdR/EMb4+fXbNGR8qX9YxpqfbcWloavHOpuLXI0BRKhjfs1CS2JH//sttUryU+714d453b3rLsZIg5RljGZ8343BVb2DrvaSnuhbUg1ovF/mZz+8/fdNrXcz56yhPcKCGxNJETEJvqaeaa9lDD6vbtBouUEmFOOoSkZ1TlsK20zdWBzytQ+0TneuU9VCiPLYx7//mf/r/Q+kVMPDI6hXozr+BpmAlsQpCO4l0eUrpqLpvXF8HtG1ASnjDnEc0SmzUr0b5wTpViY4j9OWeWRFNSfe/T+7+fpKZyYjWOPJoeHduZT/JBU/5H7IjF6lUmTVp6lIsdgTXcmxiRAZokJRuu8XzfMP2xhGAc8wHgrLFMwCJ7FOXTHN6X+XSF4KvkVRQqlhoZYTlIDyfcoVy0h/f7TNoFfFFi84aNkw6IN2w7d44bGtpH65Kd758cHOjcrYWHrUqTjBWXuXB3XTp3PFuSyHuaN3Np68WhanOWdv6WqKNqSrQektznhysLFUg21MOf0uTrJgb2u1DTakq4G7oMBGpHxTpqmO9k+icPkivOGKMLsRbISpqzjNmKERO30UeJPY4NFcYGJzHrtPYw5rXCh2CwWeamA8uSseBbrQ9EMPr7BLAwQj+jlZgKDC6b6IQfuffT9KORAe1Z8rK225XaCAX4PNGNh3l6bNzw8oaxERvgJU6kLlhAsAAA==";
    private static final Log log = LogFactory.getLog(VatChartMovementForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected VatChartMovementForm VatChartMovementForm = this;
    protected JLabel accountsLabel;
    protected JTextField accountsTextField;
    protected Boolean addState;
    protected JLabel boxNameLabel;
    protected JTextField boxNameTextField;
    protected JButton cancel;
    protected JLabel labelLabel;
    protected JTextField labelTextField;
    protected JLabel masterLabel;
    protected JTextField masterTextField;
    protected JButton ok;
    protected VatStatement vatStatement;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        
        protected void performCancel() {
            setVatStatement(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VatChartMovementForm() {
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0) {
        super(param0);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartMovementForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartMovementForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doKeyReleased__on__accountsTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setAccounts(getAccountsTextField().getText());
    }

    public void doKeyReleased__on__boxNameTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setBoxName(getAccountsTextField().getText());
    }

    public void doKeyReleased__on__labelTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVatStatement().setLabel(labelTextField.getText());
    }

    public void doWindowClosing__on__VatChartMovementForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAccountsLabel() {
        return accountsLabel;
    }

    public JTextField getAccountsTextField() {
        return accountsTextField;
    }

    public Boolean getAddState() {
        return addState;
    }

    public JLabel getBoxNameLabel() {
        return boxNameLabel;
    }

    public JTextField getBoxNameTextField() {
        return boxNameTextField;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getLabelLabel() {
        return labelLabel;
    }

    public JTextField getLabelTextField() {
        return labelTextField;
    }

    public JLabel getMasterLabel() {
        return masterLabel;
    }

    public JTextField getMasterTextField() {
        return masterTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public VatStatement getVatStatement() {
        return vatStatement;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setVatStatement(VatStatement vatStatement) {
        VatStatement oldValue = this.vatStatement;
        this.vatStatement = vatStatement;
        firePropertyChange(PROPERTY_VAT_STATEMENT, oldValue, vatStatement);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToVatChartMovementForm() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAccountsLabel() {
        $objectMap.put("accountsLabel", accountsLabel = new JLabel());
        
        accountsLabel.setName("accountsLabel");
        accountsLabel.setText(t("lima.vatStatement.accounts"));
    }

    protected void createAccountsTextField() {
        $objectMap.put("accountsTextField", accountsTextField = new JTextField());
        
        accountsTextField.setName("accountsTextField");
        accountsTextField.setColumns(15);
        accountsTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__accountsTextField"));
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createBoxNameLabel() {
        $objectMap.put("boxNameLabel", boxNameLabel = new JLabel());
        
        boxNameLabel.setName("boxNameLabel");
        boxNameLabel.setText(t("lima.vatStatement.boxName"));
    }

    protected void createBoxNameTextField() {
        $objectMap.put("boxNameTextField", boxNameTextField = new JTextField());
        
        boxNameTextField.setName("boxNameTextField");
        boxNameTextField.setColumns(15);
        boxNameTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__boxNameTextField"));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createLabelLabel() {
        $objectMap.put("labelLabel", labelLabel = new JLabel());
        
        labelLabel.setName("labelLabel");
        labelLabel.setText(t("lima.vatStatement.label"));
    }

    protected void createLabelTextField() {
        $objectMap.put("labelTextField", labelTextField = new JTextField());
        
        labelTextField.setName("labelTextField");
        labelTextField.setColumns(15);
        labelTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__labelTextField"));
    }

    protected void createMasterLabel() {
        $objectMap.put("masterLabel", masterLabel = new JLabel());
        
        masterLabel.setName("masterLabel");
        masterLabel.setText(t("lima.vatStatement.master"));
    }

    protected void createMasterTextField() {
        $objectMap.put("masterTextField", masterTextField = new JTextField());
        
        masterTextField.setName("masterTextField");
        masterTextField.setColumns(15);
        masterTextField.setEnabled(false);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createVatStatement() {
        $objectMap.put("vatStatement", vatStatement = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToVatChartMovementForm();
        // inline complete setup of $Table0
        $Table0.add(masterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(masterTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(boxNameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(boxNameTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        VatChartMovementForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("VatChartMovementForm", VatChartMovementForm);
        createVatStatement();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMasterLabel();
        createMasterTextField();
        createLabelLabel();
        createLabelTextField();
        createAccountsLabel();
        createAccountsTextField();
        createBoxNameLabel();
        createBoxNameTextField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of VatChartMovementForm
        setName("VatChartMovementForm");
        VatChartMovementForm.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("lima.vatStatement.movement"));
        VatChartMovementForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__VatChartMovementForm"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MASTER_TEXT_FIELD_TEXT, true ,"vatStatement") {
        
            @Override
            public void processDataBinding() {
                if (getVatStatement() != null && getVatStatement().getMasterVatStatement() != null) {
                    SwingUtil.setText(masterTextField, getVatStatement().getMasterVatStatement().getLabel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT_FIELD_TEXT, true ,"vatStatement") {
        
            @Override
            public void processDataBinding() {
                if (getVatStatement() != null) {
                    SwingUtil.setText(labelTextField, getVatStatement().getLabel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ACCOUNTS_TEXT_FIELD_TEXT, true ,"vatStatement") {
        
            @Override
            public void processDataBinding() {
                if (getVatStatement() != null) {
                    SwingUtil.setText(accountsTextField, getVatStatement().getAccounts());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BOX_NAME_TEXT_FIELD_TEXT, true ,"vatStatement") {
        
            @Override
            public void processDataBinding() {
                if (getVatStatement() != null) {
                    SwingUtil.setText(boxNameTextField, getVatStatement().getBoxName());
                }
            }
        });
    }

}