package org.chorem.lima.ui.lettering;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXDatePicker;
import jaxx.runtime.swing.editor.EnumEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.combobox.AccountComboBox;
import org.chorem.lima.ui.common.FinancialPeriodComboBoxModel;
import org.chorem.lima.util.BigDecimalToString;
import org.chorem.lima.util.WrapToolBarLayout;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n.t;

public class LetteringView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LETTERED_ENABLED = "lettered.enabled";
    public static final String BINDING_NO_LETTERED_ENABLED = "noLettered.enabled";
    public static final String BINDING_ROUND_ENABLED = "round.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXy2/cRBifbLN5P9qkTVK1QCg5pNB6N2krIbWCNk1CEm0h6oaqaiTUsT1NprVnXHvcbLoC8SfwJ8CdCxI3TogDZw5cEP8CKhw4wAHxzfgVe2ezjhpFlnfme/y+9+dv/0DVwEdvP8WtluGHTFCXGFt3Hj78xHxKLLFKAsunnuA+iv76Kqiyi0bt9DwQ6J3dhmSvxey1u9z1OCPsCPfNBhoJxKFDgn1ChEBv5DmsIKg10+ubLS/0E6kpKJ3Ur/96VfnK/vKbCkItD9BdBFPme3FllvQ3UIXaAk2Bphe45mC2BzB8yvYA77g8u+vgIPgYu+Q5+gINNtCAh30QJtCl8iYrGYq/5Qk0tLC1jRlx6gK9y/09w9rnPnENh7rYCKnhgHeIRGA0krcHlBx4npIwINDgPma2Q3yBlsqzb0Q8mZRhYlNxj9vEEahWTs5awpFJGVnY2uHcWcE+WHNW+qtlBAeSKzmXhMMAWsBPE/sJ41Akn4Dvp3NsK6EQnEmqqUwL442YXJ7M5W+rPg+Z7uJsCm6hSSBsGGICMN/Uwcwo8jLGsGWBeNHApvTUVI5XHebpJ2N6SAeTr/CWQO9pnGvJW5O3jDt56rysfhNbzzR29TPSEiXtXZJ3b+XpTptkj7JtiCm3UxMu5WnOHKHZptYzmW75FhH7ABrFKhYkosnLmCDMPl7LZEqR8dd7G7WsMWoqSag1JvzDbgrP5aiyIC1oTJMFwn1jjYXumnrtDeyaBtigT5740NY0ARtf2GpaPncc2Q8gM2dz2ZVdqRrKqkFg0yFx6dbLle5OypLV7mxK1yQOdHrKWSz0Wk+hnVyZ3KrCp0/8btAk6+1UQtIhl4oFp07z3pgyMXRtizQFFmGQj3vDg2lwIRdamDNGNmeyQdC3C30khGOB5nY7R9N9uIqG0lxhKEmB6va/melff/j9+/VkEs2B7nNa0iODFCaE53MPqotK1ZPRGAoFdWr3sHdzFw0Hystqyl7UAGvG1wAO9J2R7IZkNzZwsA8iqoO//fjTzONfTqHKOhpxOLbXsaTfhKa8L9OSO3bL+/C2QjR2MATP0xIbDIgnQB2HsvoEOwFpgfkXNeanGMzhn/+ebn53O3FBH0A635U8c0P1ERqgzKGMqHEcT1rt+B31AhLaPJuouhmLPM8rjJwH6vmow9BTQEeYtBIm0Ww7HYoGDVSeE3vx8udQc1hl+qbFGXgmzWKBRqWSHertQEuWJSXzPEvypNu0Qqn9M+US+fYYHZmAXlw6pSCez0H8lHUFORayq11xni/gDFnjGKRHxu9rYF17HmKHvtRhHYxruJc7SSxCBzLaAnrhq0i/yx6xzmGgnWkXpnUR2AS0Lx6QqzGZTm9uQeilXvZ8KLmDVWJxNTCS0gLLXcqoG7pNsE9mIiMH86tQMiwANIvX6vUrS3XpuHEP5gnxIRZ6yutAuXxDUo5FrYPYm4K4Al1o7xERr4GLlw34ES8fKh6jLm51V38DhF5X6vMBmikE6Bg/FRejEpHKhWII7H5BeRgUMVzQYzDk8qQDoraqk2pXK1dZzZJWq1lenCxDp9sdexgEoV9o9XuKylAcOv0de99Jq6WwrWVIiv0kRgL0OhyFvfBkKGbb2hWuo/3FlUskkQ6EZl/sBaSvmABni/2pmzL92nnSJEw2yV5VGJPpgCQiyvg8AHcfHf8w+Hx+sEHo3j4orSwva9uwYikhfgYWQ/oSzMKOtGKbB1RaCtnRjr6rjPubH23sQFwHTO7b8vvDaK+ot2iDOTQsn8CXx5rricPoYrF+ZT76X4ZmpY1657ZYIuoDDj7k8F2KJm7ZsBLNm5TZ4OgPOjT0yedIT4ny+JV8/KmXMF0C07iHZbxZI4Y2dSvaoOax3M7NUJAu8Gql4P0jH//qJVwvAa+fWtFXfBcT3y8hI63615RTdeUKcoyQrRJCJoLc585rSesV/3sg4X/sTzoFlxMAAA==";
    private static final Log log = LogFactory.getLog(LetteringView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AccountComboBox accountComboBox;
    protected JLabel accountLabel;
    protected JButton back;
    protected JLabel balanceStatusLabel;
    protected JLabel beginPeriodLabel;
    protected JAXXDatePicker beginPeriodPicker;
    protected LetteringEditModel editModel;
    protected JLabel endPeriodLabel;
    protected JAXXDatePicker endPeriodPicker;
    protected LetteringViewHandler handler;
    protected JButton lettered;
    protected EnumEditor<TypeEntry> letteredEntryComboBox;
    protected JLabel letteredEntryLabel;
    protected LettringSelectionModel letteringSelectionModel;
    protected JButton next;
    protected JButton noLettered;
    protected JButton refresh;
    protected JButton round;
    protected LetteringTable table;
    protected LetteringTableModel tableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private LetteringView $JPanel0 = this;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private Separator $JToolBar$Separator3;
    private JToolBar $JToolBar0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
          handler.init();
      }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LetteringView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LetteringView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LetteringView() {
        $initialize();
    }

    public LetteringView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LetteringView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public LetteringView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LetteringView(boolean param0) {
        super(param0);
        $initialize();
    }

    public LetteringView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.back(accountComboBox);
    }

    public void doActionPerformed__on__beginPeriodPicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDateStart(beginPeriodPicker.getDate());
    }

    public void doActionPerformed__on__endPeriodPicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDateEnd(endPeriodPicker.getDate());
    }

    public void doActionPerformed__on__lettered(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addLetter();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next(accountComboBox);
    }

    public void doActionPerformed__on__noLettered(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeLetter();
    }

    public void doActionPerformed__on__refresh(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateAllEntries();
    }

    public void doActionPerformed__on__round(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.roundAndCreateEntry();
    }

    public void doItemStateChanged__on__letteredEntryComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setTypeEntry(letteredEntryComboBox.getSelectedItem());
    }

    public void doPropertyChange__on__accountComboBox(PropertyChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().accountComboBoxChange(event);
    }

    public void doValueChanged__on__letteringSelectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.balanceAndActions();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountComboBox getAccountComboBox() {
        return accountComboBox;
    }

    public JLabel getAccountLabel() {
        return accountLabel;
    }

    public JButton getBack() {
        return back;
    }

    public JLabel getBalanceStatusLabel() {
        return balanceStatusLabel;
    }

    public JLabel getBeginPeriodLabel() {
        return beginPeriodLabel;
    }

    public JAXXDatePicker getBeginPeriodPicker() {
        return beginPeriodPicker;
    }

    public LetteringEditModel getEditModel() {
        return editModel;
    }

    public JLabel getEndPeriodLabel() {
        return endPeriodLabel;
    }

    public JAXXDatePicker getEndPeriodPicker() {
        return endPeriodPicker;
    }

    public LetteringViewHandler getHandler() {
        return handler;
    }

    public JButton getLettered() {
        return lettered;
    }

    public EnumEditor<TypeEntry> getLetteredEntryComboBox() {
        return letteredEntryComboBox;
    }

    public JLabel getLetteredEntryLabel() {
        return letteredEntryLabel;
    }

    public LettringSelectionModel getLetteringSelectionModel() {
        return letteringSelectionModel;
    }

    public JButton getNext() {
        return next;
    }

    public JButton getNoLettered() {
        return noLettered;
    }

    public JButton getRefresh() {
        return refresh;
    }

    public JButton getRound() {
        return round;
    }

    public LetteringTable getTable() {
        return table;
    }

    public LetteringTableModel getTableModel() {
        return tableModel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountComboBox() {
        $objectMap.put("accountComboBox", accountComboBox = new AccountComboBox());
        
        accountComboBox.setName("accountComboBox");
        accountComboBox.setShowDecorator(false);
        accountComboBox.setToolTipText(t("lima.lettering.account"));
        accountComboBox.addPropertyChangeListener(JAXXUtil.getEventListener(PropertyChangeListener.class, "propertyChange", this, "doPropertyChange__on__accountComboBox"));
    }

    protected void createAccountLabel() {
        $objectMap.put("accountLabel", accountLabel = new JLabel());
        
        accountLabel.setName("accountLabel");
    }

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setToolTipText(t("lima.lettering.account.back"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createBalanceStatusLabel() {
        $objectMap.put("balanceStatusLabel", balanceStatusLabel = new JLabel());
        
        balanceStatusLabel.setName("balanceStatusLabel");
    }

    protected void createBeginPeriodLabel() {
        $objectMap.put("beginPeriodLabel", beginPeriodLabel = new JLabel());
        
        beginPeriodLabel.setName("beginPeriodLabel");
        beginPeriodLabel.setText(t("lima.lettering.period.begin"));
    }

    protected void createBeginPeriodPicker() {
        $objectMap.put("beginPeriodPicker", beginPeriodPicker = new JAXXDatePicker());
        
        beginPeriodPicker.setName("beginPeriodPicker");
        beginPeriodPicker.setPatternLayout("dd/MM/yyy");
        beginPeriodPicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginPeriodPicker"));
    }

    protected void createEditModel() {
        $objectMap.put("editModel", editModel = new LetteringEditModel());
    }

    protected void createEndPeriodLabel() {
        $objectMap.put("endPeriodLabel", endPeriodLabel = new JLabel());
        
        endPeriodLabel.setName("endPeriodLabel");
        endPeriodLabel.setText(t("lima.lettering.period.end"));
    }

    protected void createEndPeriodPicker() {
        $objectMap.put("endPeriodPicker", endPeriodPicker = new JAXXDatePicker());
        
        endPeriodPicker.setName("endPeriodPicker");
        endPeriodPicker.setPatternLayout("dd/MM/yyy");
        endPeriodPicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endPeriodPicker"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new LetteringViewHandler(this));
    }

    protected void createLettered() {
        $objectMap.put("lettered", lettered = new JButton());
        
        lettered.setName("lettered");
        lettered.setToolTipText(t("lima.lettering.lettered"));
        lettered.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lettered"));
    }

    protected void createLetteredEntryComboBox() {
        $objectMap.put("letteredEntryComboBox", letteredEntryComboBox = new EnumEditor<TypeEntry>(TypeEntry.class));
        
        letteredEntryComboBox.setName("letteredEntryComboBox");
        letteredEntryComboBox.setToolTipText(t("lima.lettering.entry"));
        letteredEntryComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__letteredEntryComboBox"));
    }

    protected void createLetteredEntryLabel() {
        $objectMap.put("letteredEntryLabel", letteredEntryLabel = new JLabel());
        
        letteredEntryLabel.setName("letteredEntryLabel");
    }

    protected void createLetteringSelectionModel() {
        $objectMap.put("letteringSelectionModel", letteringSelectionModel = new LettringSelectionModel(tableModel));
        
        letteringSelectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__letteringSelectionModel"));
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setToolTipText(t("lima.lettering.account.next"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createNoLettered() {
        $objectMap.put("noLettered", noLettered = new JButton());
        
        noLettered.setName("noLettered");
        noLettered.setToolTipText(t("lima.lettering.unLettered"));
        noLettered.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__noLettered"));
    }

    protected void createRefresh() {
        $objectMap.put("refresh", refresh = new JButton());
        
        refresh.setName("refresh");
        refresh.setToolTipText(t("lima.lettering.refresh"));
        refresh.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__refresh"));
    }

    protected void createRound() {
        $objectMap.put("round", round = new JButton());
        
        round.setName("round");
        round.setToolTipText(t("lima.lettering.equalize"));
        round.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__round"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new LetteringTable(handler));
        
        table.setName("table");
        table.setSortable(false);
        table.setRowHeight(22);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new LetteringTableModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JToolBar0, BorderLayout.PAGE_START);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        // inline complete setup of $JToolBar0
        $JToolBar0.add(lettered);
        $JToolBar0.add(noLettered);
        $JToolBar0.add(round);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add(accountLabel);
        $JToolBar0.add(accountComboBox, BorderLayout.CENTER);
        $JToolBar0.add(back);
        $JToolBar0.add(next);
        $JToolBar0.add($JToolBar$Separator1);
        $JToolBar0.add(beginPeriodLabel);
        $JToolBar0.add(beginPeriodPicker);
        $JToolBar0.add(endPeriodLabel);
        $JToolBar0.add(endPeriodPicker);
        $JToolBar0.add($JToolBar$Separator2);
        $JToolBar0.add(letteredEntryLabel);
        $JToolBar0.add(letteredEntryComboBox);
        $JToolBar0.add($JToolBar$Separator3);
        $JToolBar0.add(refresh);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(table);
        // inline complete setup of $JPanel1
        $JPanel1.add(balanceStatusLabel, BorderLayout.EAST);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 24 property setters
        letteredEntryLabel.setIcon(SwingUtil.createActionIcon("choose-entry"));
        letteredEntryLabel.setLabelFor(letteredEntryComboBox);
        table.setModel(tableModel);
        table.setSelectionModel(letteringSelectionModel);
        lettered.setIcon(SwingUtil.createActionIcon("lettering"));
        noLettered.setIcon(SwingUtil.createActionIcon("un-lettering"));
        round.setIcon(SwingUtil.createActionIcon("balance"));
        accountLabel.setLabelFor(accountComboBox);
        accountLabel.setIcon(SwingUtil.createActionIcon("choose-account"));
        accountComboBox.setMinimumSize(new Dimension(300,10));
        accountComboBox.setSelectedItem(getHandler().getAccount());
        accountComboBox.setPreferredSize(new Dimension(400,25));
        accountComboBox.setMaximumSize(new Dimension(500,40));
        back.setIcon(SwingUtil.createActionIcon("previous"));
        next.setIcon(SwingUtil.createActionIcon("next"));
        beginPeriodLabel.setLabelFor(beginPeriodPicker);
        endPeriodLabel.setLabelFor(endPeriodPicker);
        letteredEntryLabel.setIcon(SwingUtil.createActionIcon("choose-entry"));
        refresh.setIcon(SwingUtil.createActionIcon("refresh"));
        balanceStatusLabel.setHorizontalTextPosition(JLabel.RIGHT);
        balanceStatusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createEditModel();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setLayout(new WrapToolBarLayout());
        $JToolBar0.setFloatable(false);
        createLettered();
        createNoLettered();
        createRound();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        createAccountLabel();
        createAccountComboBox();
        createBack();
        createNext();
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        createBeginPeriodLabel();
        createBeginPeriodPicker();
        createEndPeriodLabel();
        createEndPeriodPicker();
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        createLetteredEntryLabel();
        createLetteredEntryComboBox();
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        createRefresh();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTableModel();
        createLetteringSelectionModel();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createBalanceStatusLabel();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LETTERED_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("lettred", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    lettered.setEnabled(editModel.isLettred());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("lettred", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_LETTERED_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("unLettred", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    noLettered.setEnabled(editModel.isUnLettred());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("unLettred", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ROUND_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("equalized", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    round.setEnabled(editModel.isEqualized());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("equalized", this);
                }
            }
        });
    }

}