package org.chorem.lima.ui.identity;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Identity;
import static org.nuiton.i18n.I18n.t;

public class IdentityForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_IDENTITY = "identity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Xz28cNRT2bpvNryakWZK0NKFpCShVpdkQxCkF2m4SkmjJRiRCVYMI3hk363Z+MeNpN61A/An8CXDngsSNE+LAmQMXxL+AUA9cEc/e2dnxrGdiokTKaNZ+73vve2O/z/7+LzQUBujGY9zpGEHkMuoQY+fegwfN1mNisnUSmgH1mReg7l+pjMqHaNxKxkOG3jhscPda7F6re47vucRNea810FjITmwStglhDC3IHmYY1vaT6bWOHwU91CQpFeq3L/8uf2N9/V0ZoY4P2S0AlcXTvPpMLjZQmVoMTUOkp7hmY/cY0gioewz5TvCxuo3DcBc75Av0FRpuoIqPAwBj6KY+ZYEh/Ds+QxWLYts7ZmjZC44Ns+0FxDFs6mAjoga1AIKyE2M7ftn0Asf3hXeFoeE2di2bBAzd1nHe6lr3/Ud6JgxdzwJkfFNBlw5wyyYrDF2RKhs+gzoZYo5bjiYOoy7Uq4FbxIbK8iJ2YtsdMcitphPjCW58QDpskxIbPsWs5JBMyE4jSzt72CX2SjaAGJVtp/w2fJjdyGmRIIk/J9u8mrKRQr6Wweote+q5uVgpmyKsMeJgauehTIrZIv9L2LICEoZ5CFPxfBFGtRWF1AWj4vLMyWZFiJfjqKtFRpNPMSuOOJ1YFJbgOfXrnkVySxDPF2HAUhLuKwr/CRM2QpHznMm3Nn1ETcw/d1Eu1wZNT0lLrOW3+e8FeX9VTOyafHNVpbV/P2LMc7nNemJa9p7wt614NEDXpC0Mbdfot91+XywdoqEggmHY84eDnfpjmOr26CuZHs0Bxey/s9Xff/rzx810Y55RmqZ0BRqmH3g+9DfKQ7/S7coRo3btI+yvHaLRkNggSkJ05hWJ7cfTkBzEu8zdDe5ubOGwDRBDw3/8/Mvs579dQOVNNGZ72NrE3H4bjbI2LNu2Z1sd/4O7IqNLz0bgOQX/Fxgagp5oQ4kmRK/st9EZizzCkc3qtheSJqQuvi7o24udddHnjfXm0W7zYGt798Oj5u5RvdHc3/gS8BzPwvAJL7IgIh2o5Lyikgmd1uiv/1T3f7jbq2YJ2F3NNe9XdOghqlDXhr0rhC7WMKWwjfshiSyvr1Uq9UKJfPmxPuyJ58FAyUqcGqxv2MpSxQze7jsRd/pUEOFvn6G0aJwGXU6gb7yI9dA4JqwnXMu3+C/ObPkWFHrY9OzIcWHBlFdXVIFlAdLndVXmler6qigDyqHPcjmf5XofNEv2HSVZpTjpc56ROce9XhVIUid9rkv5XO91AfV4DoiffgpvnprCql4Og1J45kLHOqYsdFoDz6XQD7uAGZKld5V1zirsmfsCl1plX+AT59cX6uJNqy9I4q/Pa17mJR+dVIFUhzB9rrfzud6XcPVY5x319PnPyfyTg5wqWuYgqM/6rXzWn/Qg9QgrTpr6XBcza3jgiKcscc6hUZ99rWB9D2Br7eOi0+mZJTF1qVL2juzF7Fwkca8PqrcAlHc/fc5VmbO4tqnCpK57+jxv5vPc4HB6DDN3Sf3w44Jb77YxBkdlWBvbJj/fxncQVbh4Sj/MsAjjPcmEgLuLCh6GNb5OxcYnHlyI0OQdCzO82KKuBbek9wcQS/w5poPY8gKLBDBfuq5GqWqgjDvUpU7k7NPnpABq/n/o6J3uCX8RMxbQVsRIDsn3TsXkCb1ekNUGIPwHyUF8TjAUAAA=";
    private static final Log log = LogFactory.getLog(IdentityForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField address2TextField;
    protected JLabel addressLabel;
    protected JTextField addressTextField;
    protected JLabel businessNumberLabel;
    protected JTextField businessNumberTextField;
    protected JButton cancel;
    protected JTextField cityTextField;
    protected JLabel classificationCodeLabel;
    protected JTextField classificationCodeTextField;
    protected JLabel descriptionLabel;
    protected JTextField descriptionTextField;
    protected IdentityForm dialog = this;
    protected JLabel emailLabel;
    protected JTextField emailTextField;
    protected IdentityHandler handler;
    protected Identity identity;
    protected JLabel nameLabel;
    protected JTextField nameTextField;
    protected JButton ok;
    protected JLabel phoneNumberLabel;
    protected JTextField phoneNumberTextField;
    protected JLabel vatNumberLabel;
    protected JTextField vatNumberTextField;
    protected JLabel zipCodeLabel;
    protected JTextField zipCodeTextField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IdentityForm() {
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateIdentity(); dispose();
    }

    public void doWindowClosing__on__dialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getAddress2TextField() {
        return address2TextField;
    }

    public JLabel getAddressLabel() {
        return addressLabel;
    }

    public JTextField getAddressTextField() {
        return addressTextField;
    }

    public JLabel getBusinessNumberLabel() {
        return businessNumberLabel;
    }

    public JTextField getBusinessNumberTextField() {
        return businessNumberTextField;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JTextField getCityTextField() {
        return cityTextField;
    }

    public JLabel getClassificationCodeLabel() {
        return classificationCodeLabel;
    }

    public JTextField getClassificationCodeTextField() {
        return classificationCodeTextField;
    }

    public JLabel getDescriptionLabel() {
        return descriptionLabel;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public JLabel getEmailLabel() {
        return emailLabel;
    }

    public JTextField getEmailTextField() {
        return emailTextField;
    }

    public IdentityHandler getHandler() {
        return handler;
    }

    public Identity getIdentity() {
        return identity;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JTextField getNameTextField() {
        return nameTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public JLabel getPhoneNumberLabel() {
        return phoneNumberLabel;
    }

    public JTextField getPhoneNumberTextField() {
        return phoneNumberTextField;
    }

    public JLabel getVatNumberLabel() {
        return vatNumberLabel;
    }

    public JTextField getVatNumberTextField() {
        return vatNumberTextField;
    }

    public JLabel getZipCodeLabel() {
        return zipCodeLabel;
    }

    public JTextField getZipCodeTextField() {
        return zipCodeTextField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(IdentityHandler handler) {
        IdentityHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setIdentity(Identity identity) {
        Identity oldValue = this.identity;
        this.identity = identity;
        firePropertyChange(PROPERTY_IDENTITY, oldValue, identity);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
    }

    protected void createAddress2TextField() {
        $objectMap.put("address2TextField", address2TextField = new JTextField());
        
        address2TextField.setName("address2TextField");
        address2TextField.setColumns(15);
        address2TextField.setColumns(30);
    }

    protected void createAddressLabel() {
        $objectMap.put("addressLabel", addressLabel = new JLabel());
        
        addressLabel.setName("addressLabel");
        addressLabel.setText(t("lima.identity.address"));
    }

    protected void createAddressTextField() {
        $objectMap.put("addressTextField", addressTextField = new JTextField());
        
        addressTextField.setName("addressTextField");
        addressTextField.setColumns(15);
        addressTextField.setColumns(30);
    }

    protected void createBusinessNumberLabel() {
        $objectMap.put("businessNumberLabel", businessNumberLabel = new JLabel());
        
        businessNumberLabel.setName("businessNumberLabel");
        businessNumberLabel.setText(t("lima.identity.businessNumber"));
    }

    protected void createBusinessNumberTextField() {
        $objectMap.put("businessNumberTextField", businessNumberTextField = new JTextField());
        
        businessNumberTextField.setName("businessNumberTextField");
        businessNumberTextField.setColumns(15);
        businessNumberTextField.setColumns(20);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCityTextField() {
        $objectMap.put("cityTextField", cityTextField = new JTextField());
        
        cityTextField.setName("cityTextField");
        cityTextField.setColumns(15);
        cityTextField.setColumns(20);
    }

    protected void createClassificationCodeLabel() {
        $objectMap.put("classificationCodeLabel", classificationCodeLabel = new JLabel());
        
        classificationCodeLabel.setName("classificationCodeLabel");
        classificationCodeLabel.setText(t("lima.identity.classificationCode"));
    }

    protected void createClassificationCodeTextField() {
        $objectMap.put("classificationCodeTextField", classificationCodeTextField = new JTextField());
        
        classificationCodeTextField.setName("classificationCodeTextField");
        classificationCodeTextField.setColumns(15);
        classificationCodeTextField.setColumns(5);
    }

    protected void createDescriptionLabel() {
        $objectMap.put("descriptionLabel", descriptionLabel = new JLabel());
        
        descriptionLabel.setName("descriptionLabel");
        descriptionLabel.setText(t("lima.identity.description"));
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
        descriptionTextField.setColumns(30);
    }

    protected void createEmailLabel() {
        $objectMap.put("emailLabel", emailLabel = new JLabel());
        
        emailLabel.setName("emailLabel");
        emailLabel.setText(t("lima.identity.email"));
    }

    protected void createEmailTextField() {
        $objectMap.put("emailTextField", emailTextField = new JTextField());
        
        emailTextField.setName("emailTextField");
        emailTextField.setColumns(15);
        emailTextField.setColumns(20);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new IdentityHandler(this));
    }

    protected void createIdentity() {
        $objectMap.put("identity", identity = handler.getIdentity());
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(t("lima.identity.name"));
    }

    protected void createNameTextField() {
        $objectMap.put("nameTextField", nameTextField = new JTextField());
        
        nameTextField.setName("nameTextField");
        nameTextField.setColumns(15);
        nameTextField.setColumns(20);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createPhoneNumberLabel() {
        $objectMap.put("phoneNumberLabel", phoneNumberLabel = new JLabel());
        
        phoneNumberLabel.setName("phoneNumberLabel");
        phoneNumberLabel.setText(t("lima.identity.phoneNumber"));
    }

    protected void createPhoneNumberTextField() {
        $objectMap.put("phoneNumberTextField", phoneNumberTextField = new JTextField());
        
        phoneNumberTextField.setName("phoneNumberTextField");
        phoneNumberTextField.setColumns(15);
        phoneNumberTextField.setColumns(20);
    }

    protected void createVatNumberLabel() {
        $objectMap.put("vatNumberLabel", vatNumberLabel = new JLabel());
        
        vatNumberLabel.setName("vatNumberLabel");
        vatNumberLabel.setText(t("lima.identity.vatNumber"));
    }

    protected void createVatNumberTextField() {
        $objectMap.put("vatNumberTextField", vatNumberTextField = new JTextField());
        
        vatNumberTextField.setName("vatNumberTextField");
        vatNumberTextField.setColumns(15);
        vatNumberTextField.setColumns(20);
    }

    protected void createZipCodeLabel() {
        $objectMap.put("zipCodeLabel", zipCodeLabel = new JLabel());
        
        zipCodeLabel.setName("zipCodeLabel");
        zipCodeLabel.setText(t("lima.identity.zipCode"));
    }

    protected void createZipCodeTextField() {
        $objectMap.put("zipCodeTextField", zipCodeTextField = new JTextField());
        
        zipCodeTextField.setName("zipCodeTextField");
        zipCodeTextField.setColumns(15);
        zipCodeTextField.setColumns(5);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDialog();
        // inline complete setup of $Table0
        $Table0.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameTextField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(4, 0, 1, 5, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(phoneNumberLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(phoneNumberTextField, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailLabel, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailTextField, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addressTextField, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(businessNumberLabel, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(businessNumberTextField, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(address2TextField, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatNumberLabel, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatNumberTextField, new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(zipCodeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(zipCodeTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cityTextField, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(classificationCodeLabel, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(classificationCodeTextField, new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(cancel);
        $JPanel1.add(ok);
        
        // apply 18 property setters
        $Table0.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        $JPanel0.setMinimumSize(new Dimension(20, 20));
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        SwingUtil.setText(nameTextField, handler.getIdentity().getName());
        
        SwingUtil.setText(phoneNumberTextField, handler.getIdentity().getPhoneNumber());
        
        SwingUtil.setText(descriptionTextField, handler.getIdentity().getDescription());
        
        SwingUtil.setText(emailTextField, handler.getIdentity().getEmail());
        
        SwingUtil.setText(addressTextField, handler.getIdentity().getAddress());
        
        SwingUtil.setText(businessNumberTextField, handler.getIdentity().getBusinessNumber());
        
        SwingUtil.setText(address2TextField, handler.getIdentity().getAddress2());
        
        SwingUtil.setText(vatNumberTextField, handler.getIdentity().getVatNumber());
        
        SwingUtil.setText(zipCodeTextField, handler.getIdentity().getZipCode());
        
        SwingUtil.setText(cityTextField, handler.getIdentity().getCity());
        
        SwingUtil.setText(classificationCodeTextField, handler.getIdentity().getClassificationCode());
        
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        dialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dialog", dialog);
        createHandler();
        createIdentity();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNameLabel();
        createNameTextField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createPhoneNumberLabel();
        createPhoneNumberTextField();
        createDescriptionLabel();
        createDescriptionTextField();
        createEmailLabel();
        createEmailTextField();
        createAddressLabel();
        createAddressTextField();
        createBusinessNumberLabel();
        createBusinessNumberTextField();
        createAddress2TextField();
        createVatNumberLabel();
        createVatNumberTextField();
        createZipCodeLabel();
        createZipCodeTextField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("lima.identity.city"));
        createCityTextField();
        createClassificationCodeLabel();
        createClassificationCodeTextField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of dialog
        setName("dialog");
        dialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("lima.identity"));
        setModal(true);
        dialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__dialog"));
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}