package org.chorem.lima.ui.account;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.AccountsChartEnum;
import org.chorem.lima.ui.common.LabelListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class AccountImportForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1VTW/URhh+d2E3yaZ8hBAUVFK2IYekAm+EKi6JWkhC2qClIMIBsRdm7WnWydjjzrwmjqJU/Qn8BLj3Uqm3nqoeeu6BC+pfqCoOXBHvjL0fzhpYsVpZ1vv5vM+8z/jX/6CiFXy5y5LEUXGIfsCdO7cePbrX3uUubnDtKj9CqSD9lcpQbsGk17NrhCutpklvZOmNdRlEMuThQPZKE2oaDwTXHc4RYS6f4Wrd2O65V5IoVt2qPVBFVZ+//r/8zPvlRRkgiQhdjUapfyyrP8nJJpR9D+EcdXrKGoKFOwRD+eEO4T1lbOuCaf0DC/hP8DOMNaEaMUXFEOZHH9nWsPlJhDDNXFdS1hYlKNzwmZA7CFel2nHcjlQ8cIQfMCf2nSzQuTWYsClVEEW2XBVhsh0jyvA7JWMqPZ+bXO/THPYo1/pB/dRx5nnbyJAjTJlJHTO9syal4Cwc6NA9aV+GRJSJTLqlm6zNhYmb6IWPLTxkbcGXEWYLwFhfPmHK7TCF2Yi9gufNY6Y4iKhuS4SZHBRrXJNJPm984c59FnKxfBy5teaBVF0WulzQAeUiU+5MzFwvtCz3zNt8ZlXweW5WWmanv8z9bSu1oKJiMhM5reH9f0CudPNnj22+KWi9by9Mv/zj3983B9d9pjB0QK20hpGSEVfom9Zn0l2P0ReNuyxaacGE5oKkbqV8qQDYduYmcNQvXRaT7nzPdIdKVMZe/fnXhSf/nIDyJtSEZN4mM/FbMIEdRSxI4SXRtzctos/2x+l51mBDqKCPgiiativf3XffLnpCRFwqIKKHpj3x95vp7d9udskoEbiL7w3vE1J5DFU/FH7IrfozYReqfTLSPPZkX8BFkoZiTXel9pV9OkPjlxFOIk/oKrlcML2Tk121LZVHBwjXDtfsW0rwgeMqTgq+HUR4kDoWb1ytZ/+loyQ2ra9bbszb15DX88cglnoQ0wOyKuwC1UXVh9U8Ag2VQHpGeDcOQ75f3+A/slhgV9B3jW8xq6jXTfnbYRw4T5mIuV5cWjoimdOVTLMbguZsDdu56Wtc50I8yJyLxYQM3y2jn9xkSkt2cdToUIjVLdceWWot6pi5Rm8zZtvIvWMt6BoqKk/mEQ52xst4FlLze3Q7sHTVTq96DFm97Yce3X/fDDUomWdthAZVwQ5kjMbPP72K2Q1G3J5bTSVbZ0jfZ/rq8U+GZsy7H4D1BVV4B/JtvXYWCQAA";
    private static final Log log = LogFactory.getLog(AccountImportForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AccountImportForm accountImportDialog = this;
    protected Boolean addState;
    protected JAXXButtonGroup buttonGroup;
    protected JButton cancel;
    protected JComboBox chartAccountCombo;
    protected JLabel chartAccountLabel;
    protected JLabel description;
    protected JButton ok;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            chartAccountCombo.setSelectedItem(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountImportForm() {
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0) {
        super(param0);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doWindowClosing__on__accountImportDialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JAXXButtonGroup getButtonGroup() {
        return buttonGroup;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JComboBox getChartAccountCombo() {
        return chartAccountCombo;
    }

    public JLabel getChartAccountLabel() {
        return chartAccountLabel;
    }

    public JLabel getDescription() {
        return description;
    }

    public JButton getOk() {
        return ok;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccountImportDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(description, BorderLayout.NORTH);
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createButtonGroup() {
        $objectMap.put("buttonGroup", buttonGroup = new JAXXButtonGroup());
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChartAccountCombo() {
        $objectMap.put("chartAccountCombo", chartAccountCombo = new JComboBox());
        
        chartAccountCombo.setName("chartAccountCombo");
    }

    protected void createChartAccountLabel() {
        $objectMap.put("chartAccountLabel", chartAccountLabel = new JLabel());
        
        chartAccountLabel.setName("chartAccountLabel");
        chartAccountLabel.setText(t("lima.chart.accounts"));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JLabel());
        
        description.setName("description");
        description.setText(t("lima.account.import.description"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAccountImportDialog();
        // inline complete setup of $Table0
        $Table0.add(chartAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(chartAccountCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 8 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        description.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        chartAccountCombo.setModel(new DefaultComboBoxModel(AccountsChartEnum.values()));
        chartAccountCombo.setRenderer(new LabelListCellRenderer());
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        accountImportDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("accountImportDialog", accountImportDialog);
        createButtonGroup();
        createAddState();
        createDescription();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createChartAccountLabel();
        createChartAccountCombo();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of accountImportDialog
        setName("accountImportDialog");
        accountImportDialog.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("lima.account.import"));
        accountImportDialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__accountImportDialog"));
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}