package org.chorem.lima.ui;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingApplicationContext;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.enums.ImportExportEnum;
import static org.nuiton.i18n.I18n.t;

public class MainView extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FR_ENABLED = "fr.enabled";
    public static final String BINDING_UK_ENABLED = "uk.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MainView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem about;
    protected JMenuItem accounts;
    protected BetaLayerUI betaLayer;
    protected JTabbedPane contentTabbedPane;
    protected JMenu csv;
    protected JMenu csvExport;
    protected JMenuItem csvExportAccounts;
    protected JMenuItem csvExportAll;
    protected JMenuItem csvExportEntries;
    protected JMenuItem csvExportEntryBooks;
    protected JMenuItem csvExportFinancialStatements;
    protected JMenuItem csvExportVatStatements;
    protected JMenu csvImport;
    protected JMenuItem csvImportAccounts;
    protected JMenuItem csvImportAll;
    protected JMenuItem csvImportEntries;
    protected JMenuItem csvImportEntryBooks;
    protected JMenuItem csvImportFinancialStatements;
    protected JMenuItem csvImportVatStatements;
    protected JMenuItem documents;
    protected JMenu ebp;
    protected JMenu ebpExport;
    protected JMenuItem ebpExportAccounts;
    protected JMenuItem ebpExportEntries;
    protected JMenuItem ebpExportEntryBooks;
    protected JMenu ebpImport;
    protected JMenuItem ebpImportAccounts;
    protected JMenuItem ebpImportEntries;
    protected JMenuItem ebpImportEntryBooks;
    protected JMenu enter;
    protected JMenuItem entries;
    protected JMenuItem entryBooks;
    protected JMenu file;
    protected JMenuItem financialPeriods;
    protected JMenuItem financialStatements;
    protected JMenuItem fiscalControlExport;
    protected JMenuItem fiscalYears;
    protected JMenuItem fr;
    protected JMenu help;
    protected JMenu i18n;
    protected JMenuItem identity;
    protected JMenuItem lettering;
    protected JPanel mainPanel;
    protected MainView mainView = this;
    protected JMenuItem preferences;
    protected JMenuItem quit;
    protected JMenuItem search;
    protected JMenuItem site;
    protected JMenu structure;
    protected JMenuItem uk;
    protected JMenuItem unbalanced;
    protected JMenuItem vatStatements;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenuBar $JMenuBar0;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            SwingUtil.getLayer(mainPanel).setUI(betaLayer);
        }
    
        public LimaSwingConfig getConfig() {
            return LimaSwingApplicationContext.CONFIG_DEF.getContextValue(getDelegateContext());
        }
    
        public MainViewHandler getHandler() {
            return getContextValue(MainViewHandler.class);
        }
    
        public boolean acceptLocale(Locale l, String expected) {
          return l != null && l.toString().equals(expected);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainView() {
        $initialize();
    }

    public MainView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainView(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainView(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainView(String param0) {
        super(param0);
        $initialize();
    }

    public MainView(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainView(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainView(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__about(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__accounts(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAccountView(this);
    }

    public void doActionPerformed__on__csvExportAccounts(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ACCOUNTCHARTS_EXPORT);
    }

    public void doActionPerformed__on__csvExportAll(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ALL_EXPORT);
    }

    public void doActionPerformed__on__csvExportEntries(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRIES_EXPORT);
    }

    public void doActionPerformed__on__csvExportEntryBooks(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRYBOOKS_EXPORT);
    }

    public void doActionPerformed__on__csvExportFinancialStatements(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_FINANCIALSTATEMENTS_EXPORT);
    }

    public void doActionPerformed__on__csvExportVatStatements(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_VAT_EXPORT);
    }

    public void doActionPerformed__on__csvImportAccounts(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ACCOUNTCHARTS_IMPORT);
    }

    public void doActionPerformed__on__csvImportAll(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ALL_IMPORT);
    }

    public void doActionPerformed__on__csvImportEntries(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRIES_IMPORT);
    }

    public void doActionPerformed__on__csvImportEntryBooks(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRYBOOKS_IMPORT);
    }

    public void doActionPerformed__on__csvImportFinancialStatements(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT);
    }

    public void doActionPerformed__on__csvImportVatStatements(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_VAT_IMPORT);
    }

    public void doActionPerformed__on__documents(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().openLimaHttpUi(this);
    }

    public void doActionPerformed__on__ebpExportAccounts(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ACCOUNTCHARTS_EXPORT);
    }

    public void doActionPerformed__on__ebpExportEntries(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ENTRIES_EXPORT);
    }

    public void doActionPerformed__on__ebpExportEntryBooks(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ENTRYBOOKS_EXPORT);
    }

    public void doActionPerformed__on__ebpImportAccounts(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ACCOUNTCHARTS_IMPORT);
    }

    public void doActionPerformed__on__ebpImportEntries(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ENTRIES_IMPORT);
    }

    public void doActionPerformed__on__ebpImportEntryBooks(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ENTRYBOOKS_IMPORT);
    }

    public void doActionPerformed__on__entries(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showTransactionView(this);
    }

    public void doActionPerformed__on__entryBooks(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showEntryBookView(this);
    }

    public void doActionPerformed__on__financialPeriods(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFinancialPeriodView(this);
    }

    public void doActionPerformed__on__financialStatements(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFinancialStatementView(this);
    }

    public void doActionPerformed__on__fiscalControlExport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFiscalControlExport(this);
    }

    public void doActionPerformed__on__fiscalYears(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFiscalPeriodView(this);
    }

    public void doActionPerformed__on__fr(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__identity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showIdentity(this);
    }

    public void doActionPerformed__on__lettering(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showLetteringView(this);
    }

    public void doActionPerformed__on__preferences(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__quit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    public void doActionPerformed__on__search(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showTransactionSearchView(this);
    }

    public void doActionPerformed__on__site(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().gotoSite(this);
    }

    public void doActionPerformed__on__uk(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__unbalanced(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showTransactionUnbalancedView(this);
    }

    public void doActionPerformed__on__vatStatements(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showVatChartView(this);
    }

    public void doStateChanged__on__contentTabbedPane(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().swingSession.save();
    }

    public void doWindowClosing__on__mainView(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getAbout() {
        return about;
    }

    public JMenuItem getAccounts() {
        return accounts;
    }

    public BetaLayerUI getBetaLayer() {
        return betaLayer;
    }

    public JTabbedPane getContentTabbedPane() {
        return contentTabbedPane;
    }

    public JMenu getCsv() {
        return csv;
    }

    public JMenu getCsvExport() {
        return csvExport;
    }

    public JMenuItem getCsvExportAccounts() {
        return csvExportAccounts;
    }

    public JMenuItem getCsvExportAll() {
        return csvExportAll;
    }

    public JMenuItem getCsvExportEntries() {
        return csvExportEntries;
    }

    public JMenuItem getCsvExportEntryBooks() {
        return csvExportEntryBooks;
    }

    public JMenuItem getCsvExportFinancialStatements() {
        return csvExportFinancialStatements;
    }

    public JMenuItem getCsvExportVatStatements() {
        return csvExportVatStatements;
    }

    public JMenu getCsvImport() {
        return csvImport;
    }

    public JMenuItem getCsvImportAccounts() {
        return csvImportAccounts;
    }

    public JMenuItem getCsvImportAll() {
        return csvImportAll;
    }

    public JMenuItem getCsvImportEntries() {
        return csvImportEntries;
    }

    public JMenuItem getCsvImportEntryBooks() {
        return csvImportEntryBooks;
    }

    public JMenuItem getCsvImportFinancialStatements() {
        return csvImportFinancialStatements;
    }

    public JMenuItem getCsvImportVatStatements() {
        return csvImportVatStatements;
    }

    public JMenuItem getDocuments() {
        return documents;
    }

    public JMenu getEbp() {
        return ebp;
    }

    public JMenu getEbpExport() {
        return ebpExport;
    }

    public JMenuItem getEbpExportAccounts() {
        return ebpExportAccounts;
    }

    public JMenuItem getEbpExportEntries() {
        return ebpExportEntries;
    }

    public JMenuItem getEbpExportEntryBooks() {
        return ebpExportEntryBooks;
    }

    public JMenu getEbpImport() {
        return ebpImport;
    }

    public JMenuItem getEbpImportAccounts() {
        return ebpImportAccounts;
    }

    public JMenuItem getEbpImportEntries() {
        return ebpImportEntries;
    }

    public JMenuItem getEbpImportEntryBooks() {
        return ebpImportEntryBooks;
    }

    public JMenu getEnter() {
        return enter;
    }

    public JMenuItem getEntries() {
        return entries;
    }

    public JMenuItem getEntryBooks() {
        return entryBooks;
    }

    public JMenu getFile() {
        return file;
    }

    public JMenuItem getFinancialPeriods() {
        return financialPeriods;
    }

    public JMenuItem getFinancialStatements() {
        return financialStatements;
    }

    public JMenuItem getFiscalControlExport() {
        return fiscalControlExport;
    }

    public JMenuItem getFiscalYears() {
        return fiscalYears;
    }

    public JMenuItem getFr() {
        return fr;
    }

    public JMenu getHelp() {
        return help;
    }

    public JMenu getI18n() {
        return i18n;
    }

    public JMenuItem getIdentity() {
        return identity;
    }

    public JMenuItem getLettering() {
        return lettering;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public JMenuItem getPreferences() {
        return preferences;
    }

    public JMenuItem getQuit() {
        return quit;
    }

    public JMenuItem getSearch() {
        return search;
    }

    public JMenuItem getSite() {
        return site;
    }

    public JMenu getStructure() {
        return structure;
    }

    public JMenuItem getUk() {
        return uk;
    }

    public JMenuItem getUnbalanced() {
        return unbalanced;
    }

    public JMenuItem getVatStatements() {
        return vatStatements;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCsv() {
        if (!allComponentsCreated) {
            return;
        }
        csv.add(csvImport);
        csv.add(csvExport);
    }

    protected void addChildrenToCsvExport() {
        if (!allComponentsCreated) {
            return;
        }
        csvExport.add(csvExportAll);
        csvExport.add(csvExportAccounts);
        csvExport.add(csvExportEntryBooks);
        csvExport.add(csvExportFinancialStatements);
        csvExport.add(csvExportVatStatements);
        csvExport.add(csvExportEntries);
    }

    protected void addChildrenToCsvImport() {
        if (!allComponentsCreated) {
            return;
        }
        csvImport.add(csvImportAll);
        csvImport.add(csvImportAccounts);
        csvImport.add(csvImportEntryBooks);
        csvImport.add(csvImportFinancialStatements);
        csvImport.add(csvImportVatStatements);
        csvImport.add(csvImportEntries);
    }

    protected void addChildrenToEbp() {
        if (!allComponentsCreated) {
            return;
        }
        ebp.add(ebpImport);
        ebp.add(ebpExport);
    }

    protected void addChildrenToEbpExport() {
        if (!allComponentsCreated) {
            return;
        }
        ebpExport.add(ebpExportAccounts);
        ebpExport.add(ebpExportEntryBooks);
        ebpExport.add(ebpExportEntries);
    }

    protected void addChildrenToEbpImport() {
        if (!allComponentsCreated) {
            return;
        }
        ebpImport.add(ebpImportAccounts);
        ebpImport.add(ebpImportEntryBooks);
        ebpImport.add(ebpImportEntries);
    }

    protected void addChildrenToEnter() {
        if (!allComponentsCreated) {
            return;
        }
        enter.add(entries);
        enter.add(unbalanced);
        enter.add(search);
        enter.add(lettering);
    }

    protected void addChildrenToFile() {
        if (!allComponentsCreated) {
            return;
        }
        file.add(csv);
        file.add(ebp);
        file.add(fiscalControlExport);
        file.add($JSeparator0);
        file.add(documents);
        file.add($JSeparator1);
        file.add(identity);
        file.add(preferences);
        file.add($JSeparator2);
        file.add(quit);
    }

    protected void addChildrenToHelp() {
        if (!allComponentsCreated) {
            return;
        }
        help.add(site);
        help.add(about);
        help.add(i18n);
    }

    protected void addChildrenToI18n() {
        if (!allComponentsCreated) {
            return;
        }
        i18n.add(fr);
        i18n.add(uk);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(contentTabbedPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMainView() {
        if (!allComponentsCreated) {
            return;
        }
        add(SwingUtil.boxComponentWithJxLayer(mainPanel));
        mainView.setJMenuBar($JMenuBar0);
    }

    protected void addChildrenToStructure() {
        if (!allComponentsCreated) {
            return;
        }
        structure.add(accounts);
        structure.add(entryBooks);
        structure.add(fiscalYears);
        structure.add(financialPeriods);
        structure.add(financialStatements);
        structure.add(vatStatements);
    }

    protected void createAbout() {
        $objectMap.put("about", about = new JMenuItem());
        
        about.setName("about");
        about.setText(t("lima.help.about"));
        about.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__about"));
    }

    protected void createAccounts() {
        $objectMap.put("accounts", accounts = new JMenuItem());
        
        accounts.setName("accounts");
        accounts.setText(t("lima.chart.accounts"));
        accounts.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__accounts"));
    }

    protected void createBetaLayer() {
        $objectMap.put("betaLayer", betaLayer = new BetaLayerUI());
    }

    protected void createContentTabbedPane() {
        $objectMap.put("contentTabbedPane", contentTabbedPane = new JTabbedPane());
        
        contentTabbedPane.setName("contentTabbedPane");
        contentTabbedPane.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__contentTabbedPane"));
    }

    protected void createCsv() {
        $objectMap.put("csv", csv = new JMenu());
        
        csv.setName("csv");
        csv.setText(t("lima.importExport.csv"));
    }

    protected void createCsvExport() {
        $objectMap.put("csvExport", csvExport = new JMenu());
        
        csvExport.setName("csvExport");
        csvExport.setText(t("lima.importExport.export"));
    }

    protected void createCsvExportAccounts() {
        $objectMap.put("csvExportAccounts", csvExportAccounts = new JMenuItem());
        
        csvExportAccounts.setName("csvExportAccounts");
        csvExportAccounts.setText(t("lima.chart.accounts"));
        csvExportAccounts.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvExportAccounts"));
    }

    protected void createCsvExportAll() {
        $objectMap.put("csvExportAll", csvExportAll = new JMenuItem());
        
        csvExportAll.setName("csvExportAll");
        csvExportAll.setText(t("lima.importExport.all"));
        csvExportAll.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvExportAll"));
    }

    protected void createCsvExportEntries() {
        $objectMap.put("csvExportEntries", csvExportEntries = new JMenuItem());
        
        csvExportEntries.setName("csvExportEntries");
        csvExportEntries.setText(t("lima.entries"));
        csvExportEntries.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvExportEntries"));
    }

    protected void createCsvExportEntryBooks() {
        $objectMap.put("csvExportEntryBooks", csvExportEntryBooks = new JMenuItem());
        
        csvExportEntryBooks.setName("csvExportEntryBooks");
        csvExportEntryBooks.setText(t("lima.entryBooks"));
        csvExportEntryBooks.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvExportEntryBooks"));
    }

    protected void createCsvExportFinancialStatements() {
        $objectMap.put("csvExportFinancialStatements", csvExportFinancialStatements = new JMenuItem());
        
        csvExportFinancialStatements.setName("csvExportFinancialStatements");
        csvExportFinancialStatements.setText(t("lima.financialStatements"));
        csvExportFinancialStatements.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvExportFinancialStatements"));
    }

    protected void createCsvExportVatStatements() {
        $objectMap.put("csvExportVatStatements", csvExportVatStatements = new JMenuItem());
        
        csvExportVatStatements.setName("csvExportVatStatements");
        csvExportVatStatements.setText(t("lima.vatStatements"));
        csvExportVatStatements.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvExportVatStatements"));
    }

    protected void createCsvImport() {
        $objectMap.put("csvImport", csvImport = new JMenu());
        
        csvImport.setName("csvImport");
        csvImport.setText(t("lima.importExport.import"));
    }

    protected void createCsvImportAccounts() {
        $objectMap.put("csvImportAccounts", csvImportAccounts = new JMenuItem());
        
        csvImportAccounts.setName("csvImportAccounts");
        csvImportAccounts.setText(t("lima.chart.accounts"));
        csvImportAccounts.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvImportAccounts"));
    }

    protected void createCsvImportAll() {
        $objectMap.put("csvImportAll", csvImportAll = new JMenuItem());
        
        csvImportAll.setName("csvImportAll");
        csvImportAll.setText(t("lima.importExport.all"));
        csvImportAll.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvImportAll"));
    }

    protected void createCsvImportEntries() {
        $objectMap.put("csvImportEntries", csvImportEntries = new JMenuItem());
        
        csvImportEntries.setName("csvImportEntries");
        csvImportEntries.setText(t("lima.entries"));
        csvImportEntries.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvImportEntries"));
    }

    protected void createCsvImportEntryBooks() {
        $objectMap.put("csvImportEntryBooks", csvImportEntryBooks = new JMenuItem());
        
        csvImportEntryBooks.setName("csvImportEntryBooks");
        csvImportEntryBooks.setText(t("lima.entryBooks"));
        csvImportEntryBooks.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvImportEntryBooks"));
    }

    protected void createCsvImportFinancialStatements() {
        $objectMap.put("csvImportFinancialStatements", csvImportFinancialStatements = new JMenuItem());
        
        csvImportFinancialStatements.setName("csvImportFinancialStatements");
        csvImportFinancialStatements.setText(t("lima.financialStatements"));
        csvImportFinancialStatements.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvImportFinancialStatements"));
    }

    protected void createCsvImportVatStatements() {
        $objectMap.put("csvImportVatStatements", csvImportVatStatements = new JMenuItem());
        
        csvImportVatStatements.setName("csvImportVatStatements");
        csvImportVatStatements.setText(t("lima.vatStatements"));
        csvImportVatStatements.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__csvImportVatStatements"));
    }

    protected void createDocuments() {
        $objectMap.put("documents", documents = new JMenuItem());
        
        documents.setName("documents");
        documents.setText(t("lima.documents"));
        documents.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__documents"));
    }

    protected void createEbp() {
        $objectMap.put("ebp", ebp = new JMenu());
        
        ebp.setName("ebp");
        ebp.setText(t("lima.importExport.ebp"));
    }

    protected void createEbpExport() {
        $objectMap.put("ebpExport", ebpExport = new JMenu());
        
        ebpExport.setName("ebpExport");
        ebpExport.setText(t("lima.importExport.export"));
    }

    protected void createEbpExportAccounts() {
        $objectMap.put("ebpExportAccounts", ebpExportAccounts = new JMenuItem());
        
        ebpExportAccounts.setName("ebpExportAccounts");
        ebpExportAccounts.setText(t("lima.chart.accounts"));
        ebpExportAccounts.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ebpExportAccounts"));
    }

    protected void createEbpExportEntries() {
        $objectMap.put("ebpExportEntries", ebpExportEntries = new JMenuItem());
        
        ebpExportEntries.setName("ebpExportEntries");
        ebpExportEntries.setText(t("lima.entries"));
        ebpExportEntries.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ebpExportEntries"));
    }

    protected void createEbpExportEntryBooks() {
        $objectMap.put("ebpExportEntryBooks", ebpExportEntryBooks = new JMenuItem());
        
        ebpExportEntryBooks.setName("ebpExportEntryBooks");
        ebpExportEntryBooks.setText(t("lima.entryBooks"));
        ebpExportEntryBooks.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ebpExportEntryBooks"));
    }

    protected void createEbpImport() {
        $objectMap.put("ebpImport", ebpImport = new JMenu());
        
        ebpImport.setName("ebpImport");
        ebpImport.setText(t("lima.importExport.import"));
    }

    protected void createEbpImportAccounts() {
        $objectMap.put("ebpImportAccounts", ebpImportAccounts = new JMenuItem());
        
        ebpImportAccounts.setName("ebpImportAccounts");
        ebpImportAccounts.setText(t("lima.chart.accounts"));
        ebpImportAccounts.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ebpImportAccounts"));
    }

    protected void createEbpImportEntries() {
        $objectMap.put("ebpImportEntries", ebpImportEntries = new JMenuItem());
        
        ebpImportEntries.setName("ebpImportEntries");
        ebpImportEntries.setText(t("lima.entries"));
        ebpImportEntries.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ebpImportEntries"));
    }

    protected void createEbpImportEntryBooks() {
        $objectMap.put("ebpImportEntryBooks", ebpImportEntryBooks = new JMenuItem());
        
        ebpImportEntryBooks.setName("ebpImportEntryBooks");
        ebpImportEntryBooks.setText(t("lima.entryBooks"));
        ebpImportEntryBooks.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ebpImportEntryBooks"));
    }

    protected void createEnter() {
        $objectMap.put("enter", enter = new JMenu());
        
        enter.setName("enter");
        enter.setText(t("lima.entries"));
        enter.setMnemonic(69);
    }

    protected void createEntries() {
        $objectMap.put("entries", entries = new JMenuItem());
        
        entries.setName("entries");
        entries.setText(t("lima.entries.enter"));
        entries.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__entries"));
    }

    protected void createEntryBooks() {
        $objectMap.put("entryBooks", entryBooks = new JMenuItem());
        
        entryBooks.setName("entryBooks");
        entryBooks.setText(t("lima.entryBooks"));
        entryBooks.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__entryBooks"));
    }

    protected void createFile() {
        $objectMap.put("file", file = new JMenu());
        
        file.setName("file");
        file.setText(t("lima.file"));
        file.setMnemonic(70);
    }

    protected void createFinancialPeriods() {
        $objectMap.put("financialPeriods", financialPeriods = new JMenuItem());
        
        financialPeriods.setName("financialPeriods");
        financialPeriods.setText(t("lima.financialPeriods"));
        financialPeriods.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__financialPeriods"));
    }

    protected void createFinancialStatements() {
        $objectMap.put("financialStatements", financialStatements = new JMenuItem());
        
        financialStatements.setName("financialStatements");
        financialStatements.setText(t("lima.financialStatements"));
        financialStatements.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__financialStatements"));
    }

    protected void createFiscalControlExport() {
        $objectMap.put("fiscalControlExport", fiscalControlExport = new JMenuItem());
        
        fiscalControlExport.setName("fiscalControlExport");
        fiscalControlExport.setText(t("lima.fiscalControlExport"));
        fiscalControlExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fiscalControlExport"));
    }

    protected void createFiscalYears() {
        $objectMap.put("fiscalYears", fiscalYears = new JMenuItem());
        
        fiscalYears.setName("fiscalYears");
        fiscalYears.setText(t("lima.fiscalYears"));
        fiscalYears.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fiscalYears"));
    }

    protected void createFr() {
        $objectMap.put("fr", fr = new JMenuItem());
        
        fr.setName("fr");
        fr.setText(t("lima.help.i18n.fr"));
        fr.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fr"));
    }

    protected void createHelp() {
        $objectMap.put("help", help = new JMenu());
        
        help.setName("help");
        help.setText(t("lima.help"));
        help.setMnemonic(72);
    }

    protected void createI18n() {
        $objectMap.put("i18n", i18n = new JMenu());
        
        i18n.setName("i18n");
        i18n.setText(t("lima.help.i18n"));
        i18n.setMnemonic(76);
    }

    protected void createIdentity() {
        $objectMap.put("identity", identity = new JMenuItem());
        
        identity.setName("identity");
        identity.setText(t("lima.identity"));
        identity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__identity"));
    }

    protected void createLettering() {
        $objectMap.put("lettering", lettering = new JMenuItem());
        
        lettering.setName("lettering");
        lettering.setText(t("lima.entries.lettering"));
        lettering.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lettering"));
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new JPanel());
        
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(new BorderLayout());
    }

    protected void createPreferences() {
        $objectMap.put("preferences", preferences = new JMenuItem());
        
        preferences.setName("preferences");
        preferences.setText(t("lima.preferences"));
        preferences.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__preferences"));
    }

    protected void createQuit() {
        $objectMap.put("quit", quit = new JMenuItem());
        
        quit.setName("quit");
        quit.setText(t("lima.quit"));
        quit.setMnemonic(81);
        quit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__quit"));
    }

    protected void createSearch() {
        $objectMap.put("search", search = new JMenuItem());
        
        search.setName("search");
        search.setText(t("lima.entries.search"));
        search.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__search"));
    }

    protected void createSite() {
        $objectMap.put("site", site = new JMenuItem());
        
        site.setName("site");
        site.setText(t("lima.help.site"));
        site.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__site"));
    }

    protected void createStructure() {
        $objectMap.put("structure", structure = new JMenu());
        
        structure.setName("structure");
        structure.setText(t("lima.structure"));
        structure.setMnemonic(83);
    }

    protected void createUk() {
        $objectMap.put("uk", uk = new JMenuItem());
        
        uk.setName("uk");
        uk.setText(t("lima.help.i18n.uk"));
        uk.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__uk"));
    }

    protected void createUnbalanced() {
        $objectMap.put("unbalanced", unbalanced = new JMenuItem());
        
        unbalanced.setName("unbalanced");
        unbalanced.setText(t("lima.entries.unbalanced"));
        unbalanced.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__unbalanced"));
    }

    protected void createVatStatements() {
        $objectMap.put("vatStatements", vatStatements = new JMenuItem());
        
        vatStatements.setName("vatStatements");
        vatStatements.setText(t("lima.vatStatements"));
        vatStatements.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__vatStatements"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainView();
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add(file);
        $JMenuBar0.add(structure);
        $JMenuBar0.add(enter);
        $JMenuBar0.add(help);
        addChildrenToFile();
        addChildrenToCsv();
        addChildrenToCsvImport();
        addChildrenToCsvExport();
        addChildrenToEbp();
        addChildrenToEbpImport();
        addChildrenToEbpExport();
        addChildrenToStructure();
        addChildrenToEnter();
        addChildrenToHelp();
        addChildrenToI18n();
        addChildrenToMainPanel();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 43 property setters
        setExtendedState(this.MAXIMIZED_BOTH);
        setMinimumSize(new Dimension(800 ,500));
        setIconImage(SwingUtil.createImageIcon("puzzle_icon.png").getImage());
        csvImport.setIcon(SwingUtil.createActionIcon("import"));
        csvImportAccounts.setIcon(SwingUtil.createActionIcon("accounts"));
        csvImportEntryBooks.setIcon(SwingUtil.createActionIcon("entryBooks"));
        csvImportFinancialStatements.setIcon(SwingUtil.createActionIcon("financialStatements"));
        csvImportVatStatements.setIcon(SwingUtil.createActionIcon("vatStatements"));
        csvImportEntries.setIcon(SwingUtil.createActionIcon("entries"));
        csvExport.setIcon(SwingUtil.createActionIcon("export"));
        csvExportAccounts.setIcon(SwingUtil.createActionIcon("accounts"));
        csvExportEntryBooks.setIcon(SwingUtil.createActionIcon("entryBooks"));
        csvExportFinancialStatements.setIcon(SwingUtil.createActionIcon("financialStatements"));
        csvExportVatStatements.setIcon(SwingUtil.createActionIcon("vatStatements"));
        csvExportEntries.setIcon(SwingUtil.createActionIcon("entries"));
        ebpImport.setIcon(SwingUtil.createActionIcon("import"));
        ebpImportAccounts.setIcon(SwingUtil.createActionIcon("accounts"));
        ebpImportEntryBooks.setIcon(SwingUtil.createActionIcon("entryBooks"));
        ebpImportEntries.setIcon(SwingUtil.createActionIcon("entries"));
        ebpExport.setIcon(SwingUtil.createActionIcon("export"));
        ebpExportAccounts.setIcon(SwingUtil.createActionIcon("accounts"));
        ebpExportEntryBooks.setIcon(SwingUtil.createActionIcon("entryBooks"));
        ebpExportEntries.setIcon(SwingUtil.createActionIcon("entries"));
        fiscalControlExport.setIcon(SwingUtil.createActionIcon("fiscalControlExport"));
        identity.setIcon(SwingUtil.createActionIcon("identity"));
        preferences.setIcon(SwingUtil.createActionIcon("config"));
        quit.setIcon(SwingUtil.createActionIcon("quit"));
        accounts.setIcon(SwingUtil.createActionIcon("accounts"));
        entryBooks.setIcon(SwingUtil.createActionIcon("entryBooks"));
        fiscalYears.setIcon(SwingUtil.createActionIcon("fiscalPeriods"));
        financialPeriods.setIcon(SwingUtil.createActionIcon("financialPeriods"));
        financialStatements.setIcon(SwingUtil.createActionIcon("financialStatements"));
        vatStatements.setIcon(SwingUtil.createActionIcon("vatStatements"));
        entries.setIcon(SwingUtil.createActionIcon("entries"));
        unbalanced.setIcon(SwingUtil.createActionIcon("entries-unbalanced"));
        search.setIcon(SwingUtil.createActionIcon("entries-search"));
        lettering.setIcon(SwingUtil.createActionIcon("lettering"));
        site.setIcon(SwingUtil.createActionIcon("site"));
        about.setIcon(SwingUtil.createActionIcon("about"));
        i18n.setIcon(SwingUtil.createActionIcon("translate"));
        fr.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        uk.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        // late initializer
        mainView.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainView", mainView);
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        createFile();
        createCsv();
        createCsvImport();
        createCsvImportAll();
        createCsvImportAccounts();
        createCsvImportEntryBooks();
        createCsvImportFinancialStatements();
        createCsvImportVatStatements();
        createCsvImportEntries();
        createCsvExport();
        createCsvExportAll();
        createCsvExportAccounts();
        createCsvExportEntryBooks();
        createCsvExportFinancialStatements();
        createCsvExportVatStatements();
        createCsvExportEntries();
        createEbp();
        createEbpImport();
        createEbpImportAccounts();
        createEbpImportEntryBooks();
        createEbpImportEntries();
        createEbpExport();
        createEbpExportAccounts();
        createEbpExportEntryBooks();
        createEbpExportEntries();
        createFiscalControlExport();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createDocuments();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createIdentity();
        createPreferences();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createQuit();
        createStructure();
        createAccounts();
        createEntryBooks();
        createFiscalYears();
        createFinancialPeriods();
        createFinancialStatements();
        createVatStatements();
        createEnter();
        createEntries();
        createUnbalanced();
        createSearch();
        createLettering();
        createHelp();
        createSite();
        createAbout();
        createI18n();
        createFr();
        createUk();
        createBetaLayer();
        createMainPanel();
        createContentTabbedPane();
        // inline creation of mainView
        setName("mainView");
        setDefaultCloseOperation(0);
        setTitle(t("lima.title"));
        SwingUtil.setComponentHeight(mainView,768);
        SwingUtil.setComponentWidth(mainView,1024);
        setResizable(true);
        mainView.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainView"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    fr.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    uk.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
    }

}