package org.chorem.lima.ui.Filter.BigDecimalCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.ListSelectionModel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.AbstractBigDecimalCondition;
import org.chorem.lima.ui.common.LabelListCellRenderer;

public class BigDecimalConditionView extends JInternalFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz28bVRCeuHESpw0pjRq10CJTKuRIaB0q9ZSqtElqpZX7QzFCVX3hrXdqv+p53+O92XrTqog/gT8B7lyQuHFCHDhz4IL4FxDiwBUxb3dtN7VLotqHlfVm5puZb+ab7/6EsrPw/hORpoFNYpJ9DO7cfPjwfvgEO7SLrmOlIW0h/82VoNSGk9Ho3RF80G768HoRXt/RfaNjjF+K3mrCsqMDha6HSAQXD0d0nKu3Ruat1CR2iDoqahrqN3//Vfo6+urbEkBquLp5bqV6VNS4k/kmlGREcIYzPRV1JeIul2Fl3OV6V/zbjhLO3RN9/AK+hMUmLBhhGYzg0vFbzjCy+NQQnAtldxc7si/Ujo4jSVLHDcsZCG5p2w06PW2xHyh2CBIZNKQitMH2ZNC0t88kDozJki0QLPZEHCm0BHszI+/lUGPwVW3Q8iN3HuptnRKc9YSlgRswf8Gd4bt3r4yiTo+7v8XAmmv78NC88mjMbMG9pB+izR0LHAvvHvLnzQnGmzMe7VwbyjbhZ2a8Pbls+2zK1+zcK2vmATPrv+trv/34xw+N4W6tcO6zU11fkgbP3FjPDEmfejVfrISkqt8VZqsNFYeKdZXp5sKUwlqFmYvjfG/78MCHB3vC9RiivPj7Tz+vf/7rCSg1YFlpETWE978NFepZZkGrKDWf3MgqOjVY4u9pXxvBirH4GK3FqCWfMVXnn8c4qO5y4tjxgGtXNjc/qn68ubnxImVaLkyhZVRbWPnln7XW9zeG1Mxxqedf6z6mp/wIFmSsZIyZ8ApNTRXaSeMwifRYO9PUBP8jJ1Os6jvZ970JRk4QlPs6QsXqyJnAxyJRNNzbu95Wuxk6skzwNJXczwUQPBUqQVfb2HhBcCofL0a3CfsE688LCQZdpMK/5v2W+IpEaL02L2bZmyJE1ZSOdlCp/cJY87Pw5V/KSPb/LsOk9I5qlYe/oMSBTvhuvXUtEiSqoeQu4u71Cfg5/10+BmJFJKQfaJPwTTtzLZ9qVRBfzzAhfA3w2jGA50MUsbdefXOMfLIzglQykE8PDM4ItBJnd+wBs4M2a23rzcGWivtyMCPOKp+KQTa/bd4LPWtZFQ+3jw5p1v4Shw2+a7PiLDJOS3aP6us/nTWJ0QAJAAA=";
    private static final Log log = LogFactory.getLog(BigDecimalConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected BigDecimalConditionView bigDecimalConditionFrame = this;
    protected NumberEditor bigDecimalEditor;
    protected BigDecimalConditionHandler handler;
    protected JComboBox operandComboBox;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BigDecimalConditionView(String param0) {
        super(param0);
        $initialize();
    }

    public BigDecimalConditionView(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigDecimalConditionView() {
        $initialize();
    }

    public BigDecimalConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigDecimalConditionView(String param0, boolean param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BigDecimalConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigDecimalConditionView(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BigDecimalConditionView(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigDecimalConditionView(String param0, boolean param1, boolean param2, boolean param3, boolean param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public BigDecimalConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4, boolean param5) {
        super(param1 ,param2 ,param3 ,param4 ,param5);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigDecimalConditionView(String param0, boolean param1, boolean param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public BigDecimalConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInternalFrameClosed__on__bigDecimalConditionFrame(InternalFrameEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doItemStateChanged__on__operandComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.operandSelected(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor getBigDecimalEditor() {
        return bigDecimalEditor;
    }

    public BigDecimalConditionHandler getHandler() {
        return handler;
    }

    public JComboBox getOperandComboBox() {
        return operandComboBox;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(BigDecimalConditionHandler handler) {
        BigDecimalConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBigDecimalConditionFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(operandComboBox);
        add(bigDecimalEditor);
    }

    protected void createBigDecimalEditor() {
        $objectMap.put("bigDecimalEditor", bigDecimalEditor = new NumberEditor(this));
        
        bigDecimalEditor.setName("bigDecimalEditor");
        bigDecimalEditor.setAutoPopup(false);
        bigDecimalEditor.setNumberPattern("([1-9]\\d*|0)(\\.\\d*)?");
        bigDecimalEditor.setProperty("value");
        bigDecimalEditor.setShowPopupButton(false);
        bigDecimalEditor.setShowReset(false);
        bigDecimalEditor.setUseFloat(true);
        bigDecimalEditor.setUseSign(false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new BigDecimalConditionHandler(this));
    }

    protected void createOperandComboBox() {
        $objectMap.put("operandComboBox", operandComboBox = new JComboBox());
        
        operandComboBox.setName("operandComboBox");
        operandComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__operandComboBox"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBigDecimalConditionFrame();
        
        // apply 8 property setters
        bigDecimalEditor.setBean(handler);
        bigDecimalEditor.setModel(handler.getValue());
        bigDecimalEditor.setModelType(BigDecimal.class);
        setPreferredSize(new Dimension(200, 100));
        operandComboBox.setModel(new DefaultComboBoxModel(AbstractBigDecimalCondition.Operand.values()));
        operandComboBox.setSelectedItem(handler.getOperand());
        operandComboBox.setRenderer(new LabelListCellRenderer());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("bigDecimalConditionFrame", bigDecimalConditionFrame);
        createHandler();
        createOperandComboBox();
        createBigDecimalEditor();
        // inline creation of bigDecimalConditionFrame
        setName("bigDecimalConditionFrame");
        setVisible(true);
        setClosable(true);
        setDefaultCloseOperation(2);
        bigDecimalConditionFrame.getContentPane().setLayout(new FlowLayout());
        bigDecimalConditionFrame.addInternalFrameListener(JAXXUtil.getEventListener(InternalFrameListener.class, "internalFrameClosed", this, "doInternalFrameClosed__on__bigDecimalConditionFrame"));
        
        bigDecimalConditionFrame.pack();
        $completeSetup();
    }

}