/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementchart;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.api.FinancialStatementService;
import org.chorem.lima.business.exceptions.AlreadyExistFinancialStatement;
import org.chorem.lima.business.exceptions.NotAllowedLabelException;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartViewHandler;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;

public class FinancialStatementChartTreeTableModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(FinancialStatementChartViewHandler.class);
    protected final FinancialStatementService financialStatementService = (FinancialStatementService)LimaServiceFactory.getService(FinancialStatementService.class);
    protected ErrorHelper errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());

    public FinancialStatementChartTreeTableModel() {
        super((Object)new FinancialStatementImpl());
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int column) {
        String res = null;
        switch (column) {
            case 0: {
                res = I18n.t((String)"lima.table.label", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n.t((String)"lima.table.debitCredit", (Object[])new Object[0]);
                break;
            }
            case 2: {
                res = I18n.t((String)"lima.table.debit", (Object[])new Object[0]);
                break;
            }
            case 3: {
                res = I18n.t((String)"lima.table.credit", (Object[])new Object[0]);
                break;
            }
            case 4: {
                res = I18n.t((String)"lima.table.provisionDeprecation", (Object[])new Object[0]);
            }
        }
        return res;
    }

    public int getChildCount(Object node) {
        int result = 0;
        if (node == this.getRoot()) {
            result = this.financialStatementService.getRootFinancialStatements().size();
        } else {
            FinancialStatement parentFinancialStatementHeader = (FinancialStatement)node;
            result = parentFinancialStatementHeader.getSubFinancialStatements().size();
        }
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result = null;
        if (parent == this.getRoot()) {
            List financialStatements = this.financialStatementService.getRootFinancialStatements();
            result = financialStatements.get(index);
        } else {
            FinancialStatement parentFinancialStatement = (FinancialStatement)parent;
            ArrayList financialStatements = Lists.newArrayList((Iterable)parentFinancialStatement.getSubFinancialStatements());
            result = financialStatements.get(index);
        }
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int result = 0;
        if (parent == this.getRoot()) {
            List financialStatements = this.financialStatementService.getRootFinancialStatements();
            result = financialStatements.indexOf(child);
        } else {
            FinancialStatement parentFinancialStatement = (FinancialStatement)parent;
            ArrayList financialStatements = Lists.newArrayList((Iterable)parentFinancialStatement.getSubFinancialStatements());
            result = financialStatements.indexOf(child);
        }
        return result;
    }

    public Object getValueAt(Object node, int column) {
        String result = "n/a";
        FinancialStatement financialStatement = (FinancialStatement)node;
        switch (column) {
            case 0: {
                result = financialStatement.getLabel();
                break;
            }
            case 1: {
                result = financialStatement.getAccounts();
                break;
            }
            case 2: {
                result = financialStatement.getDebitAccounts();
                break;
            }
            case 3: {
                result = financialStatement.getCreditAccounts();
                break;
            }
            case 4: {
                result = financialStatement.getProvisionDeprecationAccounts();
            }
        }
        return result;
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void refreshTree() {
        this.modelSupport.fireNewRoot();
    }

    public void addFinancialStatement(TreePath path, FinancialStatement financialStatement) {
        FinancialStatement parentFinancialStatementHeader = (FinancialStatement)path.getLastPathComponent();
        if (parentFinancialStatementHeader == this.getRoot()) {
            parentFinancialStatementHeader = null;
        }
        try {
            this.financialStatementService.createFinancialStatement(parentFinancialStatementHeader, financialStatement);
        }
        catch (AlreadyExistFinancialStatement alreadyExistFinancialStatement) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.financialStatement.error.alreadyExistFinancialStatement", (Object[])new Object[]{alreadyExistFinancialStatement.getFinancialStatementLabel(), alreadyExistFinancialStatement.getMasterLabel()}));
        }
        catch (NotAllowedLabelException notAllowedLabel) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.error.notAllowedLabel", (Object[])new Object[]{notAllowedLabel.getLabel()}));
        }
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void updateFinancialStatement(TreePath path, FinancialStatement financialStatement) {
        this.financialStatementService.updateFinancialStatement(financialStatement);
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void removeFinancialStatementObject(TreePath path, FinancialStatement financialStatement) {
        int index = this.getIndexOfChild(path.getParentPath().getLastPathComponent(), financialStatement);
        this.financialStatementService.removeFinancialStatement(financialStatement);
        this.modelSupport.fireChildRemoved(path.getParentPath(), index, (Object)financialStatement);
    }
}

