/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.common;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.AccountTableCellRenderer;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateLimaTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.DefaultLimaTableCellRenderer;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.chorem.lima.ui.celleditor.EntryBookTableCellRender;
import org.chorem.lima.ui.celleditor.StringTableCellEditor;
import org.chorem.lima.ui.common.AbstractLimaTableModel;
import org.chorem.lima.ui.common.Column;
import org.jdesktop.swingx.JXTable;

public abstract class AbstractLimaTable<H>
extends JXTable {
    private static final long serialVersionUID = -4195941654485008887L;
    protected H handler;

    public AbstractLimaTable(H handler) {
        this.handler = handler;
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setGridColor(new Color(232, 232, 246));
        this.initNavigation();
        this.setDefaultRenderer(Object.class, new DefaultLimaTableCellRenderer());
        this.setDefaultRenderer(Date.class, new DateLimaTableCellRenderer());
        this.setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        this.setDefaultRenderer(Account.class, new AccountTableCellRenderer());
        this.setDefaultRenderer(EntryBook.class, new EntryBookTableCellRender());
        this.setDefaultEditor(Date.class, new DateTableCellEditor());
        this.setDefaultEditor(BigDecimal.class, new BigDecimalTableCellEditor());
        this.setDefaultEditor(Account.class, new AccountTableCellEditor());
        this.setDefaultEditor(EntryBook.class, new EntryBookTableCellEditor());
        this.setDefaultEditor(String.class, new StringTableCellEditor());
        this.setShowHorizontalLines(false);
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        if (model instanceof AbstractLimaTableModel) {
            for (int columnIndex = 0; columnIndex < this.getColumnModel().getColumnCount(); ++columnIndex) {
                Column column = ((AbstractLimaTableModel)model).getColumn(columnIndex);
                TableCellEditor cellEditor = column.getCellEditor();
                if (cellEditor == null) continue;
                this.getColumnModel().getColumn(columnIndex).setCellEditor(cellEditor);
            }
        }
    }

    protected void initNavigation() {
    }

    public H getHandler() {
        return this.handler;
    }

    public void exit() {
        if (this.isEditing()) {
            TableCellEditor editor = this.getCellEditor();
            editor.stopCellEditing();
        }
    }
}

