/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;

public class StringTableCellEditor
extends DefaultCellEditor {
    private static final Log log = LogFactory.getLog(BigDecimalTableCellEditor.class);

    public StringTableCellEditor() {
        super(new JTextField());
        this.setClickCountToStart(1);
        Border border = BorderFactory.createLineBorder(new Color(123, 165, 205), 2);
        this.getComponent().setBorder(border);
        this.getComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                StringTableCellEditor.this.runEdition();
            }

            @Override
            public void focusLost(FocusEvent event) {
            }
        });
        this.getComponent().addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                StringTableCellEditor.this.runEdition();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.getComponent().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StringTableCellEditor.this.runEdition();
            }
        });
        for (InputMap inputMap = this.getComponent().getInputMap(0); inputMap != null; inputMap = inputMap.getParent()) {
            inputMap.remove(KeyStroke.getKeyStroke(127, 128));
        }
    }

    @Override
    public JTextField getComponent() {
        return (JTextField)super.getComponent();
    }

    public void runEdition() {
        LimaSwingConfig config = LimaSwingConfig.getInstance();
        if (config.isSelectAllEditingCell()) {
            this.getComponent().selectAll();
        } else {
            int textFieldSize = this.getComponent().getText().length();
            this.getComponent().select(textFieldSize, textFieldSize);
        }
    }

    @Override
    public Object getCellEditorValue() {
        String stringValue = super.getCellEditorValue().toString();
        return stringValue;
    }
}

