/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.ui.celleditor.TableCellErrorDetector;
import org.chorem.lima.ui.common.TableModelWithGroup;

public class DefaultLimaTableCellRenderer
implements TableCellRenderer {
    private String text = null;
    protected boolean mandatory = false;
    protected TableCellErrorDetector errorDetector = new TableCellErrorDetector();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        LimaSwingConfig.Option foreGroundOption;
        LimaSwingConfig.Option backgroundOption;
        JLabel myCell = new JLabel();
        myCell.setOpaque(true);
        myCell.setName("Table.entryCellRenderer");
        int line = row;
        if (table.getModel() instanceof TableModelWithGroup) {
            TableModelWithGroup model = (TableModelWithGroup)table.getModel();
            line = model.indexInGroup(row);
        }
        LimaSwingConfig limaSwingConfig = LimaSwingConfig.getInstance();
        Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        if (hasFocus) {
            Color color = limaSwingConfig.getOptionAsColor(LimaSwingConfig.Option.COLOR_SELECTION_FOCUS.getKey());
            border = BorderFactory.createLineBorder(color, 2);
        } else if (line == 0 && table.getModel() instanceof TableModelWithGroup) {
            border = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK);
        }
        myCell.setBorder(border);
        if ((line & 1) == 1 || line % 2 == 1) {
            if (isSelected) {
                if (this.errorDetector.isError(table, value, row, column)) {
                    backgroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_BACKGROUND;
                    foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_FOREGROUND;
                } else if (this.isMandatory(table, value, row, column)) {
                    backgroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_BACKGROUND;
                    foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_FOREGROUND;
                } else {
                    backgroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_BACKGROUND;
                    foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_FOREGROUND;
                }
            } else if (this.errorDetector.isError(table, value, row, column)) {
                backgroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_ERROR_BACKGROUND;
                foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_ERROR_FOREGROUND;
            } else if (this.isMandatory(table, value, row, column)) {
                backgroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_MANDATORY_BACKGROUND;
                foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_MANDATORY_FOREGROUND;
            } else {
                backgroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_BACKGROUND;
                foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_PAIR_FOREGROUND;
            }
        } else if (isSelected) {
            if (this.errorDetector.isError(table, value, row, column)) {
                backgroundOption = LimaSwingConfig.Option.TABLE_CELL_SELECTED_ERROR_BACKGROUND;
                foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_SELECTED_ERROR_FOREGROUND;
            } else if (this.isMandatory(table, value, row, column)) {
                backgroundOption = LimaSwingConfig.Option.TABLE_CELL_SELECTED_MANDATORY_BACKGROUND;
                foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_SELECTED_MANDATORY_FOREGROUND;
            } else {
                backgroundOption = LimaSwingConfig.Option.TABLE_CELL_SELECTED_BACKGROUND;
                foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_SELECTED_FOREGROUND;
            }
        } else if (this.errorDetector.isError(table, value, row, column)) {
            backgroundOption = LimaSwingConfig.Option.TABLE_CELL_ERROR_BACKGROUND;
            foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_ERROR_FOREGROUND;
        } else if (this.isMandatory(table, value, row, column)) {
            backgroundOption = LimaSwingConfig.Option.TABLE_CELL_MANDATORY_BACKGROUND;
            foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_MANDATORY_FOREGROUND;
        } else {
            backgroundOption = LimaSwingConfig.Option.TABLE_CELL_BACKGROUND;
            foreGroundOption = LimaSwingConfig.Option.TABLE_CELL_FOREGROUND;
        }
        myCell.setBackground(limaSwingConfig.getOptionAsColor(backgroundOption.getKey()));
        myCell.setForeground(limaSwingConfig.getOptionAsColor(foreGroundOption.getKey()));
        this.setValue(value);
        myCell.setText(this.text);
        return myCell;
    }

    protected void setValue(Object value) {
        this.text = value == null ? "" : value.toString();
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    protected boolean isMandatory(JTable table, Object value, int row, int column) {
        return this.mandatory && table.isCellEditable(row, column) && (value == null || value instanceof String && ((String)value).isEmpty());
    }

    public TableCellErrorDetector getError() {
        return this.errorDetector;
    }

    public void setErrorDetector(TableCellErrorDetector errorDetector) {
        this.errorDetector = errorDetector;
    }
}

