package org.chorem.lima.ui.financialtransactionunbalanced;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionDefaultTable;
import static org.nuiton.i18n.I18n.t;

public class FinancialTransactionUnbalancedView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BALANCE = "balance";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENTRY_ENABLED = "addEntry.enabled";
    public static final String BINDING_BALANCE_BUTTON_ENABLED = "balanceButton.enabled";
    public static final String BINDING_REMOVE_ENTRY_ENABLED = "removeEntry.enabled";
    public static final String BINDING_REMOVE_TRANSACTION_ENABLED = "removeTransaction.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXz28bRRSeuDiJ4yY0iZM0IkBKciiHrEukXkgFJQGTBqdUsVu19YXx7jieajyzzM7Wa0Ug/gT+BHqGCxI3TogDZw5cEP8CQhy4It7srr1eexIvUurDyp55P7735u33jb/7E+U9iW48w0FgSZ8r2iHW0QePH3/afEZs9SHxbEldJSSKPlM5lGugojNY9xTaalS1ezl2Lx+Ijis44UPee1U056keI16bEKXQ62kP2/PKtcH2XuD6sh91AMoU9Zu//8p97Xz1IodQ4AK6EpSyOckrqeSVKspRR6ElyPQclxnmpwBDUn4KeOf12gHDnncfd8jn6Es0U0XTLpYQTKG3spccxgj9A1eh2e2jB5gTdkuhupCnlt0WknQsRjvY8qnVohxzm2KmJOYethUV3OdNDNhs4liV/nY92X442H5ESdd1w1zTCs20MXcYkQo1Xkaiwyh6km/BI4yEhsfCIUyhN3QHA8vrQkOtKvVULWWQeBYjT+KciK5Ci9rN0odh7QvBCOZDNcUI9M/S0LICwyaGUkvDOY/qsLyPpbYqDIwXoQ3iORkqTKHllNu+r5Tg2nxt4DWLHecjrmRP/95I7xWjiOdtl7b7QLZrBAYIw3TcGmnPuEU6xnxceAItQ5J39N5W2m6xRT0bswdEUuFUcVMf1FIKSbiYdlofdoJZb4p9EcSnfNswXLY2aYoAxugcv+TsSqbYCq2kMPXXJ9e8a6h5RpKWBG4xtG1++6hmS8GYfinhUNZSaZOt9AjdbF34etRxk5G4PU8v+91Lgic93MqAR6GHLwWKhnDbBeJ9LUW8QOlWQukJ5041UF76sKzQ9ca4CpzAVsT/10f4XwcMd/9dXf7txz9+qPRJfwFyrxhNhzQLyNiVwgU2pDr1qxHj+4qy8jF29xqoEHFQKGgbBmC1eBvAQb6Io7S7dYi9NoTIz/z+08+rn/16BeUqaI4J7FSwtr+HCqqth08wJ3Dfvxsiutqdhec1jU2hQgusVXRE+RZmHgmg/A1D+QMMzcIv/yzXvr/bb8EUQFo/1zxpQ/4pmqacUU5C5YtFzah0RdcjviMS8TLJGUqo142n8SB8fjxW6BUwJVxXCYK7eEa9WsL5N9/+QqG5aLru2ZqPN2C8iSI7g/HcUcN0XdRJ69StkwC0+M1wmEF8JZytFXGxNWQf+BrSJ2Gf9LdjZBKByy2gAHKxoyH1RtGupND2VcWEcSA5lwvtatxbI7p1Uy/JeQiHhe9/gVw4u0G9/YhGxhH2VX4UXCkFLjYy4Uqr5SRkOWg106JXEXCDWD0zCdIoxCXgUeHpAdW2Oz2CpXHMxtQ2A5h00WupoqN4T4i+68zCVdQhUt/w3j3jpLtpVuKO4Ckd1jexk9gTem+CbdTkDMjTpxirrvkFiDctIEapbF+ZYPQjTMqsSVSK7iGhp21IkNvdNUXLIpIZMk0z3BMwV2jhjgO0vdmk3IHLwntjKaf0cy5DxPnUxVmbvTAHu5YhWL6jrwYXBClPDKKXv70gwp0MMEb+DEyI9h/qnh1Ehg4AAA==";
    private static final Log log = LogFactory.getLog(FinancialTransactionUnbalancedView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addEntry;
    protected Boolean balance;
    protected JButton balanceButton;
    protected FinancialTransactionUnbalancedTable financialTransactionUnbalancedTable;
    protected FinancialTransactionUnbalancedTableModel financialTransactionUnbalancedTableModel;
    protected JComboBox fiscalPeriodComboBox;
    protected FiscalPeriodComboBoxModel fiscalPeriodComboBoxModel;
    protected JLabel fiscalPeriodLabel;
    protected FinancialTransactionUnbalancedViewHandler handler;
    protected JButton refresh;
    protected JButton removeEntry;
    protected JButton removeTransaction;
    protected Boolean selectedRow;
    protected ListSelectionModel selectionModel;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialTransactionUnbalancedView $JPanel0 = this;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            getHandler().init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionUnbalancedView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialTransactionUnbalancedView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionUnbalancedView() {
        $initialize();
    }

    public FinancialTransactionUnbalancedView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionUnbalancedView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionUnbalancedView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionUnbalancedView(boolean param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionUnbalancedView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addEntry(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addEntry();
    }

    public void doActionPerformed__on__balanceButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.balanceTransaction();
    }

    public void doActionPerformed__on__fiscalPeriodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialTransactionUnbalancedTableModel().setFiscalPeriod( (FiscalPeriod) fiscalPeriodComboBox.getSelectedItem()); getHandler().refresh();
    }

    public void doActionPerformed__on__refresh(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().refresh();
    }

    public void doActionPerformed__on__removeEntry(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteSelectedEntry();
    }

    public void doActionPerformed__on__removeTransaction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteSelectedTransaction();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectionChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddEntry() {
        return addEntry;
    }

    public Boolean getBalance() {
        return balance;
    }

    public JButton getBalanceButton() {
        return balanceButton;
    }

    public FinancialTransactionUnbalancedTable getFinancialTransactionUnbalancedTable() {
        return financialTransactionUnbalancedTable;
    }

    public FinancialTransactionUnbalancedTableModel getFinancialTransactionUnbalancedTableModel() {
        return financialTransactionUnbalancedTableModel;
    }

    public JComboBox getFiscalPeriodComboBox() {
        return fiscalPeriodComboBox;
    }

    public FiscalPeriodComboBoxModel getFiscalPeriodComboBoxModel() {
        return fiscalPeriodComboBoxModel;
    }

    public JLabel getFiscalPeriodLabel() {
        return fiscalPeriodLabel;
    }

    public FinancialTransactionUnbalancedViewHandler getHandler() {
        return handler;
    }

    public JButton getRefresh() {
        return refresh;
    }

    public JButton getRemoveEntry() {
        return removeEntry;
    }

    public JButton getRemoveTransaction() {
        return removeTransaction;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean isBalance() {
        return balance !=null && balance;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBalance(Boolean balance) {
        Boolean oldValue = this.balance;
        this.balance = balance;
        firePropertyChange(PROPERTY_BALANCE, oldValue, balance);
    }

    public void setHandler(FinancialTransactionUnbalancedViewHandler handler) {
        FinancialTransactionUnbalancedViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(removeTransaction);
        toolbar.add(addEntry);
        toolbar.add(removeEntry);
        toolbar.add($JToolBar$Separator0);
        toolbar.add(balanceButton);
        toolbar.add($JToolBar$Separator1);
        toolbar.add(fiscalPeriodLabel);
        toolbar.add(fiscalPeriodComboBox);
        toolbar.add($JToolBar$Separator2);
        toolbar.add(refresh);
    }

    protected void createAddEntry() {
        $objectMap.put("addEntry", addEntry = new JButton());
        
        addEntry.setName("addEntry");
        addEntry.setToolTipText(t("lima.entries.addEntry"));
        addEntry.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addEntry"));
    }

    protected void createBalance() {
        $objectMap.put("balance", balance = true);
    }

    protected void createBalanceButton() {
        $objectMap.put("balanceButton", balanceButton = new JButton());
        
        balanceButton.setName("balanceButton");
        balanceButton.setToolTipText(t("lima.entries.balance"));
        balanceButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__balanceButton"));
    }

    protected void createFinancialTransactionUnbalancedTable() {
        $objectMap.put("financialTransactionUnbalancedTable", financialTransactionUnbalancedTable = new FinancialTransactionUnbalancedTable(handler));
        
        financialTransactionUnbalancedTable.setName("financialTransactionUnbalancedTable");
        financialTransactionUnbalancedTable.setRowHeight(22);
    }

    protected void createFinancialTransactionUnbalancedTableModel() {
        $objectMap.put("financialTransactionUnbalancedTableModel", financialTransactionUnbalancedTableModel = new FinancialTransactionUnbalancedTableModel());
    }

    protected void createFiscalPeriodComboBox() {
        $objectMap.put("fiscalPeriodComboBox", fiscalPeriodComboBox = new JComboBox());
        
        fiscalPeriodComboBox.setName("fiscalPeriodComboBox");
        fiscalPeriodComboBox.setToolTipText(t("lima.entries.fiscalYear"));
        fiscalPeriodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fiscalPeriodComboBox"));
    }

    protected void createFiscalPeriodComboBoxModel() {
        $objectMap.put("fiscalPeriodComboBoxModel", fiscalPeriodComboBoxModel = new FiscalPeriodComboBoxModel());
    }

    protected void createFiscalPeriodLabel() {
        $objectMap.put("fiscalPeriodLabel", fiscalPeriodLabel = new JLabel());
        
        fiscalPeriodLabel.setName("fiscalPeriodLabel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionUnbalancedViewHandler(this));
    }

    protected void createRefresh() {
        $objectMap.put("refresh", refresh = new JButton());
        
        refresh.setName("refresh");
        refresh.setToolTipText(t("lima.refresh.shortcut"));
        refresh.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__refresh"));
    }

    protected void createRemoveEntry() {
        $objectMap.put("removeEntry", removeEntry = new JButton());
        
        removeEntry.setName("removeEntry");
        removeEntry.setToolTipText(t("lima.entries.remove.entry"));
        removeEntry.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeEntry"));
    }

    protected void createRemoveTransaction() {
        $objectMap.put("removeTransaction", removeTransaction = new JButton());
        
        removeTransaction.setName("removeTransaction");
        removeTransaction.setToolTipText(t("lima.entries.remove.transaction"));
        removeTransaction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeTransaction"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.PAGE_START);
        add($JScrollPane0, BorderLayout.CENTER);
        addChildrenToToolbar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionUnbalancedTable);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        selectionModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        fiscalPeriodComboBox.setModel(fiscalPeriodComboBoxModel);
        financialTransactionUnbalancedTable.setModel(getFinancialTransactionUnbalancedTableModel());
        financialTransactionUnbalancedTable.setSelectionModel(selectionModel);
        removeTransaction.setIcon(SwingUtil.createActionIcon("delete-financial-transaction"));
        addEntry.setIcon(SwingUtil.createActionIcon("add-entry"));
        removeEntry.setIcon(SwingUtil.createActionIcon("delete-entry"));
        balanceButton.setIcon(SwingUtil.createActionIcon("balance"));
        fiscalPeriodLabel.setLabelFor(fiscalPeriodComboBox);
        fiscalPeriodLabel.setIcon(SwingUtil.createActionIcon("choose-fiscal-year"));
        fiscalPeriodComboBox.setRenderer(new org.chorem.lima.ui.common.FiscalPeriodListRenderer());
        refresh.setIcon(SwingUtil.createActionIcon("refresh"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSelectionModel();
        createSelectedRow();
        createBalance();
        createToolbar();
        createRemoveTransaction();
        createAddEntry();
        createRemoveEntry();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        createBalanceButton();
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        createFiscalPeriodLabel();
        createFiscalPeriodComboBoxModel();
        createFiscalPeriodComboBox();
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        createRefresh();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionUnbalancedTableModel();
        createFinancialTransactionUnbalancedTable();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TRANSACTION_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeTransaction.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_ENTRY_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                addEntry.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENTRY_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeEntry.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BALANCE_BUTTON_ENABLED, true ,"balance") {
        
            @Override
            public void processDataBinding() {
                balanceButton.setEnabled(!isBalance());
            }
        });
    }

}