package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.lang3.StringUtils;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class AccountColumn extends AbstractColumn<FinancialTransactionTableModel> {

    public AccountColumn() {
        super(Account.class, t("lima.entry.account"), true);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = tableModel.get(row);
        return entry.getAccount();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        Entry entry = tableModel.get(row);
        Account account = (Account) value;
        boolean update = ((entry.getAccount()) == null != (account == null))
                || (entry.getAccount() != null
                && !entry.getAccount().getAccountNumber().equals(account.getAccountNumber()));
        if (update) {
            Account previousAccount = entry.getAccount();
            entry.setAccount(account);
            if (!tableModel.updateEntry(entry)) {
                entry.setAccount(previousAccount);
                update = false;
            } else {
                if (StringUtils.isBlank(entry.getDescription()) && StringUtils.isNotBlank(account.getLabel())) {
                    entry.setDescription(account.getLabel());
                }
            }
        }
        return update;
    }
}
