/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.combobox;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.business.LimaServiceFactory;

import javax.swing.*;
import java.util.List;

/**
 * Opened financial period combo box model.
 *
 * @author chatellier
 * @version $Revision$
 *          <p/>
 *          Last update : $Date$
 *          By : $Author$
 */
public class FinancialPeriodComboBoxModel extends AbstractListModel implements ComboBoxModel, ServiceListener {

    private static final long serialVersionUID = 1L;

    private static final Log log =
            LogFactory.getLog(FinancialPeriodComboBoxModel.class);

    protected Object selectedFinancialPeriod;

    protected List<FinancialPeriod> datasCache;

    protected FinancialPeriodService financialPeriodService;

    protected FiscalPeriod selectedFiscalPeriod;

    private boolean displayAllPeriods;

    /** Constructor for locked period list. */
    public FinancialPeriodComboBoxModel() {
        this(false);
    }

    /**
     * Constructor for period list.
     *
     * @param displayAllPeriods if {@code true}, display all available period, otherwize
     *            display only locked ones
     */
    public FinancialPeriodComboBoxModel(boolean displayAllPeriods) {

        this.displayAllPeriods = displayAllPeriods;

        financialPeriodService =
                LimaServiceFactory.getService(
                        FinancialPeriodService.class);
        LimaServiceFactory.addServiceListener(FinancialPeriodService.class, this);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, this);
        LimaServiceFactory.addServiceListener(ImportService.class, this);
        if (displayAllPeriods) {
            datasCache = getAllDataList();
        } else {
            datasCache = getDataList();
        }
        for (FinancialPeriod financialPeriod : datasCache) {

        }
    }

    public void setSelectedFiscalPeriod(FiscalPeriod fiscalPeriod) {
        selectedFiscalPeriod = fiscalPeriod;
        if (displayAllPeriods) {
            datasCache = getAllDataList();
        } else {
            datasCache = getDataList();
        }
        fireContentsChanged(this, 0, datasCache.size());
    }

    @Override
    public int getSize() {
        return datasCache.size();
    }

    @Override
    public Object getElementAt(int index) {
        return datasCache.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        selectedFinancialPeriod = anItem;
    }

    @Override
    public Object getSelectedItem() {
        return selectedFinancialPeriod;
    }

    //get unblocked financial periods data list 
    public List<FinancialPeriod> getDataList() {
        List<FinancialPeriod> result = null;
        if (selectedFiscalPeriod != null) {
            result = financialPeriodService.getFinancialPeriods(selectedFiscalPeriod.getBeginDate(), selectedFiscalPeriod.getEndDate());
        } else {
            result = financialPeriodService.getUnblockedFinancialPeriods();
        }
        return result;
    }

    //get all financial periods data list
    public List<FinancialPeriod> getAllDataList() {
        List<FinancialPeriod> result = null;
        if (selectedFiscalPeriod != null) {
            result = financialPeriodService.getFinancialPeriods(selectedFiscalPeriod.getBeginDate(), selectedFiscalPeriod.getEndDate());
        } else {
            result = financialPeriodService.getAllFinancialPeriods();
        }
        return result;
    }

    public void refresh() {
        datasCache = getDataList();
        fireContentsChanged(this, 0, datasCache.size());
    }

    public void refreshAll() {
        datasCache = getAllDataList();
        fireContentsChanged(this, 0, datasCache.size());
    }

    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("Period") || methodeName.contains("importAll")) {
            if (displayAllPeriods) {
                datasCache = getAllDataList();
            } else {
                datasCache = getDataList();
            }
        }
    }
}
