package org.chorem.lima.ui.account;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import static org.nuiton.i18n.I18n.t;

public class UpdateAccountForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACCOUNT = "account";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_NUMBER_TEXT_FIELD_TEXT = "numberTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVy27TQBS9CU1C0kKhpWnLS6VUAiRwKrFAqIhXq6hU4SFaECIbJvY0cTv2GHtMXVUgPoFPgD0bJHasEAvWLNggfgEhFmwRd8aOEycuBJGFlcycc+4j9x6//gY5z4UTGyQINNe3hWlRbeXagwe3GxtUF0vU013TEdyF8JPJQrYOw0Z87gk4Wa9JeiWiVxa55XCb2l3shRqUPLHNqNeiVAg4lmTonldZja8XAsd326pxUmmqL398z74wnr/KAgQOZjeCpcz8jdWpZKgGWdMQMIaRnpAKI3YT03BNu4n57pNni4x43i1i0cfwDAo1yDvERTEBs4OXrDQUP3AETPqOQQS9puscuVXuWksmYbwp4Cx3m5re4i61NGZaRPNNjYQw7V4vyXGUZF5AoUVsg1FXwLk/CETU+ybdWg7xXQoRSMDxXgWsyBTbbXYXZW6NNBidFzCVaLe3hc3T1J1EFmPCsO1bDerWSIMybLjsbRChV9ShxI3F8NEQvkYDUTUpw/+onKDEF0nagfZcmtyOVSeTmENdmITM4SSuNLfEdd/CDmCV093RBbK09mWnJ3vnVu4Qm7L53vrUaVI8rxNbl50YTyCv+0JwW2JmY2iWb8pvp6JTF44kOo6ro3VWpzPbmTrkXB+P8S+q92/bXbwK92yqZ8+koLr9VR7//O7r22p7uUoYeyIV2uUNOPSOyx0cR1OGHg03yxcmq9wkzkIdih5laCzKOI6mJLYaXWNyGO+gpGuSri0Tr4USucKX9x/Kjz7tgWwVSowTo0ok/gYURcvFLnBmBM6Vqyqjka29+DwgcxOQw1Fm2KIpNdntxQjXUVvHnQqwG0dTuhGn1Ch+/Dm++uZquyMZzHB6V3inK7mHkDdtZtpUGU7kJakGM+x41Dd4xzPSXAR2txEnmseKep7v60MW55TJzUCKgIM7PXv2VMCQHG8czESXQljgS9ELqnL57SIkF3uA4AVqS3PAhc6tE+bRON6JnSYVUTmnz2idH7eU/ukzT9Oi9/rEv5Vf3knzgk4PSqoHCp8WvM9t/hY9EytP91WrBHapMtWyBg82rMoIHSdNPjKjwQULSpBvpomhXQ0gNGHQdeIzsci4R2+jXRBZm4D9l3CqyUzDtA00xMt9ATLyWRogQM7iBpFvmkvh4s0QgS/2hi/of4jmGdnmvpD3PF3lJKr8Bhjnv9ZTCQAA";
    private static final Log log = LogFactory.getLog(UpdateAccountForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Account account;
    protected JButton cancel;
    protected JLabel descriptionLabel;
    protected JTextField descriptionTextField;
    protected AccountViewHandler handler;
    protected JLabel numberLabel;
    protected JTextField numberTextField;
    protected JButton ok;
    protected UpdateAccountForm updateAccountFormDialog = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UpdateAccountForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm() {
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0) {
        super(param0);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateAccountForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateAccountForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateAccount(this);
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        account.setLabel(descriptionTextField.getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        account.setLabel(descriptionTextField.getText());
    }

    public void doWindowClosing__on__updateAccountFormDialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Account getAccount() {
        return account;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getDescriptionLabel() {
        return descriptionLabel;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public AccountViewHandler getHandler() {
        return handler;
    }

    public JLabel getNumberLabel() {
        return numberLabel;
    }

    public JTextField getNumberTextField() {
        return numberTextField;
    }

    public JButton getOk() {
        return ok;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAccount(Account account) {
        Account oldValue = this.account;
        this.account = account;
        firePropertyChange(PROPERTY_ACCOUNT, oldValue, account);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToUpdateAccountFormDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createAccount() {
        $objectMap.put("account", account = null);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createDescriptionLabel() {
        $objectMap.put("descriptionLabel", descriptionLabel = new JLabel());
        
        descriptionLabel.setName("descriptionLabel");
        descriptionLabel.setText(t("lima.label"));
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(AccountView.class,JAXXUtil.PARENT).getHandler());
    }

    protected void createNumberLabel() {
        $objectMap.put("numberLabel", numberLabel = new JLabel());
        
        numberLabel.setName("numberLabel");
        numberLabel.setText(t("lima.account.number"));
    }

    protected void createNumberTextField() {
        $objectMap.put("numberTextField", numberTextField = new JTextField());
        
        numberTextField.setName("numberTextField");
        numberTextField.setColumns(15);
        numberTextField.setEnabled(false);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToUpdateAccountFormDialog();
        // inline complete setup of $Table0
        $Table0.add(numberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(numberTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        numberLabel.setLabelFor(numberTextField);
        descriptionLabel.setLabelFor(descriptionTextField);
        // late initializer
        updateAccountFormDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("updateAccountFormDialog", updateAccountFormDialog);
        createHandler();
        createAccount();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNumberLabel();
        createNumberTextField();
        createDescriptionLabel();
        createDescriptionTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = descriptionTextField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of updateAccountFormDialog
        setName("updateAccountFormDialog");
        setModal(true);
        setTitle(t("lima.account.update.form"));
        updateAccountFormDialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__updateAccountFormDialog"));
        
        getRootPane().setDefaultButton(ok);// registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NUMBER_TEXT_FIELD_TEXT, true ,"account") {
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    SwingUtil.setText(numberTextField, getAccount().getAccountNumber());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true ,"account") {
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    SwingUtil.setText(descriptionTextField, getAccount().getLabel());
                }
            }
        });
    }

}