package org.chorem.lima.ui.account;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.AccountsChartEnum;
import static org.nuiton.i18n.I18n.t;

public class AccountImportForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wy27TQBSdpk1fKa+WVuVRKA+JDXJALBBqBTRtCkXpQw1CiCxgYg+NYeIxM+PWCIH4BD4B9myQ2LFCLFizYIP4BYRYsEXcGTt2XKbUQmRhJZ57zz33zpwzef0NFQVHJx7gMLR44Em3Tawbc7dvrzYfEFsuEGFz15eMo+jTU0CFBio5yXsh0alGTaWX4/TyPGv7zCNeV/ZMDQ0L+ZgS0SJESjSVzbCFKNeT5ZnQD3gHNSFlQn3543vhhfP8VQGh0Ad2e6CV6d2y0k76aqjgOhKNQqVNXKbY2wAa3PU2gO8e9W6eYiFWcJs8Qs/QQA31+5gDmEQn87esMXR+6Es0hm2bQdYSJHC54GLKNiQ6y/iGZbcYJ22Lum1sBa4VB1pz3QmLjLd9X8P1S1RqBlIy7xpnAUCfzHQutqAPvZWVNChNHcSOU5dYEokOqE4t1b1VYYwS7KVhA6dv4iYl5ySaNKDrNRU5lFLqHA2XeTBZBR12uNRwk1AVN5qEDwloWhKPOLpCV/A6dlwWUc+mjMSDERUsdPHD2yAdskko84ljWnT1GG2xufMiafqGxXgS59XPg9mlfht7NqGwuZkOUvKnktACe6i+nYnfcnQkM1YQgpUKIT2pPQ1U5AG8hik1/tTOOixFqpncphoFqFd/TYx9fvf17WJHKiWoPW4M7VI6HGGfwyS5dFXpfZFOAunS8jL2ZxqwfYSCTWgbOGogVo+XgRzUiw6aSreuY9ECiOLAl/cfJu596kWFRTRMGXYWsYpfQkOyxWEKjDqhf+WqZjSyNQjP/YqbREXpSgojGtNy6Wgl2sAQBnHUMIiETXPo48+x+purnWH0ALlDO4anAyneQf2uR12PaOeITcHoFCVfkMBhqfhNdoDMftCRaVk/L5ja75MkBBs6buje6lJgGCiEi7pF9e0Syip0t0p9YBTRFiuB9kkekKT2lK5ttzCU7EjS6pJz1pyyv4qbmCqoqSexu4l5hVP1grZVv766frO6Ul14amKfGsZu3HsTppMmpk1wj3wkJw0kK3P1qpFfxp3yUzQOMzGyfx/mQvVWtba6ttMwkwr5mR4zMY1PHthqPqqHDVSXltdg4808E9f+PzzB4fPxPLYjz7vVytrfuEKJ/DIuRVz1LWLCjC+Y/IADGpA9NIHBFZQDaNwh93FA5TxlgqzCFYCjG33vrIMlnm66ngOX3OU/CvSo53COAsU2czDcmaOzkaNOYwl/vWAXyF9AfwMycq9GrwoAAA==";
    private static final Log log = LogFactory.getLog(AccountImportForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AccountImportForm accountImportDialog = this;
    protected JRadioButton accountsBase;
    protected Boolean addState;
    protected JAXXButtonGroup buttonGroup;
    protected JButton cancel;
    protected JLabel description;
    protected JRadioButton developed;
    protected JRadioButton importcsv;
    protected JRadioButton importebp;
    protected JButton ok;
    protected JRadioButton shortened;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            buttonGroup.setSelectedValue(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountImportForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm() {
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0) {
        super(param0);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountImportForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AccountImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doWindowClosing__on__accountImportDialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButton getAccountsBase() {
        return accountsBase;
    }

    public Boolean getAddState() {
        return addState;
    }

    public JAXXButtonGroup getButtonGroup() {
        return buttonGroup;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getDescription() {
        return description;
    }

    public JRadioButton getDeveloped() {
        return developed;
    }

    public JRadioButton getImportcsv() {
        return importcsv;
    }

    public JRadioButton getImportebp() {
        return importebp;
    }

    public JButton getOk() {
        return ok;
    }

    public JRadioButton getShortened() {
        return shortened;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccountImportDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void addChildrenToAccountsBase() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; accountsBase.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(accountsBase); }
    }

    protected void addChildrenToDeveloped() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; developed.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(developed); }
    }

    protected void addChildrenToImportcsv() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; importcsv.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(importcsv); }
    }

    protected void addChildrenToImportebp() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; importebp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(importebp); }
    }

    protected void addChildrenToShortened() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = buttonGroup; shortened.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(shortened); }
    }

    protected void createAccountsBase() {
        $objectMap.put("accountsBase", accountsBase = new JRadioButton());
        
        accountsBase.setName("accountsBase");
        accountsBase.setText(t("lima.chart.accounts.base"));
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createButtonGroup() {
        $objectMap.put("buttonGroup", buttonGroup = new JAXXButtonGroup());
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JLabel());
        
        description.setName("description");
        description.setText(t("lima.account.import.description"));
    }

    protected void createDeveloped() {
        $objectMap.put("developed", developed = new JRadioButton());
        
        developed.setName("developed");
        developed.setText(t("lima.chart.accounts.developed"));
    }

    protected void createImportcsv() {
        $objectMap.put("importcsv", importcsv = new JRadioButton());
        
        importcsv.setName("importcsv");
        importcsv.setText(t("lima.chart.accounts.import.csv"));
    }

    protected void createImportebp() {
        $objectMap.put("importebp", importebp = new JRadioButton());
        
        importebp.setName("importebp");
        importebp.setText(t("lima.chart.accounts.import.ebp"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createShortened() {
        $objectMap.put("shortened", shortened = new JRadioButton());
        
        shortened.setName("shortened");
        shortened.setText(t("lima.chart.accounts.shortened"));
        shortened.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAccountImportDialog();
        // inline complete setup of $Table0
        $Table0.add(description, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(shortened, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsBase, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(developed, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(importcsv, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(importebp, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToShortened();
        addChildrenToAccountsBase();
        addChildrenToDeveloped();
        addChildrenToImportcsv();
        addChildrenToImportebp();
        // inline complete setup of $Table1
        $Table1.add(cancel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(ok, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        { shortened.putClientProperty("$value", AccountsChartEnum.SHORTENED);  Object $buttonGroup = shortened.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { accountsBase.putClientProperty("$value", AccountsChartEnum.BASE);  Object $buttonGroup = accountsBase.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { developed.putClientProperty("$value", AccountsChartEnum.DEVELOPED);  Object $buttonGroup = developed.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { importcsv.putClientProperty("$value", AccountsChartEnum.IMPORT);  Object $buttonGroup = importcsv.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { importebp.putClientProperty("$value", AccountsChartEnum.IMPORT_EBP);  Object $buttonGroup = importebp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        accountImportDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("accountImportDialog", accountImportDialog);
        createButtonGroup();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createDescription();
        createShortened();
        createAccountsBase();
        createDeveloped();
        createImportcsv();
        createImportebp();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createCancel();
        createOk();
        // inline creation of accountImportDialog
        setName("accountImportDialog");
        setModal(true);
        setTitle(t("lima.account.import"));
        accountImportDialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__accountImportDialog"));
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}