package org.chorem.lima.ui.Filter.AccountCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.ListSelectionModel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.AccountCondition;
import org.chorem.lima.ui.combobox.AccountComboBoxModel;
import org.chorem.lima.ui.common.AccountListRenderer;
import static org.nuiton.i18n.I18n.t;

public class AccountConditionView extends JInternalFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTWsTQRh+kzZp0y8/Sktrq8QPpAXZROpFKvaT0JZUoYFSzMVJdkym7O6MM7Nma6n4E/wJevciePMkHjx78CL+BREPXsV3Npts2qRUcGGHZN73feaZ532fffsDUkrC1X0SBJb0Pc1cam2t7O09rOzTql6nqiqZ0FxC80kkIVmGYbu9rzRcLxdNeS4qz61xV3CPeh3Vi0UYUvrAoapOqdZw+XhFValcqR1eDIQvW6htUr1QX//6mXxlv3yTBAgEsuvHq2TPqopv0l+EJLM1XMSTnpGcQ7wa0pDMqyHfUbO35hClHhCXPoUXMFCEtCASwTRc+/crhxhhfSA0TJBqlWPVGvdsphn3ChLhNSxxWbOqdS6paznMJZbPrAJzNJXWyomKro1dRhtChGekNQzUiWc7VGpY/Q/MjSZIDDsSEd/mNnU05HtgV7lb4RUexGD4f5UHYUkHwQgJxTAaB5ZqoOTWVivdpGUEtnLmWCtxSKx4SOIuJsqQkj5ua5gqd8/VDoaaEzV1YqIMYBj9Mzn+9cP394XWGPXh2RM9UztcgO0VkgvUmZmjzzVnyNfMyW0TsViGjKIOWii0yGwPYqUojOTwvAum3DLl1gZRdYRIDXz7+Gny8Zc+SBZgyOHELhCTvwkZXZeoAnfsQCwth4xGGoO4nsc3qSGlmXZQopGwMW21R4WkT6iU1C6x5xiePvRoI7uOfDyFHZ+7k8/fyt7O5+ePAlRrtodabcqVzOff46V3yy3FEniD6VPTY9VSjyDNPId5NLRe5KqeVhsWivo2j93Ty09wmqFENG6XwvVKl0r9qJLbnOSxw87JPkLZmo2j9qamrobJw8hQVo3qaLLn5o+69Zw6oefCXdRzIW9SB/GrYVNpTDkTZkU4Rab0ThSaM7obtjdCQc2vmxC75awbJTSkHXLAfez02D2baJKtMJTEq93vgk2YdQgR/wK0H165/wUAAA==";
    private static final Log log = LogFactory.getLog(AccountConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox account;
    protected AccountConditionView accountConditionFrame = this;
    protected AccountComboBoxModel accountModel;
    protected AccountConditionHandler handler;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountConditionView() {
        $initialize();
    }

    public AccountConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountConditionView(String param0) {
        super(param0);
        $initialize();
    }

    public AccountConditionView(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountConditionView(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountConditionView(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountConditionView(String param0, boolean param1, boolean param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AccountConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountConditionView(String param0, boolean param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AccountConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountConditionView(String param0, boolean param1, boolean param2, boolean param3, boolean param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AccountConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4, boolean param5) {
        super(param1 ,param2 ,param3 ,param4 ,param5);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInternalFrameClosed__on__accountConditionFrame(InternalFrameEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doItemStateChanged__on__account(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.accountSelected(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox getAccount() {
        return account;
    }

    public AccountComboBoxModel getAccountModel() {
        return accountModel;
    }

    public AccountConditionHandler getHandler() {
        return handler;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(AccountConditionHandler handler) {
        AccountConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccountConditionFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(account);
    }

    protected void createAccount() {
        $objectMap.put("account", account = new JComboBox());
        
        account.setName("account");
        account.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__account"));
    }

    protected void createAccountModel() {
        $objectMap.put("accountModel", accountModel = new AccountComboBoxModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AccountConditionHandler(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAccountConditionFrame();
        
        // apply 6 property setters
        setPreferredSize(new Dimension(400, 100));
        account.setModel(accountModel);
        account.setPreferredSize(new Dimension(390, 30));
        account.setSelectedItem(handler.getAccount());
        account.setRenderer(new AccountListRenderer());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("accountConditionFrame", accountConditionFrame);
        createHandler();
        createAccountModel();
        createAccount();
        // inline creation of accountConditionFrame
        setName("accountConditionFrame");
        setVisible(true);
        setClosable(true);
        setDefaultCloseOperation(2);
        accountConditionFrame.getContentPane().setLayout(new FlowLayout());
        setTitle(t("lima.account"));
        accountConditionFrame.addInternalFrameListener(JAXXUtil.getEventListener(InternalFrameListener.class, "internalFrameClosed", this, "doInternalFrameClosed__on__accountConditionFrame"));
        
        accountConditionFrame.pack();
        $completeSetup();
    }

}