/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.enums;

import java.net.URL;

public enum AccountsChartEnum {

    IMPORT(""), IMPORT_EBP(""), SHORTENED("pcg_shortened.csv"), BASE("pcg_base.csv"), DEVELOPED("pcg_developed.csv");

    private final String filePath;

    AccountsChartEnum(String filePath) {
        this.filePath = filePath;
    }

    public URL getDefaultFileURL() {
        URL url = ImportExportEnum.getFileURL("/import/" + filePath);
        return url;
    }

}
