package org.chorem.lima.ui.financialtransactionunbalanced;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionDefaultTable;
import static org.nuiton.i18n.I18n.t;

public class FinancialTransactionUnbalancedView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BALANCE = "balance";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXS3MTRxAeC2RbNgT84P2IwSqKA7XiebIrEDulOIocKEsECnFgdndkDTWaWWZno80lxU/gyDG550IVN05UDjnnkEsqfyGVyoErRc+utKuV16stFHyQ5Z7ur7+vp7d7/es/qOhKdOEp9n1DelzRLjFqXz58eNd8Siz1FXEtSR0lJAp/pgqo0ELzdmR3FVpt1XV4pR9e2RRdR3DCh6LX6mjOVT8y4nYIUQqdS0ZYrltpRMdrvuPJAWpEKg315//+Lbywn/9SQMh3gN0ySFkZFxUrOVhHBWortAiZfsAVhvku0JCU7wLfw9q2ybDrfoe75Bn6Cc3U0bSDJYApdDG/5AAjiPcdhWbKTWwyclWhppC7htURknQNRrvY8KjRphxzi2KmJOYuthQV3OMmBmoWsY3q4LgZH9+Pjr+npOc4QappSNTB3GZEKtT6FIm2QvQ432cuYSRw3BY2YQqd1wX0DbcH9TTq1FWNhEMcOR9GEntH9BRa0GGGvgtjQwhGMB/S1Geg/1yOzQtdDVilroXZPSKpgDu9lSLaEl1TmMI3hl03tXFD+COk5sq1JqTfwBKuanlYysCuHUuRf6lc2/CUEhzclxLuoVm7nd7rfU0bPt/n8HrK4XLEq9wg0I0YWu3qSLH3euyT4EbOBAHLS0m/hfZQEevY1Fe+mGARGEfA2ymVV+hYIm5gH8/regqvSNzNFHGHy7WGJQVj9zDXz+CJROL4KHm3l9uZj0PwQPeb/tH//azF4HFvrubgo9D9T0JFU7jlwJw9k5izMMGNeILHI3aqhYrSA7NCJ1t7h/4OHIXj/uTIuNeAwen740t/vvn7dXUw409B7mOprkMrCmavI4UD04/q1EfCAe8pyirb2FlroVI4c4L9dTaFWKN/DOQgXziTdLixhd0OQBRn/nr72/EnfxxAhSqaYwLbVaz9v0El1ZFQBcFs37l9J2B0qDcLn0c1N2jBxJyEubluY4VXTMptaMIvfKjF2ZRaRITM0u/vlhqv7gzqMQX8Tu3rHtek+AhNU84oJ8HW6y+01C0377jEs0W8uNJW2ZT+fdTpd+Vm8Pl1muBSG8qjwp5cXA8prGAFe9b0FAHBOvLbQIn+th0An8kBfJBa4VytpWOcz4ExQ7hmZk8IM69gNDWp0yS+mghKmx9kIFzIhfB4YgQ8MUKWitWJVeRDyFKRDyFLxeWJVeRDyFKRDyFLxZUc7T3L9Cqvhu8Rk+AQm6rBFtlJx6nkwCkGL3wZZPKAzMKbvE0kyRI1Hie6oI+WM+6Cbk7cJPkQXmYgrOeZ81L0tgjd7aiMcuQBGvlPYgytD2C2EMnCDgAA";
    private static final Log log = LogFactory.getLog(FinancialTransactionUnbalancedView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean balance;
    protected FinancialTransactionUnbalancedTable financialTransactionUnbalancedTable;
    protected FinancialTransactionUnbalancedTableModel financialTransactionUnbalancedTableModel;
    protected JComboBox fiscalPeriodComboBox;
    protected JLabel fiscalPeriodLabel;
    protected FinancialTransactionUnbalancedViewHandler handler;
    protected FiscalPeriodComboBoxModel modelFiscalPeriod;
    protected Boolean selectedRow;
    protected ListSelectionModel selectionModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private JToolBar $JToolBar0;
    private FinancialTransactionUnbalancedView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            getHandler().init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionUnbalancedView() {
        $initialize();
    }

    public FinancialTransactionUnbalancedView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteSelectedTransaction();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addEntry();
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteSelectedEntry();
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.balanceTransaction();
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().refresh();
    }

    public void doActionPerformed__on__fiscalPeriodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialTransactionUnbalancedTableModel().setFiscalPeriod( (FiscalPeriod) fiscalPeriodComboBox.getSelectedItem());                 getHandler().refresh();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectionChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getBalance() {
        return balance;
    }

    public FinancialTransactionUnbalancedTable getFinancialTransactionUnbalancedTable() {
        return financialTransactionUnbalancedTable;
    }

    public FinancialTransactionUnbalancedTableModel getFinancialTransactionUnbalancedTableModel() {
        return financialTransactionUnbalancedTableModel;
    }

    public JComboBox getFiscalPeriodComboBox() {
        return fiscalPeriodComboBox;
    }

    public JLabel getFiscalPeriodLabel() {
        return fiscalPeriodLabel;
    }

    public FinancialTransactionUnbalancedViewHandler getHandler() {
        return handler;
    }

    public FiscalPeriodComboBoxModel getModelFiscalPeriod() {
        return modelFiscalPeriod;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public Boolean isBalance() {
        return balance !=null && balance;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBalance(Boolean balance) {
        Boolean oldValue = this.balance;
        this.balance = balance;
        firePropertyChange(PROPERTY_BALANCE, oldValue, balance);
    }

    public void setHandler(FinancialTransactionUnbalancedViewHandler handler) {
        FinancialTransactionUnbalancedViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBalance() {
        $objectMap.put("balance", balance = true);
    }

    protected void createFinancialTransactionUnbalancedTable() {
        $objectMap.put("financialTransactionUnbalancedTable", financialTransactionUnbalancedTable = new FinancialTransactionUnbalancedTable(handler));
        
        financialTransactionUnbalancedTable.setName("financialTransactionUnbalancedTable");
        financialTransactionUnbalancedTable.setRowHeight(22);
    }

    protected void createFinancialTransactionUnbalancedTableModel() {
        $objectMap.put("financialTransactionUnbalancedTableModel", financialTransactionUnbalancedTableModel = new FinancialTransactionUnbalancedTableModel());
    }

    protected void createFiscalPeriodComboBox() {
        $objectMap.put("fiscalPeriodComboBox", fiscalPeriodComboBox = new JComboBox());
        
        fiscalPeriodComboBox.setName("fiscalPeriodComboBox");
        fiscalPeriodComboBox.setEditable(false);
        fiscalPeriodComboBox.setToolTipText(t("lima.ui.financialtransaction.fiscalyear"));
        fiscalPeriodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fiscalPeriodComboBox"));
    }

    protected void createFiscalPeriodLabel() {
        $objectMap.put("fiscalPeriodLabel", fiscalPeriodLabel = new JLabel());
        
        fiscalPeriodLabel.setName("fiscalPeriodLabel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionUnbalancedViewHandler(this));
    }

    protected void createModelFiscalPeriod() {
        $objectMap.put("modelFiscalPeriod", modelFiscalPeriod = new FiscalPeriodComboBoxModel());
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JButton0);
        $JToolBar0.add($JButton1);
        $JToolBar0.add($JButton2);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add($JButton3);
        $JToolBar0.add($JToolBar$Separator1);
        $JToolBar0.add(fiscalPeriodLabel);
        $JToolBar0.add(fiscalPeriodComboBox);
        $JToolBar0.add($JToolBar$Separator2);
        $JToolBar0.add($JButton4);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionUnbalancedTable);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        selectionModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $JButton0.setIcon(SwingUtil.createActionIcon("delete-financial-transaction"));
        $JButton0.setToolTipText( t("lima.entries.remove.transaction") + " (Ctrl+Shift+Del)");
        $JButton1.setIcon(SwingUtil.createActionIcon("add-entry"));
        $JButton1.setToolTipText( t("lima.entries.addEntry") + " (Ctrl+N)");
        $JButton2.setIcon(SwingUtil.createActionIcon("delete-entry"));
        $JButton2.setToolTipText( t("lima.entries.remove.entry") + " (Ctrl+Del)");
        $JButton3.setIcon(SwingUtil.createActionIcon("balance"));
        $JButton3.setToolTipText( t("lima.entries.balance") + " (Ctrl+B)");
        fiscalPeriodLabel.setIcon(SwingUtil.createActionIcon("choose-fiscal-year"));
        fiscalPeriodLabel.setLabelFor(fiscalPeriodComboBox);
        fiscalPeriodComboBox.setModel(modelFiscalPeriod);
        fiscalPeriodComboBox.setRenderer(new org.chorem.lima.ui.common.FiscalPeriodListRenderer());
        $JButton4.setIcon(SwingUtil.createActionIcon("refresh"));
        $JButton4.setToolTipText( t("lima.ui.common.refresh") + " (F5)");
        financialTransactionUnbalancedTable.setModel(getFinancialTransactionUnbalancedTableModel());
        financialTransactionUnbalancedTable.setSelectionModel(selectionModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectionModel();
        createSelectedRow();
        createBalance();
        createModelFiscalPeriod();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        createFiscalPeriodLabel();
        createFiscalPeriodComboBox();
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionUnbalancedTableModel();
        createFinancialTransactionUnbalancedTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"balance") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setEnabled(!isBalance());
            }
        });
    }

}