package org.chorem.lima.ui.account;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import static org.nuiton.i18n.I18n.t;

public class AccountView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUO28TQRBemzxwnEAShzyUByFEVHCOBKIgEeSBoiRyAMUWinDD+m6xN6xvl929+GgQP4GfAD0NEh0VoqCmoEH8BYQoaBGzd44vThznFFvy3Wnmm2+/mZ2Z979Qt5Loyh72fUt6rqZVYm2t7O4+LO0RW98nypZUaC5R+EskUbKI0k7DrjS6WsyZ8Gw9PLvGq4K7xD0UvZhDfUq/ZERVCNEaTTdH2Epl8w33oi88ecDaENWK9e2f38k3zut3SYR8AerSkMrsaVFRJl05lKSORsNw0j7OMuyWQYakbhn0DhjbGsNKPcBV8gK9Qr051COwBDKN5uKnHHAE8b7QqHe+gEuMLGh0jcuyZVe4JFWL0Sq2PGph2+ZAaa2E78eU1IQIgnsgtIJdhxGp0Y14oRshPmJIK8LgVomzw2saDZkMLZO1tco5I9iNkH3zWwWwrWIJSkcM0LdUDSpjHdgNMNXAp7DjrHpac1ejTBM8tBrYcAPd7wkHaxK5xo74ITG+38ZPodxSn+gfmN/K25Iz9gi7ptRjTYoiV3MOQ/USqoIkJLgljS6bSu9Buz/XXIQEvrW120CY0JkGw8h8jiqdD4pMubvNHcLg+JnDxx9HQNUlmmxqWxgIKxqIqGMTRdQtPTBrNF48PkM74AqnZ/zI9BjCwPtvNPP908+P6wcjcwHOvtQSemjioZWF5AJaj5qjL4bz4mnKsttYLBZRKmysYB1MtRCWr7tBHJwXNp4JtzawqgBFd++Pz19Gn347h5LrqI9x7Kxjg99EKV2RUAXOHF/cWw4U9dfOw3PQaIPGewZoHV7W8BJ1GXXJLNYwxSVPk7s+1GKqRS0agkqpr38z+Q/LB/VIgL6JE+FRTbqfoJ7wtGCJ1PdDy6WRFop4Do/2QKvNkDDvjKhP4PXgudAq4S5qmyG7sAQThGdL1HWgqyBPE3ArSMB83Q74RmPwpTXMc4GKAvG1AS2elcqY77RhmIghppe45iqdjmiMebljhnapTMZi2OyYoV0W8RjaZTEdX8PNszLArq7QcoXBXxOp2qiZi8E1oA4vzg7JBjUs8TXC2A5xHSKJPIXvP0lZlD8rCQAA";
    private static final Log log = LogFactory.getLog(AccountView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTreeTable accountsTreeTable;
    protected JButton addButton;
    protected AccountViewHandler handler;
    protected JButton importButton;
    protected JButton removeButton;
    protected Boolean selectedRow;
    protected JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private JToolBar $JToolBar0;
    private ListSelectionModel $ListSelectionModel0;
    private AccountView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            handler.init();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountView() {
        $initialize();
    }

    public AccountView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addAccount();
    }

    public void doActionPerformed__on__importButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importAccountsChart();
    }

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeAccount();
    }

    public void doActionPerformed__on__updateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateAccount();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(accountsTreeTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTreeTable getAccountsTreeTable() {
        return accountsTreeTable;
    }

    public JButton getAddButton() {
        return addButton;
    }

    public AccountViewHandler getHandler() {
        return handler;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JButton getUpdateButton() {
        return updateButton;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountsTreeTable() {
        $objectMap.put("accountsTreeTable", accountsTreeTable = new JXTreeTable());
        
        accountsTreeTable.setName("accountsTreeTable");
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AccountViewHandler(this));
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.setToolTipText(t("lima.ui.importexport.import"));
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new JButton());
        
        updateButton.setName("updateButton");
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add(addButton);
        $JToolBar0.add(updateButton);
        $JToolBar0.add(removeButton);
        $JToolBar0.add(importButton);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(accountsTreeTable);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        addButton.setIcon(SwingUtil.createActionIcon("account-new"));
        addButton.setToolTipText( t("lima.ui.account.addaccount") + " (Ctrl+N)");
        updateButton.setIcon(SwingUtil.createActionIcon("account-edit"));
        updateButton.setToolTipText( t("lima.ui.common.update") + " (Ctrl+M)");
        removeButton.setIcon(SwingUtil.createActionIcon("account-remove"));
        removeButton.setToolTipText( t("lima.ui.common.remove") + " (Del)");
        importButton.setIcon(SwingUtil.createActionIcon("account-import"));
        accountsTreeTable.setHighlighters(HighlighterFactory.createSimpleStriping(new java.awt.Color(233,233,233)));
        accountsTreeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        accountsTreeTable.setTreeCellRenderer(new AccountTreeTableRenderer());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        createAddButton();
        createUpdateButton();
        createRemoveButton();
        createImportButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAccountsTreeTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = accountsTreeTable.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isSelectedRow());
            }
        });
    }

}