package org.chorem.lima.ui.Filter.financialPeriodCondition;

/*
 * #%L
 * Lima :: Swing
 * $Id: FinancialPeriodConditionHandler.java 3701 2013-08-02 17:00:32Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.3/lima-swing/src/main/java/org/chorem/lima/ui/Filter/financialPeriodCondition/FinancialPeriodConditionHandler.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.Condition;
import org.chorem.lima.beans.FinancialPeriodCondition;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.Filter.ConditionHandler;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionHandler;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class FinancialPeriodConditionHandler implements ConditionHandler {

    /** log. */
    private static final Log log =
            LogFactory.getLog(FinancialTransactionSearchViewHandler.class);

    protected FinancialPeriodConditionView view;

    protected FinancialPeriodCondition condition;

    protected FinancialTransactionConditionHandler filterHandler;

    public FinancialPeriodConditionHandler(FinancialPeriodConditionView view) {
        this.view = view;
        this.condition = new FinancialPeriodCondition();
    }

    @Override
    public Condition getCondition() {
        return condition;
    }

    @Override
    public JComponent getView() {
        return view;
    }

    @Override
    public void setFilterHandler(FinancialTransactionConditionHandler filterHandler) {
        this.filterHandler = filterHandler;
    }

    public Object[] getFinancialPeriodList() {
        FinancialPeriodService financialPeriodService = LimaServiceFactory.getService(FinancialPeriodService.class);
        Object[] result = {};
        List<FinancialPeriod> periods = null;
        try {
            periods = financialPeriodService.getAllFinancialPeriods();
            result = periods.toArray();
        } catch (LimaException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Can't get Financial Period list", ex);
            }
        }
        return result;
    }

    public void setFinancialPeriod(ListSelectionEvent event) {
        JList financialPeriodList = view.getFinancialPeriodList();
        List selectedValuesList = new ArrayList(Arrays.asList(financialPeriodList.getSelectedValues()));
        condition.setFinancialPeriods(selectedValuesList);
    }

    public void delete() {
        filterHandler.removeCondition(this);
    }

}
