/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.vatreports;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.DocumentServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.service.LimaServiceFactory;

public class VatReportViewHandler {
    /** log. */
    private static final Log log =
        LogFactory.getLog(VatReportViewHandler.class);
    
    protected VatReportView view;
    
    protected VatReportTable table;
    
    protected VatReportTableModel tableModel;
    
    protected DocumentServiceMonitorable documentService;
    
    private static SimpleDateFormat dateFormat =
        new SimpleDateFormat("yyyy-MM-dd");
    
    protected int port;
    
    protected VatReportViewHandler(VatReportView view) {
        this.view = view;
        
        port = LimaServiceFactory.getInstance().getService(
                HttpServerServiceMonitorable.class).getHttpPort();
        
        documentService =
            LimaServiceFactory.getInstance().getService(
                    DocumentServiceMonitorable.class);
    }
    
    /**
     * @return VatView
     */
    public VatReportView getView() {
        return view;
    }
    
    /**
     * Edit VAT document
     */
    public void editVat() {
        if ((tableModel.getBeginDate() != null) || (tableModel.getEndDate() != null)){
            String address = LimaConfig.getInstance().getHostAdress();
            
            try {
                String url = "http://"+address+":"+port+"/?beginDate="
                + dateFormat.format(tableModel.getBeginDate())
                + "&endDate=" + dateFormat.format(tableModel.getEndDate())
                + "&format=.pdf&model=" + DocumentsEnum.VAT.getFileName()
                + "&autocomplete=" + tableModel.getAutocomplete();
                Desktop.getDesktop().browse(new URI(url));            
            } catch (IOException e) {
                log.error("Can't open browser", e);
            } catch (URISyntaxException e) {
                log.error("Can't create news URI", e);
            }
        }
    }
    
    /**
     * Refresh VatTableModel
     */
    public void refresh(){
        tableModel = view.getVatReportTableModel();
        tableModel.refresh();
    }
    
}
