/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.fiscalperiod;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import static org.nuiton.i18n.I18n._;

public class FiscalPeriodView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_PERIOD = "selectedPeriod";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLOCK_BUTTON_ENABLED = "blockButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRBdmziOEwIkgZCIACakoEDnQEGKRBASZIXgQIRRFOGG9d3G3rDePXb38NEgfgI/AXoaJDoqREFNQYP4CwhR0CJm92yfTY584eLs25l5++Z53rz5jjJKogvbOAwdGXBNG8RZvbm5ea+6TVx9iyhXUl8LiaJPKo3SFTTkdc6VRhcrJVNeaJUXlkXDF5zwrur5EhpU+hkjqk6I1uhsb4WrVKHcCc+HfiDbqB1SSaivfv5Iv/RevE4jFPrALget5PeqijvpK6E09TQahZue4gLDvAY0JOU14DtszpYZVuoubpAn6DnKllC/jyWAaTS9/5Ythq0PfY2yMw9wlZFZjWaFrDluXUjScBhtYCegzhZVLmY+kVR4TtG+rNuXDUqavm9h+gGkjrnHiNRo7qAgK1FljHVMEQb/NPGiHI1GTOOOEcNZEoIRzOPk4ZnVsisFY+uYmx5Om9zQUU3QzOkKmfRcp2q8ITzCuplYDTS6dhD2tmbNIMV8RrZ2gl45MKgBG+1gnpwpUaXLVhUquL0RWj3X3erOjJhTDnveUqC14BqN9egTnfZqM1Rlwn0cR/KtsERnegYZLOLEFolnOFVBGRnAsUYTlZ2uug+hyE8Tf/nJANro7/GxL++/vSu2TTQAd59KTO3aATDcvhQgqKbm6uORgwJNWWEN+/MVsKKVxy6IqQRi5VYYyMF90cyZcmcFqzpAZLJfP3wcf/T5CEoX0SAT2Ctik38b5XRdggqCeaF/Y9EyOtocgOcJww3+P1ewoMGXQX8Yxw2qqB2L0QXKGeUkjzVYvBpocj0EWaYSZOlwq+Y+/Rorv11sS5MCqpP/TI/lyTxE/dFtdsO0lkfiRhnyFQk8ES+JpLWRMt+TfmvGLtnn5aTeM9ZpYOoFD2ucr1LuweRBo6Zi1nZgfl3dN2BOiuYKobW6NimFwwMNq267mLS5w4MNKCF127n/QapPk3C3xs7vAyNLuGHi7dLS9J4w5vjOLkQMwh+P3bZ7qwcAAA==";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FiscalPeriodView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JButton blockButton;
    protected FiscalPeriodTable fiscalPeriodTable;
    protected FiscalPeriodViewHandler handler;
    protected FiscalPeriodTableModel modelFiscalPeriodTable;
    protected Boolean selectedPeriod;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FiscalPeriodView $Table0 = this;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        
        void $afterCompleteSetup() {
            getHandler().refresh();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FiscalPeriodView() {
        $initialize();
    }

    public FiscalPeriodView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFiscalPeriod();
    }

    public void doActionPerformed__on__blockButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().blockFiscalPeriod();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedPeriod(fiscalPeriodTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JButton getBlockButton() {
        return blockButton;
    }

    public FiscalPeriodTable getFiscalPeriodTable() {
        return fiscalPeriodTable;
    }

    public FiscalPeriodViewHandler getHandler() {
        return handler;
    }

    public FiscalPeriodTableModel getModelFiscalPeriodTable() {
        return modelFiscalPeriodTable;
    }

    public Boolean getSelectedPeriod() {
        return selectedPeriod;
    }

    public Boolean isSelectedPeriod() {
        return selectedPeriod !=null && selectedPeriod;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(FiscalPeriodViewHandler handler) {
        FiscalPeriodViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedPeriod(Boolean selectedPeriod) {
        Boolean oldValue = this.selectedPeriod;
        this.selectedPeriod = selectedPeriod;
        firePropertyChange(PROPERTY_SELECTED_PERIOD, oldValue, selectedPeriod);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setText(_("lima.charts.fiscalperiod.add"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createBlockButton() {
        $objectMap.put("blockButton", blockButton = new JButton());
        
        blockButton.setName("blockButton");
        blockButton.setText(_("lima.charts.fiscalperiod.block"));
        blockButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__blockButton"));
    }

    protected void createFiscalPeriodTable() {
        $objectMap.put("fiscalPeriodTable", fiscalPeriodTable = new FiscalPeriodTable(getHandler()));
        
        fiscalPeriodTable.setName("fiscalPeriodTable");
        fiscalPeriodTable.setColumnControlVisible(true);
        fiscalPeriodTable.setRowHeight(24);
        fiscalPeriodTable.setSortable(false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FiscalPeriodViewHandler(this));
    }

    protected void createModelFiscalPeriodTable() {
        $objectMap.put("modelFiscalPeriodTable", modelFiscalPeriodTable = new FiscalPeriodTableModel());
    }

    protected void createSelectedPeriod() {
        $objectMap.put("selectedPeriod", selectedPeriod = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JScrollPane0, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(blockButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fiscalPeriodTable);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        fiscalPeriodTable.setModel(getModelFiscalPeriodTable());
        fiscalPeriodTable.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedPeriod();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createModelFiscalPeriodTable();
        createFiscalPeriodTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getFiscalPeriodTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createAddButton();
        createBlockButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLOCK_BUTTON_ENABLED, true ,"selectedPeriod") {
        
            @Override
            public void processDataBinding() {
                blockButton.setEnabled(isSelectedPeriod());
            }
        });
    }

}