/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.FinancialStatementWayEnum;
import org.chorem.lima.enums.ComboBoxAccountsEnum;
import org.chorem.lima.enums.ComboBoxEntryBooksEnum;
import org.chorem.lima.enums.ComboBoxLetterEnum;
import org.chorem.lima.enums.ComboBoxOperatorsEnum;
import org.chorem.lima.enums.ComboBoxPeriodEnum;
import static org.nuiton.i18n.I18n._;

public class FinancialTransactionSearchView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACCOUNT_COMBO_BOX = "accountComboBox";
    public static final String PROPERTY_AMOUNT_COMBO_BOX = "amountComboBox";
    public static final String PROPERTY_ENTRY_BOOK_COMBO_BOX = "entryBookComboBox";
    public static final String PROPERTY_FIELD_SIZE = "fieldSize";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_LETTER_COMBO_BOX = "letterComboBox";
    public static final String PROPERTY_OPERATOR_COMBO_BOX = "operatorComboBox";
    public static final String PROPERTY_PERIOD_COMBO_BOX = "periodComboBox";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WTW8bRRiemDqJY5J+mKatKBDaBYQE67Qp4pCKfDRYaXBKFUel4EvHu5N4wu7OdmY23nBA/AR+Aty5IHHjhDhw5sAF8RcQ4sC14p1Z2+vJbmxHSQ4ba+Z5n/eZZ96ZeX/4GxUFR28e4Di2eRRI6hN7a+3p009bB8SRG0Q4nIaScZT8TRRQoYnKbn9cSHS7WVfh1W549QHzQxaQYCB6uY5mhDzyiGgTIiV6zYxwhKg2+tPLcRjxHmtfVB7rd//+U/jW/eb7AkJxCOosWMrCqKh0JRfqqEBdia5ApkNc9XCwDzI4DfZB76wae+BhIR5hnzxHX6OpOpoMMQcyiW6Nv2TNoePjUKIpaxe3PLIoUZ3xfdtpM05826M+tiNq79EABw7FnuQ4ENiRlAWCYO607VpvajedauipJ5R0wlCnmIQEbRy4HuESNc4zwWbCmuYpC+JBhRB3h3UkuqzcspWD9jpjHsFBiiztUeK5DfoVAas1DnekvQG+BQJypMCK1dDmPQyoBB0QwMGnt/WGOuAwBQF24q+dQQ6luaOmrg2F3B0NWRoNuXcM0t3uOxJdN+pSdKDKbD2nkKV+wFxIOGUuFFSLrbNYoqvKsbgbsNUbV+iFftA7Vt7mPdZMyRY+xgHxFs+lJjK0ppbuirWdt8y1TVtbddzSOq4Yq9KjCvRuSnPIIqetynjegO6SWNZUPZnwGWuDORFUlATyG4MREgLs3mSY0aIr432TrH+9wWrV0OJJuXTwUko658HlRvjgJr1lxlasuoaYu7Jyul3JUByzLtmBpZwduIgdh0EJZhSu9CGvWGsJxpS4ejqJWQ4zy2Vwjx/BVfHlECnz1sc9lClm/XRi8ljMTF3L7g0p2rv9Qvkk3W/s57qZIi4xOM8YnoMhmIq15mcNP2VNZCjMHOVDuJ+6hxYyGkdqPZIyKfR01bPWFtxtzPMUF6i5ZkSkU2aUtXfiG6L93WYu8STaOa+HKSVNz+AbIzRItH2u6VXazwdOT50K2Ab1NAJOawP7Xh+0L4sA9Ry9ajwQ0BLZaUuU9iwTTVTkEQzDi9LMdlE7MJX0T9eP9U+KUM++mK/88fNfP9V6TdMM5L6aCx3o+aCZCbmqZUlV6otJxxRJ6lW3cbjcRKWkHdAN4c0cYY3uNIiDfEm7oMLtTSzaQFGc+vOXX+ef/f4SKtTQjMewW8MK/xCVZJuDC8xz43BlVSt6uTMN30tKm0QX1A0PL8p9Gng0IAtYQgvXiiT5KAYbbubY0NfSKv32X6Xx42rPigmQduNEeGpH8Qs0mWTTHWS3OcztGMuhIJHL0iYwry2cUP/fC7tFfKC/Qd5ayz4NqB/5STM1d9/FEi+0aOBCXcFyVRzX61C/pKatjqRVw6H6PM9n+GAsBn2zHeUzfHhmDY/OzPDZGPYWfXUahyzk2RgkJc46m4Tut+UQNeMQzYrBS+KMqqYF47J3Xw0R9T/1xSYJEQ4AAA==";
    public static final String PROPERTY$FINANCIAL_TRANSACTION_PERIOD_SEARCH_PANEL0 = "$FinancialTransactionPeriodSearchPanel0";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$LETTER_SEARCH_PANEL0 = "$LetterSearchPanel0";
    public static final String PROPERTY$ACCOUNT_SEARCH_PANEL0 = "$AccountSearchPanel0";
    public static final String PROPERTY$ENTRY_BOOK_SEARCH_PANEL0 = "$EntryBookSearchPanel0";
    public static final String PROPERTY$AMOUNT_SEARCH_PANEL0 = "$AmountSearchPanel0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox accountComboBox;
    protected JComboBox amountComboBox;
    protected JTextField description;
    protected JComboBox entryBookComboBox;
    protected Dimension fieldSize;
    protected FinancialTransactionSearchTable financialTransactionSearchTable;
    protected FinancialTransactionSearchTableModel financialTransactionSearchTableModel;
    protected FinancialTransactionSearchViewHandler handler;
    protected JComboBox letterComboBox;
    protected JComboBox operatorComboBox;
    protected JComboBox periodComboBox;
    protected Boolean selectedRow;
    protected JButton validSearch;
    protected JTextField voucher;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialTransactionSearchView $Table0 = this;
    private Table $Table1;
    private FinancialTransactionPeriodSearchPanel $FinancialTransactionPeriodSearchPanel0;
    private Table $Table2;
    private JLabel $JLabel0;
    private Document $Document0;
    private JLabel $JLabel1;
    private Document $Document1;
    private LetterSearchPanel $LetterSearchPanel0;
    private Table $Table3;
    private AccountSearchPanel $AccountSearchPanel0;
    private EntryBookSearchPanel $EntryBookSearchPanel0;
    private Table $Table4;
    private JLabel $JLabel2;
    private AmountSearchPanel $AmountSearchPanel0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    AccountSearchPanel accountSearchPanel;
    AmountSearchPanel amountSearchPanel;
    EntryBookSearchPanel entryBookSearchPanel;
    LetterSearchPanel letterSearchPanel;
    FinancialTransactionPeriodSearchPanel periodSearchPanel;
    
        
            void $afterCompleteSetup() {
            handler.setAmountWayEnum(FinancialStatementWayEnum.valueOfDescription(
                    (String) getAmountComboBox().getSelectedItem()));
            handler.setOperator(ComboBoxOperatorsEnum.valueOfDescription(
                    (String) getOperatorComboBox().getSelectedItem()).getSymbol());
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionSearchView() {
        $initialize();
    }

    public FinancialTransactionSearchView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__accountComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accountSearchPanel.refresh(ComboBoxAccountsEnum.valueOfDescription((String) accountComboBox.getSelectedItem()));              validate(); repaint();
    }

    public void doActionPerformed__on__amountComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAmountWayEnum(FinancialStatementWayEnum.valueOfDescription((String)amountComboBox.getSelectedItem()));          handler.refresh();
    }

    public void doActionPerformed__on__entryBookComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        entryBookSearchPanel.refresh(ComboBoxEntryBooksEnum.valueOfDescription((String) entryBookComboBox.getSelectedItem()));                 validate(); repaint();
    }

    public void doActionPerformed__on__letterComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        letterSearchPanel.refresh(ComboBoxLetterEnum.valueOfDescription((String) letterComboBox.getSelectedItem()));                 validate(); repaint();
    }

    public void doActionPerformed__on__operatorComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        amountSearchPanel.refresh(ComboBoxOperatorsEnum.valueOfDescription((String) operatorComboBox.getSelectedItem()));          validate(); repaint();
    }

    public void doActionPerformed__on__periodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        periodSearchPanel.refresh(ComboBoxPeriodEnum.valueOfDescription((String) periodComboBox.getSelectedItem()));              validate(); repaint();
    }

    public void doActionPerformed__on__validSearch(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.refresh();
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDescription(description.getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDescription(description.getText());
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setVoucher(voucher.getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setVoucher(voucher.getText());
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(financialTransactionSearchTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox getAccountComboBox() {
        return accountComboBox;
    }

    public JComboBox getAmountComboBox() {
        return amountComboBox;
    }

    public JTextField getDescription() {
        return description;
    }

    public JComboBox getEntryBookComboBox() {
        return entryBookComboBox;
    }

    public Dimension getFieldSize() {
        return fieldSize;
    }

    public FinancialTransactionSearchTable getFinancialTransactionSearchTable() {
        return financialTransactionSearchTable;
    }

    public FinancialTransactionSearchTableModel getFinancialTransactionSearchTableModel() {
        return financialTransactionSearchTableModel;
    }

    public FinancialTransactionSearchViewHandler getHandler() {
        return handler;
    }

    public JComboBox getLetterComboBox() {
        return letterComboBox;
    }

    public JComboBox getOperatorComboBox() {
        return operatorComboBox;
    }

    public JComboBox getPeriodComboBox() {
        return periodComboBox;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JButton getValidSearch() {
        return validSearch;
    }

    public JTextField getVoucher() {
        return voucher;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$FinancialTransactionPeriodSearchPanel0(FinancialTransactionPeriodSearchPanel $FinancialTransactionPeriodSearchPanel0) {
        FinancialTransactionPeriodSearchPanel oldValue = this.$FinancialTransactionPeriodSearchPanel0;
        this.$FinancialTransactionPeriodSearchPanel0 = $FinancialTransactionPeriodSearchPanel0;
        firePropertyChange(PROPERTY$FINANCIAL_TRANSACTION_PERIOD_SEARCH_PANEL0, oldValue, $FinancialTransactionPeriodSearchPanel0);
    }

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$LetterSearchPanel0(LetterSearchPanel $LetterSearchPanel0) {
        LetterSearchPanel oldValue = this.$LetterSearchPanel0;
        this.$LetterSearchPanel0 = $LetterSearchPanel0;
        firePropertyChange(PROPERTY$LETTER_SEARCH_PANEL0, oldValue, $LetterSearchPanel0);
    }

    public void set$AccountSearchPanel0(AccountSearchPanel $AccountSearchPanel0) {
        AccountSearchPanel oldValue = this.$AccountSearchPanel0;
        this.$AccountSearchPanel0 = $AccountSearchPanel0;
        firePropertyChange(PROPERTY$ACCOUNT_SEARCH_PANEL0, oldValue, $AccountSearchPanel0);
    }

    public void set$EntryBookSearchPanel0(EntryBookSearchPanel $EntryBookSearchPanel0) {
        EntryBookSearchPanel oldValue = this.$EntryBookSearchPanel0;
        this.$EntryBookSearchPanel0 = $EntryBookSearchPanel0;
        firePropertyChange(PROPERTY$ENTRY_BOOK_SEARCH_PANEL0, oldValue, $EntryBookSearchPanel0);
    }

    public void set$AmountSearchPanel0(AmountSearchPanel $AmountSearchPanel0) {
        AmountSearchPanel oldValue = this.$AmountSearchPanel0;
        this.$AmountSearchPanel0 = $AmountSearchPanel0;
        firePropertyChange(PROPERTY$AMOUNT_SEARCH_PANEL0, oldValue, $AmountSearchPanel0);
    }

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setAccountComboBox(JComboBox accountComboBox) {
        JComboBox oldValue = this.accountComboBox;
        this.accountComboBox = accountComboBox;
        firePropertyChange(PROPERTY_ACCOUNT_COMBO_BOX, oldValue, accountComboBox);
    }

    public void setAmountComboBox(JComboBox amountComboBox) {
        JComboBox oldValue = this.amountComboBox;
        this.amountComboBox = amountComboBox;
        firePropertyChange(PROPERTY_AMOUNT_COMBO_BOX, oldValue, amountComboBox);
    }

    public void setEntryBookComboBox(JComboBox entryBookComboBox) {
        JComboBox oldValue = this.entryBookComboBox;
        this.entryBookComboBox = entryBookComboBox;
        firePropertyChange(PROPERTY_ENTRY_BOOK_COMBO_BOX, oldValue, entryBookComboBox);
    }

    public void setFieldSize(Dimension fieldSize) {
        Dimension oldValue = this.fieldSize;
        this.fieldSize = fieldSize;
        firePropertyChange(PROPERTY_FIELD_SIZE, oldValue, fieldSize);
    }

    public void setHandler(FinancialTransactionSearchViewHandler handler) {
        FinancialTransactionSearchViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setLetterComboBox(JComboBox letterComboBox) {
        JComboBox oldValue = this.letterComboBox;
        this.letterComboBox = letterComboBox;
        firePropertyChange(PROPERTY_LETTER_COMBO_BOX, oldValue, letterComboBox);
    }

    public void setOperatorComboBox(JComboBox operatorComboBox) {
        JComboBox oldValue = this.operatorComboBox;
        this.operatorComboBox = operatorComboBox;
        firePropertyChange(PROPERTY_OPERATOR_COMBO_BOX, oldValue, operatorComboBox);
    }

    public void setPeriodComboBox(JComboBox periodComboBox) {
        JComboBox oldValue = this.periodComboBox;
        this.periodComboBox = periodComboBox;
        firePropertyChange(PROPERTY_PERIOD_COMBO_BOX, oldValue, periodComboBox);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table1() {
        return $Table1;
    }

    protected FinancialTransactionPeriodSearchPanel get$FinancialTransactionPeriodSearchPanel0() {
        return $FinancialTransactionPeriodSearchPanel0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected LetterSearchPanel get$LetterSearchPanel0() {
        return $LetterSearchPanel0;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected AccountSearchPanel get$AccountSearchPanel0() {
        return $AccountSearchPanel0;
    }

    protected EntryBookSearchPanel get$EntryBookSearchPanel0() {
        return $EntryBookSearchPanel0;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected AmountSearchPanel get$AmountSearchPanel0() {
        return $AmountSearchPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountComboBox() {
        $objectMap.put("accountComboBox", accountComboBox = new JComboBox(ComboBoxAccountsEnum.descriptions()));
        
        accountComboBox.setName("accountComboBox");
        accountComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__accountComboBox"));
    }

    protected void createAmountComboBox() {
        $objectMap.put("amountComboBox", amountComboBox = new JComboBox(FinancialStatementWayEnum.descriptions()));
        
        amountComboBox.setName("amountComboBox");
        amountComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__amountComboBox"));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JTextField());
        
        description.setName("description");
        description.setColumns(15);
    }

    protected void createEntryBookComboBox() {
        $objectMap.put("entryBookComboBox", entryBookComboBox = new JComboBox(ComboBoxEntryBooksEnum.descriptions()));
        
        entryBookComboBox.setName("entryBookComboBox");
        entryBookComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__entryBookComboBox"));
    }

    protected void createFieldSize() {
        $objectMap.put("fieldSize", fieldSize = new java.awt.Dimension());
    }

    protected void createFinancialTransactionSearchTable() {
        $objectMap.put("financialTransactionSearchTable", financialTransactionSearchTable = new FinancialTransactionSearchTable(getHandler()));
        
        financialTransactionSearchTable.setName("financialTransactionSearchTable");
        financialTransactionSearchTable.setRowHeight(22);
        financialTransactionSearchTable.setSortable(false);
    }

    protected void createFinancialTransactionSearchTableModel() {
        $objectMap.put("financialTransactionSearchTableModel", financialTransactionSearchTableModel = new FinancialTransactionSearchTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionSearchViewHandler(this));
    }

    protected void createLetterComboBox() {
        $objectMap.put("letterComboBox", letterComboBox = new JComboBox(ComboBoxLetterEnum.descriptions()));
        
        letterComboBox.setName("letterComboBox");
        letterComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__letterComboBox"));
    }

    protected void createOperatorComboBox() {
        $objectMap.put("operatorComboBox", operatorComboBox = new JComboBox(ComboBoxOperatorsEnum.descriptions()));
        
        operatorComboBox.setName("operatorComboBox");
        operatorComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__operatorComboBox"));
    }

    protected void createPeriodComboBox() {
        $objectMap.put("periodComboBox", periodComboBox = new JComboBox(ComboBoxPeriodEnum.descriptions()));
        
        periodComboBox.setName("periodComboBox");
        periodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__periodComboBox"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createValidSearch() {
        $objectMap.put("validSearch", validSearch = new JButton());
        
        validSearch.setName("validSearch");
        validSearch.setText(_("lima.common.search"));
        validSearch.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validSearch"));
    }

    protected void createVoucher() {
        $objectMap.put("voucher", voucher = new JTextField());
        
        voucher.setName("voucher");
        voucher.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(validSearch, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(periodComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($FinancialTransactionPeriodSearchPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(voucher, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(description, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(letterComboBox, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($LetterSearchPanel0, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add(accountComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($AccountSearchPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(entryBookComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($EntryBookSearchPanel0, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table4
        $Table4.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(amountComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(operatorComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($AmountSearchPanel0, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionSearchTable);
        
        // apply 4 property setters
        voucher.setMinimumSize(voucher.getPreferredSize());
        description.setMinimumSize(description.getPreferredSize());
        financialTransactionSearchTable.setModel(getFinancialTransactionSearchTableModel());
        financialTransactionSearchTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        createFieldSize();
        accountSearchPanel = new AccountSearchPanel(handler);
        amountSearchPanel = new AmountSearchPanel(handler);
        entryBookSearchPanel = new EntryBookSearchPanel(handler);
        letterSearchPanel = new LetterSearchPanel(handler);
        periodSearchPanel = new FinancialTransactionPeriodSearchPanel(handler);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createPeriodComboBox();
        // inline creation of $FinancialTransactionPeriodSearchPanel0
        $objectMap.put("$FinancialTransactionPeriodSearchPanel0", $FinancialTransactionPeriodSearchPanel0 = periodSearchPanel);
        
        $FinancialTransactionPeriodSearchPanel0.setName("$FinancialTransactionPeriodSearchPanel0");
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.table.voucher"));
        createVoucher();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = voucher.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.table.description"));
        createDescription();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = description.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        createLetterComboBox();
        // inline creation of $LetterSearchPanel0
        $objectMap.put("$LetterSearchPanel0", $LetterSearchPanel0 = letterSearchPanel);
        
        $LetterSearchPanel0.setName("$LetterSearchPanel0");
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createAccountComboBox();
        // inline creation of $AccountSearchPanel0
        $objectMap.put("$AccountSearchPanel0", $AccountSearchPanel0 = accountSearchPanel);
        
        $AccountSearchPanel0.setName("$AccountSearchPanel0");
        createEntryBookComboBox();
        // inline creation of $EntryBookSearchPanel0
        $objectMap.put("$EntryBookSearchPanel0", $EntryBookSearchPanel0 = entryBookSearchPanel);
        
        $EntryBookSearchPanel0.setName("$EntryBookSearchPanel0");
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.common.amount"));
        createAmountComboBox();
        createOperatorComboBox();
        // inline creation of $AmountSearchPanel0
        $objectMap.put("$AmountSearchPanel0", $AmountSearchPanel0 = amountSearchPanel);
        
        $AmountSearchPanel0.setName("$AmountSearchPanel0");
        createValidSearch();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionSearchTableModel();
        createFinancialTransactionSearchTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getFinancialTransactionSearchTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}