/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.financialtransaction;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxRenderer;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import static org.nuiton.i18n.I18n._;

public class FinancialTransactionView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON4_ENABLED = "$JButton4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW8cRRAtb7K2N8aExI4TCxM5YRGKoswmIUggR4ljo43jrCHKRiHK5pCemV5vh97uSXcNO1wQP4GfAHcuSNw4IQ6cOXBB/AWEOHBFdM9+zI4zngyZPcyOql69flXTVfXdn1DVCs49I1HkqFAg61Nn99ajR5+4z6iHH1HtKRagVDD8zVSg0oEFf2LXCG93Wja8MQpvbMt+IAUVU9EbLTim8QtOdY9SRHgrHeFp3WhP3BtREKox60RUFus3f/9V+dr/6tsKQBQYdcsmlfWXRSWZHG1BhfkIJ81Jn5MGJ2LfyFBM7Bu9i9a2zYnWH5M+fQ5fwlwLZgOiDBnC+eIpxxxxfBQgzNUfEJfTywibUu07Xk8q2nc46xMnZE6XCSI8RjgqIjTxkEnhNMfGB4nxIaODIIhpZw1pjwifU4VwuyzpzpAp4V7QlJubQP37coBwwlbFsZVytqTklIgEeaLLtEf4PaqY9FvEpdyU1uIjRw9MUZ3d2GjRtSSoL33Km1ORCO9nJOHJvitdGTnT0G1r3JLRnuVIhCx3MzAIp1Jaxva0nOVJsabSsL7lA7iR7BQY4YN85Sn0IeJPd7NhCDf/97dNM6QzOOoS7zOEpVRRtkJEKQ4ABY3Qvr+TttfqI/jlPOeVPOfVPOd7ec5rGc7F+m7bU5Lze0TYBjudSi1xpaPOdjM6Ie7R+MMgNMu0VEKUfOHVQ09EuFX6MHvI1eSe1ltMYztuYYOIlZjSnJ0uzYsIo1XBm6lBaka0k4zoZIbOdKCqQmNGONN5carfN67hPD9zYJ5bwtj778rSbz/+8UNzPMRXzNmnMqFTO8gM10DJwIw8Zo8+PpzgITLe2CPBRgdqw7EVL6i1DGHtkduIM+cNx5oNd3aI7hmK6tzvP/288vTXI1BpwjEuid8kFn8HathTpgqS+1FwczNW9Npg3jzfsNpMv6DpFzP5rjPBmaDrBM1KcUOkNyJThrWMMky0uLVf/llqf785LsWMkbZ6KDwpR/UxzA5PizfaaFllbrCFQNPQl8lSylpTM/Z/KRhd2e34eTsr13nqMxzfut0otH93Y+H2bS/mWS3AU+0Pe+316z5Bsu4y4ZubeePVCefNmvaposoiPn1VHmu+k5PaWiGGhzkazhVieFKaIS+LemmGdwt8kTkq7EXxc1K5UFpIMYYwR8PF0hrKM1wqnUWjtIZiDHkarpTWUIwhr70+LHAxa0oOdijb72GOlCJEi3p6iZZUNa+letlktTz/AQBgXrvBDQAA";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FinancialTransactionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton back;
    protected FinancialPeriodComboBox financialPeriodComboBox;
    protected JLabel financialPeriodLabel;
    protected FinancialTransactionTable financialTransactionTable;
    protected FinancialTransactionTableModel financialTransactionTableModel;
    protected JComboBox fiscalPeriodComboBox;
    protected JLabel fiscalPeriodLabel;
    protected FinancialTransactionViewHandler handler;
    protected FinancialPeriodComboBoxModel modelFinancialPeriod;
    protected FiscalPeriodComboBoxModel modelFiscalPeriod;
    protected JButton next;
    protected Boolean selectedRow;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialTransactionView $Table0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        
        void $afterCompleteSetup() {
            getHandler().refresh();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionView() {
        $initialize();
    }

    public FinancialTransactionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteSelectedRow();
    }

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().copyRow();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().pasteRow();
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFinancialTransaction();
    }

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        financialPeriodComboBox.back();
    }

    public void doActionPerformed__on__financialPeriodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        financialTransactionTableModel.setFinancialPeriod((FinancialPeriod)financialPeriodComboBox.getSelectedItem());
    }

    public void doActionPerformed__on__fiscalPeriodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getModelFinancialPeriod().setFiscalPeriod((FiscalPeriod)fiscalPeriodComboBox.getSelectedItem());
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        financialPeriodComboBox.next();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(financialTransactionTable.getSelectedRow() != -1);
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addEmptyEntry();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getBack() {
        return back;
    }

    public FinancialPeriodComboBox getFinancialPeriodComboBox() {
        return financialPeriodComboBox;
    }

    public JLabel getFinancialPeriodLabel() {
        return financialPeriodLabel;
    }

    public FinancialTransactionTable getFinancialTransactionTable() {
        return financialTransactionTable;
    }

    public FinancialTransactionTableModel getFinancialTransactionTableModel() {
        return financialTransactionTableModel;
    }

    public JComboBox getFiscalPeriodComboBox() {
        return fiscalPeriodComboBox;
    }

    public JLabel getFiscalPeriodLabel() {
        return fiscalPeriodLabel;
    }

    public FinancialTransactionViewHandler getHandler() {
        return handler;
    }

    public FinancialPeriodComboBoxModel getModelFinancialPeriod() {
        return modelFinancialPeriod;
    }

    public FiscalPeriodComboBoxModel getModelFiscalPeriod() {
        return modelFiscalPeriod;
    }

    public JButton getNext() {
        return next;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(FinancialTransactionViewHandler handler) {
        FinancialTransactionViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setText(_("lima.common.buttonback"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createFinancialPeriodComboBox() {
        $objectMap.put("financialPeriodComboBox", financialPeriodComboBox = new FinancialPeriodComboBox(getHandler()));
        
        financialPeriodComboBox.setName("financialPeriodComboBox");
        financialPeriodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__financialPeriodComboBox"));
    }

    protected void createFinancialPeriodLabel() {
        $objectMap.put("financialPeriodLabel", financialPeriodLabel = new JLabel());
        
        financialPeriodLabel.setName("financialPeriodLabel");
        financialPeriodLabel.setText(_("lima.common.period"));
    }

    protected void createFinancialTransactionTable() {
        $objectMap.put("financialTransactionTable", financialTransactionTable = new FinancialTransactionTable(getHandler()));
        
        financialTransactionTable.setName("financialTransactionTable");
        financialTransactionTable.setRowHeight(22);
        financialTransactionTable.setSortable(false);
    }

    protected void createFinancialTransactionTableModel() {
        $objectMap.put("financialTransactionTableModel", financialTransactionTableModel = new FinancialTransactionTableModel());
    }

    protected void createFiscalPeriodComboBox() {
        $objectMap.put("fiscalPeriodComboBox", fiscalPeriodComboBox = new JComboBox());
        
        fiscalPeriodComboBox.setName("fiscalPeriodComboBox");
        fiscalPeriodComboBox.setEditable(false);
        fiscalPeriodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fiscalPeriodComboBox"));
    }

    protected void createFiscalPeriodLabel() {
        $objectMap.put("fiscalPeriodLabel", fiscalPeriodLabel = new JLabel());
        
        fiscalPeriodLabel.setName("fiscalPeriodLabel");
        fiscalPeriodLabel.setText(_("lima.charts.fiscalyear"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionViewHandler(this));
    }

    protected void createModelFinancialPeriod() {
        $objectMap.put("modelFinancialPeriod", modelFinancialPeriod = new FinancialPeriodComboBoxModel());
    }

    protected void createModelFiscalPeriod() {
        $objectMap.put("modelFiscalPeriod", modelFiscalPeriod = new FiscalPeriodComboBoxModel());
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setText(_("lima.common.buttonnext"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(fiscalPeriodLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(fiscalPeriodComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(financialPeriodLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(financialPeriodComboBox, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(back, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(next, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton1, new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton2, new GridBagConstraints(8, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton3, new GridBagConstraints(9, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton4, new GridBagConstraints(10, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 11, 3, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionTable);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        fiscalPeriodComboBox.setModel(getModelFiscalPeriod());
        fiscalPeriodComboBox.setRenderer(new org.chorem.lima.ui.combobox.FiscalPeriodComboBoxRenderer());
        financialPeriodComboBox.setModel(getModelFinancialPeriod());
        financialPeriodComboBox.setRenderer(new FinancialPeriodComboBoxRenderer());
        financialTransactionTable.setModel(getFinancialTransactionTableModel());
        financialTransactionTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        createFiscalPeriodLabel();
        createModelFiscalPeriod();
        createFiscalPeriodComboBox();
        createFinancialPeriodLabel();
        createModelFinancialPeriod();
        createFinancialPeriodComboBox();
        createBack();
        createNext();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.copy"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("lima.common.paste"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("lima.entries.addTransaction"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("lima.entries.addEntry"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("lima.common.remove"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionTableModel();
        createFinancialTransactionTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getFinancialTransactionTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON4_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                $JButton4.setEnabled(isSelectedRow());
            }
        });
    }

}