/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.financialstatementchart;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.EnumEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.FinancialStatementWayEnum;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import static org.nuiton.i18n.I18n._;

public class FinancialStatementHeaderForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_FINANCIAL_STATEMENT = "financialStatement";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_HEADER_AMOUNT_CHECK_BOX_SELECTED = "headerAmountCheckBox.selected";
    public static final String BINDING_SUB_AMOUNT_CHECK_BOX_SELECTED = "subAmountCheckBox.selected";
    public static final String BINDING_WAY_ENUM_EDITOR_SELECTED_ITEM = "wayEnumEditor.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRSeVgq0gApIAxFjxSb+OGw5mGiEyI+WCqRIYjkQe3G6O7QDszvr7KwsF+Of4J+gdy8m3jwZD549eDH+C8Z48Gp8s9vtsrBAE3rYbt573/e+92be2/e/UMYR6MYu9jxNuJakJtHWl7a3N5u7RJcV4uiC2pILFPxSaZRuoCGja3ckutmoKXipAy+VuWlzi1iH0HM1lHPkASNOmxAp0bU4QnecUr3rnvNsV4SsXVFJrG///E6/MV6/SyPk2aBuGEopnIWKKumroTQ1JBqDTC9xiWGrBTIEtVqgd0TZygw7zhNskhfoFRqooX4bCyCTaKb3kn0OH+/ZEmWL6xWKGW/NSvSYi5amt7kgpsaoiTWXajvUwpYOEY7EkphAqbexkFo1tNdD+yrBBhFVLkzb9vn7oZKdY2ES3TmaBqxUHiRQRkSD2DB8s0SjqhGaao62zDkj2IrCBopbuMkI1DIZa7uzD03UfJ+KzEa8xfUabhIGiDHF63VCA6sKGuvGXglvGeXWFvFklRIGp5WP4bqOODZXrHDdVTVBpqnDCAkALXRGlYw6bnPJ5KC/3Cb63jL3JJqIZQrtR0S2/WOIQ5WvEI8b2ccHK5ZrrhgULodExYR+Ed+nRWFxCrg6y66U3IKSxmPSAnM8Os331NvtjlWgq7GMMHJaNHLRTKQaKCNcMMORNo5P6VNwBfM5eWQ+FaHv/Zcf//7p58dqOJRDkHsiMfTQToFhsQW3iZBUpb4UTKQrKSttYHuugbIOYbCQ/IUznSCs3nGDOMgX3FkF11ax0waKzMCPz1/yz79dQOkqyjGOjSpW8WsoK9sCusCZ4dkLi76i4f1BeF5W2uAWGGQHu0yWGXfIJkjE6kJKdHHewBIXmtQy4BAeedCT6YSedIU1s1//jtc/LIZ9SYHOqRPDo95knqF+ajFqEX9ddTZR4noash3iGjzaOEk7KKX+c3bn6s/6z3tJhWdMbmAGgzofpC9gCcux6UoCxSrUA78K9fawZ9I+NX/Ku5DMkT+TQ5kr6nE/mWGqBxWDwW0ixik813tXckItvTFsnKJh5twazmaQ8NnsdGMNPgOnqCmeW82tczPcBYb/7zgsprUIAAA=";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    private static final Log log = LogFactory.getLog(FinancialStatementHeaderForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean addState;
    protected JTextField descriptionTextField;
    protected FinancialStatement financialStatement;
    protected JCheckBox headerAmountCheckBox;
    protected JButton ok;
    protected JCheckBox subAmountCheckBox;
    protected EnumEditor wayEnumEditor;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialStatementHeaderForm $JDialog0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private Document $Document0;
    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        
        
        protected void getFinancialStatementWayValue(){
        
            FinancialStatementWayEnum fSWE =
                (FinancialStatementWayEnum) wayEnumEditor.getSelectedItem();
    
            if (fSWE == null){
                fSWE = FinancialStatementWayEnum.BOTH;
            }
            getFinancialStatement().setWay(fSWE);
        }
        protected void performCancel() {
            setFinancialStatement(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementHeaderForm() {
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__headerAmountCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setHeaderAmount(headerAmountCheckBox.isSelected());
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__subAmountCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setSubAmount(subAmountCheckBox.isSelected());
    }

    public void doActionPerformed__on__wayEnumEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatementWayValue();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setLabel(getDescriptionTextField().getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setLabel(getDescriptionTextField().getText());
    }

    public void doWindowClosing__on__$JDialog0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public FinancialStatement getFinancialStatement() {
        return financialStatement;
    }

    public JCheckBox getHeaderAmountCheckBox() {
        return headerAmountCheckBox;
    }

    public JButton getOk() {
        return ok;
    }

    public JCheckBox getSubAmountCheckBox() {
        return subAmountCheckBox;
    }

    public EnumEditor getWayEnumEditor() {
        return wayEnumEditor;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setFinancialStatement(FinancialStatement financialStatement) {
        FinancialStatement oldValue = this.financialStatement;
        this.financialStatement = financialStatement;
        firePropertyChange(PROPERTY_FINANCIAL_STATEMENT, oldValue, financialStatement);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createFinancialStatement() {
        $objectMap.put("financialStatement", financialStatement = null);
    }

    protected void createHeaderAmountCheckBox() {
        $objectMap.put("headerAmountCheckBox", headerAmountCheckBox = new JCheckBox());
        
        headerAmountCheckBox.setName("headerAmountCheckBox");
        headerAmountCheckBox.setText(_("lima.financialstatement.headeramount"));
        headerAmountCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__headerAmountCheckBox"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(_("lima.common.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createSubAmountCheckBox() {
        $objectMap.put("subAmountCheckBox", subAmountCheckBox = new JCheckBox());
        
        subAmountCheckBox.setName("subAmountCheckBox");
        subAmountCheckBox.setText(_("lima.financialstatement.subamount"));
        subAmountCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__subAmountCheckBox"));
    }

    protected void createWayEnumEditor() {
        $objectMap.put("wayEnumEditor", wayEnumEditor = new EnumEditor(org.chorem.lima.FinancialStatementWayEnum.class));
        
        wayEnumEditor.setName("wayEnumEditor");
        wayEnumEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__wayEnumEditor"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(subAmountCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(headerAmountCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(wayEnumEditor, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createFinancialStatement();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.financialstatement.label"));
        createDescriptionTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getDescriptionTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createSubAmountCheckBox();
        createHeaderAmountCheckBox();
        createWayEnumEditor();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        $JDialog0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JDialog0"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("label", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(descriptionTextField, getFinancialStatement().getLabel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("label", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_AMOUNT_CHECK_BOX_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("subAmount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    subAmountCheckBox.setSelected(getFinancialStatement().getSubAmount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("subAmount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HEADER_AMOUNT_CHECK_BOX_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("headerAmount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    headerAmountCheckBox.setSelected(getFinancialStatement().getHeaderAmount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("headerAmount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WAY_ENUM_EDITOR_SELECTED_ITEM, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().addPropertyChangeListener("way", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    wayEnumEditor.setSelectedItem(getFinancialStatement().getWay());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getFinancialStatement() != null) {
                    getFinancialStatement().removePropertyChangeListener("way", this);
                }
            }
        });
    }

}