/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.entrybook;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class EntryBookView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVkotBVFQxAgKwkWNW4gXE4giKEFSf1FDiL047U66g9OZcWaWLhfjn+CfoHcvJt48GQ+ePXgx/gvGePBqfLPbdluopYEm3Z3Me98333v7vXn3E6W0QtPbOAgc5XNDq8RZv7219bC0TcrmDtFlRaURCkW/RBIliyjrNve1QTPFvIXn6vDciqhKwQlvQS/k0YA2u4xojxBj0GQ7oqx1rtAMLwTSVw3WpqhOrG9+/0q+dl+9TSIUSFA3AKVMHYSKK+nLoyR1DRqBk3ZwjmFeARmK8groHbJ7Kwxr/QBXyQv0EqXzqF9iBWQGXeq95JAjxAfSoPTsE1xiZM6gK0JVnLInFKk6jFax41MHGNRuSYjnzl27WobVJiU1KUOCfoB7mLuMKIPme4evRZiYJasJg69L3A1RM+iUrdSx1TuAYATzOHNodr1QVoKxR5hb0WdtbuDoGjTJaQnZ9EwTNUwax+uwWoOu9qY2zLYkI02u07N5qk0hFEwFvy9cwkDIhVYh+zPiCjLYdZd9YwQ3aLRNfbTbrnzQly42JA5N7olDAWKnS5yCEZTZH1fofJsxwfJObPnYk4kiSikftg0aL+6fkg0IRfMxvmc+LGEY/Ts2+u3jjw+rjaHIwtlnOqa2zDSYVSohwVjUHj0cTYRvKMvdx3KhiDKRZcKBn+ggrFAPgzg4L7KUhTtrWHtAkUp///R57NnXYyi5igaYwO4qtvn3UMZ4CrogmBvIW0uhosHacXietNrAAGXB/CpfgQ8IbtukmoaOGlmknFFOprCBkS35htwMoC0THdrS1FbKfPkzWni/1GhNAqSe+2963J7UU9QfnRbeGPXLoOMNkZWa+K6Ih77TNZCw7zFZN+nl8HmtU+2DHq14DP6G2MafWARz4qkS5S44GOq1wPmwELu63jNvqmqHxIZvHJ4ko0RtjVhxNmXu8ERDunV2j6iqz5Cgm6CJHjjShNuLyO0i5eKBNHY730VIbwyPu2iYPrKGozPMAMM/GOnLi0UIAAA=";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(EntryBookView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected EntryBookTable entryBooksTable;
    protected EntryBookViewHandler handler;
    protected JButton importButton;
    protected JButton removeButton;
    protected Boolean selectedRow;
    protected JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EntryBookView $Table0 = this;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntryBookView() {
        $initialize();
    }

    public EntryBookView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addEntryBook();
    }

    public void doActionPerformed__on__importButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().importEntryBooks();
    }

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteEntryBook();
    }

    public void doActionPerformed__on__updateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateEntryBook();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(entryBooksTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public EntryBookTable getEntryBooksTable() {
        return entryBooksTable;
    }

    public EntryBookViewHandler getHandler() {
        return handler;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JButton getUpdateButton() {
        return updateButton;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(EntryBookViewHandler handler) {
        EntryBookViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setText(_("lima.charts.entrybook.add"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createEntryBooksTable() {
        $objectMap.put("entryBooksTable", entryBooksTable = new EntryBookTable(getHandler()));
        
        entryBooksTable.setName("entryBooksTable");
        entryBooksTable.setColumnControlVisible(true);
        entryBooksTable.setRowHeight(24);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new EntryBookViewHandler(this));
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.setText(_("lima.importexport.import"));
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setText(_("lima.common.remove"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new JButton());
        
        updateButton.setName("updateButton");
        updateButton.setText(_("lima.common.update"));
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JScrollPane0, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(updateButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(removeButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(importButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(entryBooksTable);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        entryBooksTable.setHighlighters(org.jdesktop.swingx.decorator.HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        entryBooksTable.setModel(new org.chorem.lima.ui.entrybook.EntryBookTableModel());
        entryBooksTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createEntryBooksTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getEntryBooksTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createAddButton();
        createUpdateButton();
        createRemoveButton();
        createImportButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isSelectedRow());
            }
        });
    }

}