/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.balance;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.EnumEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import static org.nuiton.i18n.I18n._;

public class BalanceView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PERIOD_COMBO_BOX = "periodComboBox";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWTW/cRBieLN0km4+2adqQloJCa+AAeEl74JCIlmy7pKstreo0FFZCjO1RPGXsMeNx13BA/AR+Aty5IHHjhDhw5sAF8RcQ4sAV8c74a5112FVXjRRvdt73eeZ5P/y++e5P1IwEevkxThJTxIGkPjF77z56dM9+TBx5i0SOoKHkAqU/cw3UGKBltziPJLo66Ct4O4O3O9wPeUCCEfROHy1F8nNGIo8QKdGLVYQTRW2rMO8kYSxy1kJUHes3f//V+Nr96tsGQkkI6jYhlK1JqDKSU33UoK5E5+CmJ7jNcHAEMgQNjkDvqjrrMBxF72OffIa+RAt9NB9iAWQSXZk+ZM2h8Uko0YJxgG1G3pLoVS6OTMfjgvgmoz42Y2raGEQ4xNxLPw8pGYahBs8D1MOBy4iQ6M3poPupf8mwHBEGVSXuAz6UaE1FaKqozT3OGcFB6bnmc5ewjEsrluiNybdqz7sKWlKtG5ZOyZ2ASooZ/YIIFb0ukwN5oyDRTLNmjnmORJ8mbluizUqFoyHUy9Q25dkqAKdDIih3oTQ23+OJRBdUvEkG6OXnynuzAF0yskjua7BFsHC8+zggDDRfn5yAMViVftHo9bGtyc5V1OjTqv7VjLpLmVRF36gADkgiu5QwtwpaMm5xJ/ahE+GKi6MICQAzN5ZpPePzJ+qEuPk9x9LkEefTLE0juc2JbrsUel0io6YmRNvM20Hsp25VjpbR24ul5AEoXa/cmR4fy4bRg+bgjKmsAuL5CqI0VVErdqWDX5uygxX6ekFy3ujTSFr61aE80O0NCl4aVTDuMda519TXS1V9eT9sq+9X1WO3sJ3FPo/VRLGpLNrjmE+Ov1ZjW0vxHaHqcBLBUsSZS06yZhKsWh+BXqgUHYa4WQ7xcsrODVBTxHAMb+5gfO4/AFM68TePTXxFqK3/bqz/9uMfP3TzMX8a7r5Q6zqypWD8hoLDDJBUXX0mnfGxpKx9F4c7A9RKh6FeYZdrhFmZGcTBfemwVHBzH0ceUDQXfv/p541Pfn0ONbpoiXHsdrHyv4Na0hOQBchaEt64qRWtDBfheVZpk+iUehdhAuzSgNGAbGEJS8eOJXkngTRcrklDocVu/fLPuvX9zTwVcyDt4onuZTqaH6H59Da987J1VrvjlsOIxC4v11bdIptTn1fCrMnv6adVF+uyTwPqx74F0xzmxq6LJd6yaeDCWwPhKtwHOg7114ea9pVpaCVsrAMaqjGonA6fnmoxX4r/w/P6RB51/PCZMmxPEct5h7PYDzo8kDAQD2lEs2l2AufbU3CuePTIY/AL20F7ffz0XE39b8WMJC3Bh/tECZoxstVodGLPpGpS8W7MzNCZmeE9YPgP+AMIIvALAAA=";
    public static final String PROPERTY$BALANCE_PERIOD_SEARCH_PANEL0 = "$BalancePeriodSearchPanel0";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(BalanceView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected EnumEditor DocumentEditor;
    protected JLabel amountCreditLabel;
    protected JLabel amountDebitLabel;
    protected JLabel amountSoldeLabel;
    protected JTextField balanceFilter;
    protected BalanceTable balanceTable;
    protected BalanceViewHandler handler;
    protected BalanceTableModel modelBalanceTable;
    protected JCheckBox movmentedFilter;
    protected JComboBox periodComboBox;
    protected Boolean selectedRow;
    protected JLabel soldeLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BalanceView $Table0 = this;
    private Table $Table1;
    private BalancePeriodSearchPanel $BalancePeriodSearchPanel0;
    private JLabel $JLabel0;
    private Document $Document0;
    private JButton $JButton0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table2;
    private JLabel $JLabel1;
    private JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    BalancePeriodSearchPanel periodSearchPanel;
    
        
        void $afterCompleteSetup() {
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BalanceView() {
        $initialize();
    }

    public BalanceView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createDocument();
    }

    public void doActionPerformed__on__movmentedFilter(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().refresh();
    }

    public void doActionPerformed__on__periodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        periodSearchPanel.refresh(ComboBoxDatesEnum.valueOfDescription((String) periodComboBox.getSelectedItem()));                     validate(); repaint();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAccountFilter(balanceFilter.getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAccountFilter(balanceFilter.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAmountCreditLabel() {
        return amountCreditLabel;
    }

    public JLabel getAmountDebitLabel() {
        return amountDebitLabel;
    }

    public JLabel getAmountSoldeLabel() {
        return amountSoldeLabel;
    }

    public JTextField getBalanceFilter() {
        return balanceFilter;
    }

    public BalanceTable getBalanceTable() {
        return balanceTable;
    }

    public EnumEditor getDocumentEditor() {
        return DocumentEditor;
    }

    public BalanceViewHandler getHandler() {
        return handler;
    }

    public BalanceTableModel getModelBalanceTable() {
        return modelBalanceTable;
    }

    public JCheckBox getMovmentedFilter() {
        return movmentedFilter;
    }

    public JComboBox getPeriodComboBox() {
        return periodComboBox;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JLabel getSoldeLabel() {
        return soldeLabel;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$BalancePeriodSearchPanel0(BalancePeriodSearchPanel $BalancePeriodSearchPanel0) {
        BalancePeriodSearchPanel oldValue = this.$BalancePeriodSearchPanel0;
        this.$BalancePeriodSearchPanel0 = $BalancePeriodSearchPanel0;
        firePropertyChange(PROPERTY$BALANCE_PERIOD_SEARCH_PANEL0, oldValue, $BalancePeriodSearchPanel0);
    }

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(BalanceViewHandler handler) {
        BalanceViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setPeriodComboBox(JComboBox periodComboBox) {
        JComboBox oldValue = this.periodComboBox;
        this.periodComboBox = periodComboBox;
        firePropertyChange(PROPERTY_PERIOD_COMBO_BOX, oldValue, periodComboBox);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table1() {
        return $Table1;
    }

    protected BalancePeriodSearchPanel get$BalancePeriodSearchPanel0() {
        return $BalancePeriodSearchPanel0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAmountCreditLabel() {
        $objectMap.put("amountCreditLabel", amountCreditLabel = new JLabel());
        
        amountCreditLabel.setName("amountCreditLabel");
    }

    protected void createAmountDebitLabel() {
        $objectMap.put("amountDebitLabel", amountDebitLabel = new JLabel());
        
        amountDebitLabel.setName("amountDebitLabel");
    }

    protected void createAmountSoldeLabel() {
        $objectMap.put("amountSoldeLabel", amountSoldeLabel = new JLabel());
        
        amountSoldeLabel.setName("amountSoldeLabel");
    }

    protected void createBalanceFilter() {
        $objectMap.put("balanceFilter", balanceFilter = new JTextField());
        
        balanceFilter.setName("balanceFilter");
        balanceFilter.setColumns(15);
        balanceFilter.setToolTipText(_("lima.tooltip.filter"));
    }

    protected void createBalanceTable() {
        $objectMap.put("balanceTable", balanceTable = new BalanceTable(getHandler()));
        
        balanceTable.setName("balanceTable");
        balanceTable.setColumnControlVisible(true);
        balanceTable.setRowHeight(24);
    }

    protected void createDocumentEditor() {
        $objectMap.put("DocumentEditor", DocumentEditor = new EnumEditor(org.chorem.lima.business.utils.FormatsEnum.class));
        
        DocumentEditor.setName("DocumentEditor");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new BalanceViewHandler(this));
    }

    protected void createModelBalanceTable() {
        $objectMap.put("modelBalanceTable", modelBalanceTable = new BalanceTableModel());
    }

    protected void createMovmentedFilter() {
        $objectMap.put("movmentedFilter", movmentedFilter = new JCheckBox());
        
        movmentedFilter.setName("movmentedFilter");
        movmentedFilter.setSelected(false);
        movmentedFilter.setText(_("lima.common.movmentedfilter"));
        movmentedFilter.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__movmentedFilter"));
    }

    protected void createPeriodComboBox() {
        $objectMap.put("periodComboBox", periodComboBox = new JComboBox(ComboBoxDatesEnum.descriptions()));
        
        periodComboBox.setName("periodComboBox");
        periodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__periodComboBox"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSoldeLabel() {
        $objectMap.put("soldeLabel", soldeLabel = new JLabel());
        
        soldeLabel.setName("soldeLabel");
        soldeLabel.setText(_("lima.common.solde"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(balanceFilter, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(movmentedFilter, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(DocumentEditor, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 8, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 2, 7, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(periodComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($BalancePeriodSearchPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(balanceTable);
        // inline complete setup of $Table2
        $Table2.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountDebitLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountCreditLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(soldeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountSoldeLabel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 property setters
        balanceFilter.setMinimumSize(balanceFilter.getPreferredSize());
        balanceTable.setHighlighters(org.jdesktop.swingx.decorator.HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        balanceTable.setModel(getModelBalanceTable());
        balanceTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        createModelBalanceTable();
        periodSearchPanel = new BalancePeriodSearchPanel(handler);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createPeriodComboBox();
        // inline creation of $BalancePeriodSearchPanel0
        $objectMap.put("$BalancePeriodSearchPanel0", $BalancePeriodSearchPanel0 = periodSearchPanel);
        
        $BalancePeriodSearchPanel0.setName("$BalancePeriodSearchPanel0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.filter"));
        createBalanceFilter();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = balanceFilter.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createMovmentedFilter();
        createDocumentEditor();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.ok"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createBalanceTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getBalanceTable().getSelectionModel());
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.amountdebit"));
        createAmountDebitLabel();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.common.amountcredit"));
        createAmountCreditLabel();
        createSoldeLabel();
        createAmountSoldeLabel();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}