/*
 * #%L
 * Lima Swing
 * 
 * $Id: AccountViewHandler.java 3258 2011-08-10 13:27:34Z vsalaun $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5/lima-swing/src/main/java/org/chorem/lima/ui/account/AccountViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.account;

import static org.nuiton.i18n.I18n._;

import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.AccountServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.AccountImpl;
import org.chorem.lima.enums.AccountsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.account.AccountForm;
import org.chorem.lima.ui.account.AccountView;
import org.chorem.lima.ui.account.SubLedgerForm;
import org.chorem.lima.ui.account.UpdateAccountForm;
import org.chorem.lima.ui.account.UpdateSubLedgerForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.DialogHelper;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.JXTreeTable;

/**
 * Handler associated with account view.
 * 
 * @author chatellier
 * @version $Revision: 3258 $
 * 
 * Last update : $Date: 2011-08-10 15:27:34 +0200 (Wed, 10 Aug 2011) $
 * By : $Author: vsalaun $
 */
public class AccountViewHandler implements ServiceListener {

    /** log. */
    private static final Log log = LogFactory.getLog(AccountViewHandler.class);

    protected AccountView view;
    
    protected AccountServiceMonitorable accountService;
    
    protected AccountViewHandler(AccountView view) {
        this.view = view;
        // Gets factory service        
        LimaServiceFactory.getInstance().getService(
                ImportServiceMonitorable.class).addListener(this);
        accountService =
            LimaServiceFactory.getInstance().getService(
                    AccountServiceMonitorable.class);
    }

    /**
     * Add new account with account form.
     * @throws LimaException 
     */
    public void addAccount() {
        
        JXTreeTable accountsTreeTable = view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel =
            (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();

        Account newAccount = new AccountImpl();
        AccountForm accountForm = new AccountForm(view);
        accountForm.setAccount(newAccount);
        // jaxx constructor don't call super() ?
        accountForm.setLocationRelativeTo(view);
        accountForm.setVisible(true);
        
        
        // null == cancel action
        newAccount = accountForm.getAccount();
        Account parentAccount = new AccountImpl();
        if (newAccount != null) {
            //get the account number been created
            String number = newAccount.getAccountNumber();

            //search for the nearest account from the one been created
            //e.g.: for 41019 search for 4, 41, 410, 4101
            //and stop when the account doesn't exist, use last account found instead
            for (int i = 1; i<number.length(); i++) {
                try {
                    //get the parent account from the new account subnumber
                    parentAccount = accountService.getAccountByNumber(number.substring(0, i));
                } catch (LimaException eee) {
                    log.debug("Can't search account : " + number.substring(0, i), eee);
                }
                if (parentAccount == null) {
                    try {
                        //if the account is null, get the previous account searched then stop the loop
                        parentAccount = accountService.getAccountByNumber(number.substring(0, i-1));
                        break;
                    } catch (LimaException eee) {
                        log.debug("Can't search account : " + number.substring(0, i-1), eee);
                    }
                }
            }
            
            // add it
            try {
                accountsTreeTableModel.addAccount(parentAccount, newAccount);
            } catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add account", eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());

            } 
            
            catch (LimaException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add account", ex);
                }
                ErrorHelper.showErrorDialog(_("lima.account.addaccounterror"), ex);
            }
        }
    };
    
    public void addSubLedger(){
        
        JXTreeTable accountsTreeTable = view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel =
            (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();
        Account newAccount = new AccountImpl();
        SubLedgerForm subledgerForm = new SubLedgerForm(view);
        subledgerForm.setAccount(newAccount);
        // jaxx constructor don't call super() ?
        subledgerForm.setLocationRelativeTo(view);
        subledgerForm.setVisible(true);
        newAccount=subledgerForm.getAccount();
        
        // null == cancel action
        if (newAccount != null) {
            Account parentAccount = new AccountImpl();
            String number = newAccount.getAccountNumber();
             
            //search for the nearest account from the one been created
            //e.g.: for 41019 search for 4, 41, 410, 4101
            //and stop when the account doesn't exist, use last account found instead
            for (int i = 1; i<=number.length(); i++) {
                try {
                    //get the parent account from the new account subnumber
                    parentAccount = accountService.getAccountByNumber(number.substring(0, i));
                } catch (LimaException eee) {
                    log.debug("Can't search account : " + number.substring(0, i), eee);
                }
                if (parentAccount == null) {
                    try {
                        //if the account is null, get the previous account searched then stop the loop
                        parentAccount = accountService.getAccountByNumber(number.substring(0, i-1));
                        break;
                    } catch (LimaException eee) {
                        log.debug("Can't search account : " + number.substring(0, i-1), eee);
                    }
                }
            }
             
            // add it
            try {
                accountsTreeTableModel.addSubLedger(parentAccount, newAccount);
            } catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add subledger", eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            } 
             
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add subledger", eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        }
    }

    /**
     * Open account form with selected account.
     * Verifiy if it's an account or a subledger
     */
    public void updateAccount() {
        JXTreeTable accountsTreeTable = view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel =
            (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();

        // get selected account
        int selectedRow = view.getAccountsTreeTable().getSelectedRow();
        TreePath treePath = view.getAccountsTreeTable().getPathForRow(selectedRow); // not null
        Account selectedObject = (Account)treePath.getLastPathComponent();   
            //update Account or update SubLedger
            if (selectedObject != null) {
                // get current selection path
                if ( selectedRow != -1) {
                    treePath = view.getAccountsTreeTable().getPathForRow(selectedRow);
                } else {
                    treePath = new TreePath(accountsTreeTableModel.getRoot());
                }
                //test if selectedrow is account or ledger      
                if (selectedObject.getGeneralLedger()==null) {
                    UpdateAccountForm accountForm = new UpdateAccountForm(view);
                    accountForm.setAccount(selectedObject);
                    // jaxx constructor don't call super() ?
                    accountForm.setLocationRelativeTo(view);
                    accountForm.setVisible(true);
                    // null == cancel action
                    selectedObject = accountForm.getAccount();
                }
                // else is a subledger
                else {
                    UpdateSubLedgerForm subLedgerForm = new UpdateSubLedgerForm(view);
                    subLedgerForm.setAccount(selectedObject);
                    // jaxx constructor don't call super() ?
                    subLedgerForm.setLocationRelativeTo(view);
                    subLedgerForm.setVisible(true);
                    // null == cancel action
                    selectedObject = subLedgerForm.getAccount();
                }
                //if action confirmed
                if (selectedObject != null) {
                    // update it
                    try {
                        accountsTreeTableModel.
                            updateAccount(selectedObject);                            
                    } catch (LimaException eee) {
                        if (log.isErrorEnabled()) {
                            log.error("Can't add update", eee);
                        }
                        DialogHelper.showMessageDialog(eee.getMessage());
                    }
                }
            }
    
    }

    /**
     * Ask for user to remove for selected account, and remove it if confirmed.
     */
    public void removeAccount() {

        // maybe this code can be factorised
        JXTreeTable accountsTreeTable = view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel =
            (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();

        // Any row selected
        int selectedRow = view.getAccountsTreeTable().getSelectedRow();
        if ( selectedRow != -1) {
            int n = JOptionPane.showConfirmDialog(view,
                    _("lima.charts.account.question.remove"),
                    _("lima.common.question"),
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
            if (n == JOptionPane.YES_OPTION) {
                // update view of treetable
                TreePath treePath = view.getAccountsTreeTable().
                    getPathForRow(selectedRow);
                Account account = (Account) treePath.getLastPathComponent();

                try{
                    accountsTreeTableModel.removeAccount(treePath, account);
                } catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't delete account", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }
    
    public void refresh(){
        JXTreeTable accountsTreeTable = view.getAccountsTreeTable();
        AccountTreeTableModel accountsTreeTableModel =
            (AccountTreeTableModel)accountsTreeTable.getTreeTableModel();
         try {
             accountsTreeTableModel.refreshTree();
        } catch (LimaException eee) {
            if(log.isDebugEnabled()){
                log.debug("Can't refresh model", eee);
            }
        }
        //refresh view
        view.repaint();
   }
    
    public void importAccountsChart(){
        
                AccountImportForm form = new AccountImportForm();
                //
                form.setLocationRelativeTo(view);
                form.setVisible(true);
                
                ImportExport importExport = ImportExport.getInstance(view);

                Object value = form.getRadioButtons().getSelectedValue();
                // if action confirmed
                if (value != null){
                    AccountsChartEnum defaultAccountsChartEnum =
                        (AccountsChartEnum) value;
                    //Import accounts chart
                    switch (defaultAccountsChartEnum) {
                    case IMPORTEBP:
                        importExport.importExport(ImportExportEnum.EBP_ACCOUNTCHARTS_IMPORT,
                                defaultAccountsChartEnum.getFilePath(), false);
                        break;

                    default:
                        importExport.importExport(ImportExportEnum.CSV_ACCOUNTCHARTS_IMPORT,
                                defaultAccountsChartEnum.getFilePath(), false);
                        break;
                    }
                }
    }
    
    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        
        if (methodeName.contains("importAccounts") || methodeName.contains("importAll") || methodeName.contains("importAsCSV")){
            refresh();
        }
    }
    
}
